/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.DefaultTableModel;
import org.I00acres.isql.util.SimpleTableFilter;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.util.StringTokenizer;

public class ExcelTableFilter
extends SimpleTableFilter {
    private static final int BIFF2_TYPE = 9;
    private static final int BIFF3_TYPE = 521;
    private static final int BIFF4_TYPE = 1033;
    private static final int BIFF5_8_TYPE = 2057;
    private Vector formats = new Vector();
    private Vector xformats = new Vector();
    private StringBuffer sbuf = new StringBuffer();
    private int totalread = 0;
    private Vector SSTArray;

    protected void addExportProperties() {
    }

    protected void addImportProperties() {
        this.addImportProperty(iSQLUtilites.getString("Excel_Imp_Row_As_Columns"), null, "-2", false, iSQLUtilites.getString("Excel_Imp_Row_As_Columns_Tip"));
    }

    public String getName() {
        return iSQLUtilites.getString("Excel_Handler_Name");
    }

    public boolean isImportable() {
        return true;
    }

    public boolean isExportable() {
        return false;
    }

    public String getContentType() {
        return "application/vnd.ms-excel";
    }

    public Icon getUserIcon() {
        return iSQLUtilites.loadIconResource("Xcel16");
    }

    public int filter(DefaultTableModel tm, InputStream is) throws IOException, InterruptedException {
        int totalbytes = is.available();
        int nameRow = this.config.getIntProperty(this.getPropertyInfo((int)0, (boolean)true).name, -2);
        Vector<Object> cids = new Vector<Object>(0, 1);
        int op = 0;
        int ln = 0;
        int row = 0;
        int col = 0;
        int c = 0;
        boolean dset = false;
        boolean isBOF = false;
        try {
            block20: while (true) {
                this.checkIfCancelled();
                block21: while (!isBOF) {
                    switch (op) {
                        case 9: 
                        case 521: 
                        case 1033: 
                        case 2057: {
                            ln = this.readShort(is);
                            if (this.isBOF(op, ln)) {
                                isBOF = true;
                                break;
                            }
                            op = ln;
                            break;
                        }
                        default: {
                            op = this.read(is);
                            if (op != 9) continue block21;
                            op = ((op & 0xFF) << 0) + ((this.read(is) & 0xFF) << 8);
                        }
                    }
                }
                isBOF = false;
                do {
                    if (op == 10 && op != -1) continue block20;
                    this.checkIfCancelled();
                    this.fireFilterProgress((int)((double)this.totalread / (double)totalbytes * 100.0));
                    switch (op) {
                        case 9: {
                            this.skip(is, ln);
                            break;
                        }
                        case 521: {
                            this.skip(is, ln);
                            break;
                        }
                        case 1033: {
                            this.skip(is, ln);
                            break;
                        }
                        case 2057: {
                            this.skip(is, ln);
                            break;
                        }
                        case 0: 
                        case 512: {
                            if (ln == 8 && !dset) {
                                this.readShort(is);
                                tm.setRowCount(this.readShort(is));
                                this.readShort(is);
                                tm.setColumnCount(this.readShort(is));
                                dset = true;
                            } else if (ln == 14 && !dset) {
                                this.skip(is, 4L);
                                tm.setRowCount(this.readShort(is));
                                this.skip(is, 4L);
                                tm.setColumnCount(this.readShort(is));
                                this.skip(is, 2L);
                                dset = true;
                            } else if (ln == 10 && !dset) {
                                this.skip(is, 2L);
                                tm.setRowCount(this.readShort(is));
                                this.skip(is, 2L);
                                tm.setColumnCount(this.readShort(is));
                                this.skip(is, 2L);
                                dset = true;
                            } else {
                                this.skip(is, ln);
                            }
                            dset = true;
                            break;
                        }
                        case 3: 
                        case 515: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            if (op == 3) {
                                this.skip(is, 3L);
                            } else {
                                this.skip(is, 2L);
                            }
                            double d = this.readDouble(is);
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(Double.toString(d));
                                break;
                            }
                            tm.setValueAt(new Double(d), row, col);
                            break;
                        }
                        case 4: 
                        case 516: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            if (op == 4) {
                                this.skip(is, 3L);
                            } else {
                                this.skip(is, 2L);
                            }
                            c = op == 4 ? this.read(is) : this.readShort(is);
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(this.readUTFBody(is, c));
                                break;
                            }
                            tm.setValueAt(this.readUTFBody(is, c), row, col);
                            break;
                        }
                        case 2: 
                        case 638: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            if (op == 2) {
                                this.skip(is, 3L);
                            } else {
                                this.skip(is, 2L);
                            }
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(Integer.toString(this.readShort(is)));
                                break;
                            }
                            if (op == 2) {
                                tm.setValueAt(new Integer(this.readShort(is)), row, col);
                                break;
                            }
                            tm.setValueAt(this.readRKInteger(is), row, col);
                            break;
                        }
                        case 253: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            this.skip(is, 2L);
                            int sstidx = this.readInteger(is);
                            if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                cids.add(this.SSTArray.get(sstidx));
                                break;
                            }
                            try {
                                tm.setValueAt(this.SSTArray.get(sstidx), row, col);
                            }
                            catch (Exception exception) {}
                            break;
                        }
                        case 189: {
                            row = this.readShort(is);
                            col = this.readShort(is);
                            int i = 0;
                            while (i < (ln - 6) / 6) {
                                this.skip(is, 2L);
                                if (this.isColumnIdentifer(row, nameRow, tm.getRowCount())) {
                                    cids.add(this.readRKInteger(is));
                                } else {
                                    tm.setValueAt(this.readRKInteger(is), row, col + i);
                                }
                                ++i;
                            }
                            this.readShort(is);
                            break;
                        }
                        case 252: {
                            int totalstrings = this.readInteger(is);
                            int nmstrs = this.readInteger(is);
                            System.out.println(Integer.toHexString(this.totalread));
                            this.readSSTArray(is, nmstrs, totalstrings, ln - 8);
                            break;
                        }
                        default: {
                            this.skip(is, ln);
                        }
                    }
                    op = this.readShort(is);
                    if (op != -1) continue;
                    return 0;
                } while ((ln = this.readShort(is)) != -1);
                break;
            }
            return 0;
        }
        catch (EOFException eOFException) {
            if (!cids.isEmpty()) {
                tm.setColumnIdentifiers(cids);
                if (nameRow == -1) {
                    tm.removeRow(tm.getRowCount() - 1);
                } else if (nameRow >= 0) {
                    tm.removeRow(nameRow);
                }
            }
            return 0;
        }
    }

    public boolean isColumnIdentifer(int row, int sentinalrow, int maxrows) {
        if (sentinalrow <= -2) {
            return false;
        }
        return row == sentinalrow || sentinalrow == -1 && row == maxrows - 1;
    }

    public int filter(Object data, OutputStream os) throws IOException {
        return 0;
    }

    public void skip(InputStream is, long l) throws IOException {
        is.skip(l);
        this.totalread = (int)((long)this.totalread + l);
    }

    private int read(InputStream is) throws IOException {
        int r = is.read();
        if (r == -1) {
            throw new EOFException();
        }
        ++this.totalread;
        return r;
    }

    private void readSSTArray(InputStream is, int nm, int sz, int len) throws IOException {
        if (this.SSTArray == null) {
            this.SSTArray = new Vector(sz);
        }
        StringTokenizer st = new StringTokenizer(this.readUTFBody(is, len), "\u0000\u0001", false);
        int i = 0;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken().trim();
            if (tok.length() < 1) continue;
            this.SSTArray.add(tok);
            ++i;
        }
    }

    private Number readRKInteger(InputStream is) throws IOException {
        boolean isFloat;
        int x = this.readInteger(is);
        boolean x100 = (x & 1) == 1;
        boolean bl = isFloat = (x & 2) != 2;
        if (isFloat) {
            return new Float((double)((x & 0xFFFFFFFC) >> 2) * (x100 ? 0.01 : 1.0));
        }
        if (x100) {
            return new Float((double)((x & 0xFFFFFFFC) >> 2) * 0.01);
        }
        return new Integer((x & 0xFFFFFFFC) >> 2);
    }

    private boolean isBOF(int op, int len) {
        switch (op) {
            case 9: {
                return len == 4;
            }
            case 521: 
            case 1033: {
                return len == 6;
            }
            case 2057: {
                return len == 16 || len == 8;
            }
        }
        return false;
    }

    private int readShort(InputStream is) throws IOException {
        return ((this.read(is) & 0xFF) << 0) + ((this.read(is) & 0xFF) << 8);
    }

    private int readInteger(InputStream is) throws IOException {
        return ((this.read(is) & 0xFF) << 0) + ((this.read(is) & 0xFF) << 8) + ((this.read(is) & 0xFF) << 16) + ((this.read(is) & 0xFF) << 24);
    }

    private long readLong(InputStream is) throws IOException {
        return (((long)this.read(is) & 0xFFL) << 0) + (((long)this.read(is) & 0xFFL) << 8) + (((long)this.read(is) & 0xFFL) << 16) + (((long)this.read(is) & 0xFFL) << 24) + (((long)this.read(is) & 0xFFL) << 32) + (((long)this.read(is) & 0xFFL) << 40) + (((long)this.read(is) & 0xFFL) << 48) + (((long)this.read(is) & 0xFFL) << 56);
    }

    private double readDouble(InputStream is) throws IOException {
        return Double.longBitsToDouble(this.readLong(is));
    }

    private String readUTFBody(InputStream is, int utflen) throws IOException {
        this.sbuf.setLength(0);
        int i = 0;
        while (i < utflen) {
            this.sbuf.append((char)this.read(is));
            ++i;
        }
        return this.sbuf.toString();
    }
}

