/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.DriverPropertyInfo;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.DefaultTableModel;
import org.I00acres.isql.util.TableFilter;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.util.xProperties;

public abstract class SimpleTableFilter
implements TableFilter {
    protected static final String[] CHOICE_BOOLEAN = new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()};
    protected ActionListener listener = null;
    protected xProperties config;
    private Vector ePropsContainer;
    private Vector iPropsContainer;
    private DriverPropertyInfo[] properties;
    private Class acceptableClass;

    public SimpleTableFilter() {
        this(0);
    }

    public SimpleTableFilter(int size) {
        this(size, null);
    }

    public SimpleTableFilter(Properties defaults) {
        this(((Hashtable)defaults).size(), defaults);
    }

    public boolean isFileRequired() {
        return true;
    }

    public SimpleTableFilter(int size, Properties defaults) {
        this.ePropsContainer = new Vector(size);
        this.iPropsContainer = new Vector(size);
        this.config = defaults != null ? new xProperties(defaults) : new xProperties();
        this.addImportProperties();
        this.addExportProperties();
    }

    protected void addBooleanImportProperty(String name, String value, boolean isRequired, String desc) {
        this.addProperty(name, CHOICE_BOOLEAN, value, isRequired, desc, true);
    }

    protected void addBooleanExportProperty(String name, String value, boolean isRequired, String desc) {
        this.addProperty(name, CHOICE_BOOLEAN, value, isRequired, desc, false);
    }

    protected int addImportProperty(String name, String[] choices, String value, boolean isRequired, String desc) {
        return this.addProperty(name, choices, value, isRequired, desc, true);
    }

    protected int addExportProperty(String name, String[] choices, String value, boolean isRequired, String desc) {
        return this.addProperty(name, choices, value, isRequired, desc, false);
    }

    protected int addProperty(String name, String[] choices, String value, boolean isRequired, String desc, boolean isImportProperty) {
        try {
            DriverPropertyInfo prop = new DriverPropertyInfo(name, value);
            prop.required = isRequired;
            prop.choices = choices;
            prop.description = desc;
            if (isImportProperty) {
                this.iPropsContainer.add(prop);
            } else {
                this.ePropsContainer.add(prop);
            }
            if (choices == null) {
                this.config.setStringProperty(name, value == null ? "" : value);
            }
            return 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public void setProgressListener(ActionListener al) {
        if (this.listener == null) {
            this.listener = al;
        }
    }

    public void removeProgressListener(ActionListener al) {
        if (this.listener.equals(al)) {
            this.listener = null;
        }
    }

    public final DriverPropertyInfo getPropertyInfo(int idx, boolean isImportProperty) {
        try {
            if (isImportProperty) {
                return (DriverPropertyInfo)this.iPropsContainer.get(idx);
            }
            return (DriverPropertyInfo)this.ePropsContainer.get(idx);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void setExportableClass(Class cls) {
        this.acceptableClass = cls;
    }

    public Icon getUserIcon() {
        return iSQLUtilites.loadIconResource("Applet16");
    }

    public String getName() {
        return "";
    }

    public final DriverPropertyInfo[] getExportProperties() {
        return this.ePropsContainer.toArray(new DriverPropertyInfo[0]);
    }

    public final DriverPropertyInfo[] getImportProperties() {
        return this.iPropsContainer.toArray(new DriverPropertyInfo[0]);
    }

    public final void configure(Properties props) {
        ((Hashtable)this.config).clear();
        ((Hashtable)this.config).putAll(props);
    }

    public final Properties getConfiguration() {
        return this.config;
    }

    public boolean canFilterObject(Object o) {
        return this.acceptableClass.isInstance(o);
    }

    public final int filter(DefaultTableModel tm, File f) throws IOException, InterruptedException {
        if (f != null) {
            if (f.isDirectory()) {
                throw new IllegalArgumentException(iSQLUtilites.getString("Directory_Argument_Unsupported"));
            }
            return this.filter(tm, new FileInputStream(f));
        }
        return this.filter(tm, (InputStream)null);
    }

    public final int filter(Object o, File f) throws IOException, InterruptedException {
        if (f != null) {
            if (f.isDirectory()) {
                throw new IllegalArgumentException(iSQLUtilites.getString("Directory_Argument_Unsupported"));
            }
            return this.filter(o, new FileOutputStream(f));
        }
        return this.filter(o, (OutputStream)null);
    }

    protected void fireFilterProgress(int Progress) {
        this.fireFilterProgress(Progress, "");
    }

    protected void fireFilterProgress(int Progress, String Message) {
        if (this.listener != null) {
            this.listener.actionPerformed(new ActionEvent(this, Progress, Message));
        }
    }

    protected final void checkIfCancelled() throws InterruptedException {
        Thread.currentThread();
        Thread.sleep(15L);
    }

    public abstract boolean isExportable();

    public abstract boolean isImportable();

    public abstract String getContentType();

    public abstract int filter(Object var1, OutputStream var2) throws IOException, InterruptedException;

    public abstract int filter(DefaultTableModel var1, InputStream var2) throws IOException, InterruptedException;

    protected abstract void addImportProperties();

    protected abstract void addExportProperties();
}

