/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.swing;

import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import org.I00acres.lib.swing.AbstractItemAction;
import org.I00acres.lib.swing.ActionManager;

public abstract class UIMenuBar
extends JMenuBar {
    protected ActionManager manager;

    public UIMenuBar(ActionManager manager) {
        this.manager = manager;
        this.configureMenu();
    }

    protected abstract void configureMenu();

    protected ActionManager getManager() {
        return this.manager;
    }

    protected JMenu createMenu(String name, char mnemonic) {
        JMenu menu = new JMenu(name);
        menu.setMnemonic(mnemonic);
        return menu;
    }

    public void addMenuItem(JMenu menu, Action action) {
        JMenuItem menuItem = menu.add(action);
        this.configureMenuItem(menuItem, action);
    }

    public void addMenuItem(JPopupMenu menu, Action action) {
        JMenuItem menuItem = menu.add(action);
        this.configureMenuItem(menuItem, action);
    }

    protected void addCheckBoxMenuItem(JMenu menu, AbstractItemAction a) {
        this.addCheckBoxMenuItem(menu, a, false);
    }

    protected void addCheckBoxMenuItem(JMenu menu, AbstractItemAction a, boolean selected) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(a);
        mi.addItemListener(a);
        mi.setSelected(selected);
        menu.add(mi);
        this.configureMenuItem(mi, a);
    }

    protected void addRadioButtonMenuItem(JMenu menu, ButtonGroup group, Action a) {
        this.addRadioButtonMenuItem(menu, group, a, false);
    }

    protected void addRadioButtonMenuItem(JMenu menu, ButtonGroup group, Action a, boolean selected) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(a);
        mi.setSelected(selected);
        menu.add(mi);
        group.add(mi);
        this.configureMenuItem(mi, a);
    }

    protected void configureMenuItem(JMenuItem menuItem, Action action) {
        try {
            menuItem.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        }
        catch (Exception exception) {}
    }
}

