/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.swing;

import java.awt.Dimension;
import java.awt.Insets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import org.I00acres.lib.swing.AbstractItemAction;
import org.I00acres.lib.swing.ActionManager;

public class UIToolBar
extends JToolBar {
    protected static int size = 24;
    protected ArrayList actionList = new ArrayList(1);
    protected ActionManager manager;
    private Dimension buttonSize;
    private Insets buttonInsets;

    public static final synchronized void updateIconSize(int sz) {
        size = sz != 24 || sz != 16 ? 24 : sz;
    }

    public UIToolBar(ActionManager manager) {
        this.manager = manager;
        this.buttonSize = new Dimension(size, size);
        this.buttonInsets = new Insets(0, 0, 0, 0);
        this.setName("iSQL-Viewer ToolBar");
        this.addButtons();
    }

    protected void addButtons() {
    }

    protected ActionManager getManager() {
        return this.manager;
    }

    public void setActionEnabled(boolean enabled) {
        Iterator itr = ((AbstractList)this.actionList).iterator();
        while (itr.hasNext()) {
            Action action = (Action)itr.next();
            action.setEnabled(enabled);
        }
    }

    public void addButton(Action action) {
        JButton button = this.add(action);
        this.configureButton(button, action);
        this.actionList.add(action);
    }

    protected void addToggleButton(AbstractItemAction a) {
        JToggleButton button = new JToggleButton(a);
        button.addItemListener(a);
        button.setSelected(a.isSelected());
        this.add(button);
        this.configureButton(button, a);
    }

    protected void configureButton(AbstractButton button, Action action) {
        try {
            String s = action.getValue("Name").toString();
            button.setIcon(this.manager.getIcon(s, size, "png"));
        }
        catch (Exception exception) {}
        button.setText("");
        button.setActionCommand(action.getValue("ActionCommandKey").toString());
        button.setAlignmentY(0.5f);
        button.setMargin(this.buttonInsets);
        button.addMouseListener(this.manager);
    }
}

