/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.OdbcConnection;
import IT.picosoft.jdbc.PicoConnection;
import IT.picosoft.jdbc.PicoDbApi;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class PicoDriver
implements Driver {
    protected static PicoDbApi odbcApi;
    protected static int hEnv;
    protected static Hashtable connectionList;

    public PicoDriver() {
        odbcApi = null;
        hEnv = 0;
        connectionList = new Hashtable();
    }

    public void closeConnection(OdbcConnection odbcConnection) throws SQLException {
        odbcConnection.close();
        Object v = connectionList.remove(odbcConnection);
        if (connectionList.size() == 0 && hEnv != 0) {
            odbcApi.SQLFreeEnv(hEnv);
            hEnv = 0;
        }
    }

    public synchronized Connection connect(String string, Properties properties) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PicoDriver.connect (" + string + ") nConn=" + connectionList.size());
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        PicoConnection picoConnection = new PicoConnection(hEnv, this);
        picoConnection.initialize(PicoDriver.getSubName(string), properties, DriverManager.getLoginTimeout());
        picoConnection.setURL(string);
        connectionList.put(picoConnection.getHDBC(), new Integer(hEnv));
        return picoConnection;
    }

    public Hashtable getAttributeProperties(String string) {
        int n = 0;
        boolean bl = false;
        int n2 = 0;
        Hashtable<Integer, DriverPropertyInfo> hashtable = new Hashtable<Integer, DriverPropertyInfo>();
        int n3 = string.length();
        while (n < n3) {
            boolean bl2 = true;
            String string2 = null;
            String string3 = null;
            String[] stringArray = null;
            String string4 = null;
            int n4 = string.indexOf(";", n);
            if (n4 < 0) {
                n4 = n3 + 1;
            }
            String string5 = string.substring(n, n4);
            int n5 = 0;
            int n6 = string5.indexOf(":", 0);
            int n7 = string5.indexOf("=", 0);
            if (string5.startsWith("*")) {
                bl2 = false;
                ++n5;
            }
            if (n6 > 0) {
                string2 = string5.substring(n5, n6);
            }
            if (n6 > 0 && n7 > 0) {
                string3 = string5.substring(n6 + 1, n7);
            }
            if (n7 > 0 && (string4 = string5.substring(n7 + 1)).equals("?")) {
                string4 = null;
            }
            if (string4 != null && string4.startsWith("{")) {
                stringArray = PicoDriver.listToArray(string4);
                string4 = null;
            }
            DriverPropertyInfo driverPropertyInfo = new DriverPropertyInfo(string2, string4);
            driverPropertyInfo.description = string3;
            driverPropertyInfo.required = bl2;
            driverPropertyInfo.choices = stringArray;
            hashtable.put(new Integer(n2), driverPropertyInfo);
            ++n2;
            n = n4 + 1;
        }
        return hashtable;
    }

    public int getMajorVersion() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PicoDriver.getMajorVersion()");
        }
        return 1;
    }

    public int getMinorVersion() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PicoDriver.getMinorVersion()");
        }
        return 6;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*PicoDriver.getPropertyInfo (" + string + ")");
        }
        if (!this.acceptsURL(string)) {
            return null;
        }
        if (!this.initialize()) {
            return null;
        }
        return new DriverPropertyInfo[0];
    }

    public static String getProtocol(String string) {
        String string2 = "";
        int n = string.indexOf(58);
        if (n >= 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String getSubName(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n + 1);
        }
        return string2;
    }

    public static String getSubProtocol(String string) {
        int n;
        String string2 = "";
        int n2 = string.indexOf(58);
        if (n2 >= 0 && (n = string.indexOf(58, n2 + 1)) >= 0) {
            string2 = string.substring(n2 + 1, n);
        }
        return string2;
    }

    private boolean initialize() throws SQLException {
        boolean bl = true;
        if (odbcApi == null) {
            try {
                odbcApi = new PicoDbApi();
            }
            catch (Exception exception) {
                if (DriverManager.getLogWriter() != null) {
                    DriverManager.println("Unable to load PicoDbApi library:" + exception);
                }
                bl = false;
            }
        }
        if (hEnv == 0) {
            try {
                hEnv = odbcApi.SQLAllocEnv();
            }
            catch (Exception exception) {
                if (DriverManager.getLogWriter() != null) {
                    DriverManager.println("Unable to allocate environment:" + exception);
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean jdbcCompliant() {
        return true;
    }

    public boolean acceptsURL(String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("acc. url=" + string);
            DriverManager.println("acc. prt=" + PicoDriver.getProtocol(string));
            DriverManager.println("acc. sub=" + PicoDriver.getSubProtocol(string));
        }
        return PicoDriver.getProtocol(string).equalsIgnoreCase("jdbc") && PicoDriver.getSubProtocol(string).equalsIgnoreCase("picoDB");
    }

    protected static String[] listToArray(String string) {
        String[] stringArray = null;
        Hashtable<Integer, String> hashtable = new Hashtable<Integer, String>();
        int n = 0;
        int n2 = 1;
        boolean bl = true;
        int n3 = string.length();
        if (!string.startsWith("{")) {
            return null;
        }
        if (!string.endsWith("}")) {
            return null;
        }
        while (n2 < n3) {
            int n4 = string.indexOf(",", n2);
            if (n4 < 0) {
                n4 = n3 - 1;
            }
            String string2 = string.substring(n2, n4);
            hashtable.put(new Integer(n), string2);
            ++n;
            n2 = n4 + 1;
        }
        stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string3;
            stringArray[i] = string3 = (String)hashtable.get(new Integer(i));
        }
        return stringArray;
    }

    protected static String makeConnectionString(Properties properties) {
        String string = "";
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = properties.getProperty(string2);
            if (string2.equalsIgnoreCase("user")) {
                string2 = "UID";
            }
            if (string2.equalsIgnoreCase("password")) {
                string2 = "PWD";
            }
            if (string3 == null) continue;
            string = string + ";" + string2 + "=" + string3;
        }
        return string;
    }

    static {
        block3: {
            if (DriverManager.getLogWriter() != null) {
                DriverManager.println("picoDB driver class loaded");
            }
            PicoDriver picoDriver = new PicoDriver();
            try {
                DriverManager.registerDriver(picoDriver);
            }
            catch (SQLException sQLException) {
                if (DriverManager.getLogWriter() == null) break block3;
                DriverManager.println("Unable to register driver:" + sQLException);
            }
        }
    }
}

