/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.I00acres.isql.forms.frmWarningViewer;
import org.I00acres.isql.swing.BatchControlEditor;
import org.I00acres.isql.swing.ProgressListCellRenderer;
import org.I00acres.isql.swing.WizardPanel;
import org.I00acres.isql.swing.table.BatchPreviewTableModel;
import org.I00acres.isql.swing.table.BatchProgressTableModel;
import org.I00acres.isql.swing.table.BatchTableModel;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.sql.BatchRunner;
import org.I00acres.lib.util.ExtensionFileFilter;
import org.I00acres.lib.util.StringTokenizer;
import org.I00acres.lib.util.StringUtilities;

public final class frmBatchRunner
extends JDialog
implements ActionListener {
    static iSQLConfig config = iSQLConfig.getInstance();
    private GridBagLayout gbl = new GridBagLayout();
    private WizardPanel mContentPanel = new WizardPanel();
    private WizardConfig mConfigPanel;
    private WizardFileSelect mFCPanel;
    private WizardPreview mPreviewPanel;
    private WizardProgress mProgressPanel;
    private JPanel mWizardToolBox = new JPanel(new GridLayout(1, 4, 2, 2));
    private JLabel mTitleLabel = new JLabel(iSQLUtilites.getString("BATCH_Home_Label"));
    private JButton mNextButton = new JButton(iSQLUtilites.getString("BATCH_Next_Text"), iSQLUtilites.loadIconResource("Forward24"));
    private JButton mPrevButton = new JButton(iSQLUtilites.getString("BATCH_Prev_Text"), iSQLUtilites.loadIconResource("Back24"));
    private JButton mExitButton = new JButton(iSQLUtilites.getString("Cancel"));
    private JButton mHomeButton = new JButton(iSQLUtilites.getString("BATCH_Home_Text"), iSQLUtilites.loadIconResource("Home24"));
    private Insets ins = new Insets(1, 1, 1, 1);
    BatchTableModel batchTableModel = new BatchTableModel();
    Vector BatchThreads = new Vector();

    private void initUI() throws Exception {
        this.getContentPane().add((Component)this.mContentPanel, "Center");
        this.getContentPane().add((Component)this.mWizardToolBox, "South");
        this.getContentPane().add((Component)this.mTitleLabel, "North");
        this.mConfigPanel = new WizardConfig();
        this.mContentPanel.add((Component)this.mConfigPanel, "Config");
        this.mFCPanel = new WizardFileSelect();
        this.mContentPanel.add((Component)this.mFCPanel, "Select");
        this.mPreviewPanel = new WizardPreview();
        this.mContentPanel.add((Component)this.mPreviewPanel, "Preview");
        this.mProgressPanel = new WizardProgress();
        this.mContentPanel.add((Component)this.mProgressPanel, "Progress");
        this.mContentPanel.showCard("Select");
        this.mNextButton.setActionCommand("Config");
        this.mPrevButton.setActionCommand("Select");
        this.mHomeButton.setEnabled(false);
        this.mPrevButton.setEnabled(false);
        this.mTitleLabel.setFont(this.mTitleLabel.getFont().deriveFont(1, 26.0f));
        this.mTitleLabel.setHorizontalTextPosition(2);
        this.mHomeButton.addActionListener(this);
        this.mPrevButton.addActionListener(this);
        this.mNextButton.addActionListener(this);
        this.mExitButton.addActionListener(this);
        this.mHomeButton.setToolTipText(iSQLUtilites.getString("BATCH_Home_Tip"));
        this.mPrevButton.setToolTipText(iSQLUtilites.getString("BATCH_Prev_Tip"));
        this.mNextButton.setToolTipText(iSQLUtilites.getString("BATCH_Next_Tip"));
        this.mExitButton.setToolTipText(iSQLUtilites.getString("BATCH_Cancel_Tip"));
        this.mWizardToolBox.add(this.mHomeButton);
        this.mWizardToolBox.add(this.mPrevButton);
        this.mWizardToolBox.add(this.mNextButton);
        this.mWizardToolBox.add(this.mExitButton);
    }

    public static final int showDialog(JFrame Owner) {
        frmBatchRunner dlg = new frmBatchRunner(Owner);
        dlg.show();
        return 0;
    }

    private frmBatchRunner(JFrame pParent) {
        super(pParent, iSQLUtilites.getString("Batch_Runner_Title"), false);
        try {
            this.initUI();
        }
        catch (Throwable t) {
            iSQLUtilites.HandleException(t, null, true);
        }
        ((Component)this).setSize(new Dimension(476, 480));
        this.validate();
        this.setLocationRelativeTo(this.getParent());
    }

    synchronized void initAllBatchThreads() {
        Vector vector = this.BatchThreads;
        synchronized (vector) {
            this.BatchThreads.clear();
            int i = 0;
            while (i < this.batchTableModel.getRowCount()) {
                try {
                    BatchRunner br = new BatchRunner((File)this.batchTableModel.getValueAt(i, 0), i, this.mPreviewPanel);
                    br.setProperties(config);
                    this.BatchThreads.addElement(br);
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        System.runFinalization();
    }

    synchronized void loadAllBatchThreads() {
        if (this.BatchThreads.isEmpty() && this.batchTableModel.getRowCount() >= 1) {
            this.initAllBatchThreads();
        }
        Vector vector = this.BatchThreads;
        synchronized (vector) {
            int i = 0;
            while (i < this.BatchThreads.size()) {
                BatchRunner br;
                BatchRunner batchRunner = br = (BatchRunner)this.BatchThreads.elementAt(i);
                synchronized (batchRunner) {
                    try {
                        br.loadStatements();
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
        }
        System.runFinalization();
    }

    synchronized void executeAllBatchThreads() {
        Vector vector = this.BatchThreads;
        synchronized (vector) {
            int i = 0;
            while (i < this.BatchThreads.size()) {
                BatchRunner br = (BatchRunner)this.BatchThreads.elementAt(i);
                if (br != null) {
                    BatchRunner batchRunner = br;
                    synchronized (batchRunner) {
                        try {
                            br.setConnection(config.getiSQLService(this.batchTableModel.getValueAt(i, 1).toString(), false));
                            br.execute((Boolean)this.batchTableModel.getValueAt(i, 2), (Boolean)this.batchTableModel.getValueAt(i, 3));
                        }
                        catch (Exception exception) {}
                    }
                }
                ++i;
            }
        }
        System.runFinalization();
    }

    synchronized void haltAllBatchThreads() {
        Vector vector = this.BatchThreads;
        synchronized (vector) {
            int i = 0;
            while (i < this.BatchThreads.size()) {
                BatchRunner br;
                BatchRunner batchRunner = br = (BatchRunner)this.BatchThreads.elementAt(i);
                synchronized (batchRunner) {
                    try {
                        br.halt();
                        br.join();
                        br = null;
                        System.gc();
                    }
                    catch (Exception exception) {}
                }
                ++i;
            }
            this.BatchThreads.clear();
        }
        System.runFinalization();
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src.equals(this.mPrevButton) || src.equals(this.mNextButton) || src.equals(this.mConfigPanel.mPreviewButton)) {
            String s = this.mContentPanel.getCurrentCard();
            if (s.equalsIgnoreCase("Progress") || s.equalsIgnoreCase("Preview")) {
                this.haltAllBatchThreads();
            }
            s = evt.getActionCommand();
            this.mContentPanel.showCard(s);
            if (s.equalsIgnoreCase("Select")) {
                this.mNextButton.setActionCommand("Config");
                this.mPrevButton.setActionCommand("Select");
                this.mTitleLabel.setText(iSQLUtilites.getString("BATCH_Home_Label"));
                this.mHomeButton.setEnabled(false);
                this.mPrevButton.setEnabled(false);
            } else if (s.equalsIgnoreCase("Config")) {
                this.mPrevButton.setActionCommand("Select");
                this.mNextButton.setActionCommand("Progress");
                this.mTitleLabel.setText(iSQLUtilites.getString("BATCH_Configure_Label"));
                this.mHomeButton.setEnabled(true);
                this.mPrevButton.setEnabled(true);
            } else if (s.equalsIgnoreCase("Preview")) {
                this.mPrevButton.setActionCommand("Config");
                this.mNextButton.setActionCommand("Progress");
                this.mTitleLabel.setText(iSQLUtilites.getString("BATCH_Preview_Label"));
                this.mHomeButton.setEnabled(true);
                this.mPrevButton.setEnabled(true);
                if (this.mConfigPanel.mCommentDelimInput.isEnabled()) {
                    config.setIntProperty("Batch.Comment.Style", 0);
                    config.setProperty("Batch.Comment.Char", this.mConfigPanel.mCommentDelimInput.getText());
                }
                if (this.mConfigPanel.mLiteralDelimInput.isEnabled()) {
                    config.setIntProperty("Batch.Literal.Style", 3);
                    config.getProperty("Batch.Literal.Char", this.mConfigPanel.mLiteralDelimInput.getText());
                }
                if (this.mConfigPanel.mStatementDelimInput.isEnabled()) {
                    config.setIntProperty("Batch.Seperator.Style", 0);
                    config.getProperty("Batch.Seperator.Char", this.mConfigPanel.mStatementDelimInput.getText());
                }
                this.mPreviewPanel.refreshall();
            } else if (s.equalsIgnoreCase("Progress")) {
                if (this.mConfigPanel.mCommentDelimInput.isEnabled()) {
                    config.setIntProperty("Batch.Comment.Style", 0);
                    config.setProperty("Batch.Comment.Char", StringUtilities.decode(this.mConfigPanel.mCommentDelimInput.getText()));
                }
                if (this.mConfigPanel.mLiteralDelimInput.isEnabled()) {
                    config.setIntProperty("Batch.Literal.Style", 3);
                    config.getProperty("Batch.Literal.Char", StringUtilities.decode(this.mConfigPanel.mLiteralDelimInput.getText()));
                }
                if (this.mConfigPanel.mStatementDelimInput.isEnabled()) {
                    config.setIntProperty("Batch.Seperator.Style", 0);
                    config.getProperty("Batch.Seperator.Char", StringUtilities.decode(this.mConfigPanel.mStatementDelimInput.getText()));
                }
                this.mPrevButton.setActionCommand("Config");
                this.mNextButton.setActionCommand("Select");
                this.mTitleLabel.setText(iSQLUtilites.getString("BATCH_Progress_Label"));
                this.mHomeButton.setEnabled(false);
                this.mPrevButton.setEnabled(false);
                this.mNextButton.setEnabled(false);
                this.mExitButton.setEnabled(false);
                this.mPreviewPanel.doBatch();
                this.loadAllBatchThreads();
                this.executeAllBatchThreads();
            }
        } else if (src.equals(this.mHomeButton)) {
            this.haltAllBatchThreads();
            this.mContentPanel.showCard("Select");
            this.mTitleLabel.setText(iSQLUtilites.getString("BATCH_Home_Label"));
            this.mNextButton.setActionCommand("Config");
            this.mPrevButton.setActionCommand("Select");
            this.mHomeButton.setEnabled(false);
            this.mPrevButton.setEnabled(false);
        } else if (src.equals(this.mExitButton)) {
            this.haltAllBatchThreads();
            this.dispose();
        }
    }

    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201 && !this.mProgressPanel.mProgressModel.isFinished() && this.mContentPanel.getCurrentCard().equalsIgnoreCase("Progress")) {
            JOptionPane.showMessageDialog(this, iSQLUtilites.getString("Premature_Withdrawl_Message"), iSQLUtilites.getString("Batch_Not_Finished"), 0);
            return;
        }
        if (e.getID() == 201) {
            this.haltAllBatchThreads();
        }
        super.processWindowEvent(e);
    }

    private class WizardConfig
    extends JPanel
    implements ActionListener {
        private ButtonGroup[] groups = new ButtonGroup[]{new ButtonGroup(), new ButtonGroup(), new ButtonGroup()};
        private JPanel mStyleEditorPanel;
        private JPanel mCommentOptions;
        private JPanel mQuoteOptions;
        private JPanel mGeneralOptions;
        private JTextField mStatementDelimInput;
        private JTextField mCommentDelimInput;
        private JTextField mLiteralDelimInput;
        private JButton mPreviewButton;
        private JRadioButton mUseNoQuotes;
        private JRadioButton mUseSingleQuotes;
        private JRadioButton mUseDoulbeQuotes;
        private JRadioButton mUseCustomQuotes;
        private JRadioButton mUseEOL;
        private JRadioButton mUseVariantChar;
        private JCheckBox mForceLowerCase;
        private JRadioButton mUseSlashSlash;
        private JRadioButton mUseSlashStar;
        private JRadioButton mUseSingleLine;
        private JRadioButton mUseNoComments;

        protected WizardConfig() throws Exception {
            this.mStyleEditorPanel = new JPanel(frmBatchRunner.this.gbl);
            this.mCommentOptions = new JPanel();
            this.mQuoteOptions = new JPanel();
            this.mGeneralOptions = new JPanel();
            this.mStatementDelimInput = new JTextField(6);
            this.mCommentDelimInput = new JTextField(6);
            this.mLiteralDelimInput = new JTextField(6);
            this.mPreviewButton = new JButton(iSQLUtilites.loadIconResource("ZoomIn24"));
            this.mUseNoQuotes = new JRadioButton();
            this.mUseSingleQuotes = new JRadioButton();
            this.mUseDoulbeQuotes = new JRadioButton();
            this.mUseCustomQuotes = new JRadioButton();
            this.mUseEOL = new JRadioButton();
            this.mUseVariantChar = new JRadioButton();
            this.mForceLowerCase = new JCheckBox();
            this.mUseSlashSlash = new JRadioButton();
            this.mUseSlashStar = new JRadioButton();
            this.mUseSingleLine = new JRadioButton();
            this.mUseNoComments = new JRadioButton();
            try {
                this.initUI();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent evt) {
            Object src = evt.getSource();
            if (src.equals(((frmBatchRunner)frmBatchRunner.this).mConfigPanel.mUseVariantChar)) {
                config.setIntProperty("Batch.Seperator.Style", 0);
                this.mStatementDelimInput.setText(config.getProperty("Batch.Seperator.Char", ";"));
                this.mStatementDelimInput.setEnabled(true);
            } else if (src.equals(this.mUseEOL)) {
                config.setIntProperty("Batch.Seperator.Style", 1);
                this.mStatementDelimInput.setEnabled(false);
            } else if (src.equals(this.mUseSlashSlash)) {
                config.setIntProperty("Batch.Comment.Style", 2);
                this.mCommentDelimInput.setEnabled(false);
            } else if (src.equals(this.mUseSlashStar)) {
                config.setIntProperty("Batch.Comment.Style", 3);
                this.mCommentDelimInput.setEnabled(false);
            } else if (src.equals(((frmBatchRunner)frmBatchRunner.this).mConfigPanel.mUseSingleLine)) {
                config.setIntProperty("Batch.Comment.Style", 0);
                this.mCommentDelimInput.setText(config.getProperty("Batch.Comment.Char", "#"));
                this.mCommentDelimInput.setEnabled(true);
            } else if (src.equals(((frmBatchRunner)frmBatchRunner.this).mConfigPanel.mUseNoComments)) {
                config.setIntProperty("Batch.Comment.Style", 1);
                this.mCommentDelimInput.setEnabled(false);
            } else if (src.equals(this.mUseDoulbeQuotes)) {
                config.setIntProperty("Batch.Literal.Style", 0);
                this.mLiteralDelimInput.setEnabled(false);
            } else if (src.equals(this.mUseNoQuotes)) {
                config.setIntProperty("Batch.Literal.Style", 1);
                this.mLiteralDelimInput.setEnabled(false);
            } else if (src.equals(this.mUseSingleQuotes)) {
                config.setIntProperty("Batch.Literal.Style", 2);
                this.mLiteralDelimInput.setEnabled(false);
            } else if (src.equals(this.mUseCustomQuotes)) {
                config.setIntProperty("Batch.Literal.Style", 3);
                this.mLiteralDelimInput.setText(config.getProperty("Batch.Literal.Char", "\""));
                this.mLiteralDelimInput.setEnabled(true);
            }
        }

        private synchronized void initUI() throws Exception {
            this.setLayout(frmBatchRunner.this.gbl);
            this.groups[0].add(this.mUseSlashSlash);
            this.groups[0].add(this.mUseNoComments);
            this.groups[0].add(this.mUseSlashStar);
            this.groups[0].add(this.mUseSingleLine);
            this.groups[1].add(this.mUseNoQuotes);
            this.groups[1].add(this.mUseDoulbeQuotes);
            this.groups[1].add(this.mUseSingleQuotes);
            this.groups[1].add(this.mUseCustomQuotes);
            this.groups[2].add(this.mUseEOL);
            this.groups[2].add(this.mUseVariantChar);
            this.mCommentOptions.setLayout(new GridLayout(5, 1, 2, 2));
            this.mCommentOptions.setBorder(new TitledBorder(iSQLUtilites.getString("BATCH_Select_Comment_Style")));
            this.mCommentOptions.add(this.mUseNoComments);
            this.mCommentOptions.add(this.mUseSlashSlash);
            this.mCommentOptions.add(this.mUseSlashStar);
            this.mCommentOptions.add(this.mUseSingleLine);
            this.mCommentOptions.add(this.mCommentDelimInput);
            this.mQuoteOptions.setLayout(new GridLayout(5, 1, 2, 2));
            this.mQuoteOptions.setBorder(new TitledBorder(iSQLUtilites.getString("BATCH_Select_Quote_Style")));
            this.mQuoteOptions.add(this.mUseNoQuotes);
            this.mQuoteOptions.add(this.mUseSingleQuotes);
            this.mQuoteOptions.add(this.mUseDoulbeQuotes);
            this.mQuoteOptions.add(this.mUseCustomQuotes);
            this.mQuoteOptions.add(this.mLiteralDelimInput);
            this.mGeneralOptions.setLayout(frmBatchRunner.this.gbl);
            this.mGeneralOptions.setBorder(new TitledBorder(iSQLUtilites.getString("BATCH_General_Properties")));
            this.mGeneralOptions.add((Component)this.mPreviewButton, new GridBagConstraints(2, 0, 1, 3, 1.0, 0.0, 12, 0, frmBatchRunner.this.ins, 0, 0));
            this.mGeneralOptions.add((Component)this.mForceLowerCase, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.mGeneralOptions.add((Component)this.mUseEOL, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.mGeneralOptions.add((Component)this.mUseVariantChar, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.mGeneralOptions.add((Component)this.mStatementDelimInput, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mGeneralOptions, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 18, 2, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mCommentOptions, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mQuoteOptions, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)new JLabel(""), new GridBagConstraints(0, 2, 2, 1, 0.0, 1.0, 18, 1, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)new JLabel(""), new GridBagConstraints(2, 0, 1, 2, 1.0, 0.0, 18, 1, frmBatchRunner.this.ins, 0, 0));
            this.mStatementDelimInput.setToolTipText(iSQLUtilites.getString("BATCH_Custom_Char_Tip"));
            this.mCommentDelimInput.setToolTipText(this.mStatementDelimInput.getToolTipText());
            this.mLiteralDelimInput.setToolTipText(this.mStatementDelimInput.getToolTipText());
            this.mPreviewButton.setActionCommand("Preview");
            this.mPreviewButton.addActionListener(frmBatchRunner.this);
            this.mPreviewButton.setText(iSQLUtilites.getString("BATCH_Preview"));
            this.mUseDoulbeQuotes.setText(iSQLUtilites.getString("BATCH_Double_Quote_Text"));
            this.mUseDoulbeQuotes.setToolTipText(iSQLUtilites.getString("BATCH_Double_Quote_Tip"));
            this.mUseSingleQuotes.setText(iSQLUtilites.getString("BATCH_Single_Quote_Text"));
            this.mUseSingleQuotes.setToolTipText(iSQLUtilites.getString("BATCH_Single_Quote_Tip"));
            this.mUseCustomQuotes.setText(iSQLUtilites.getString("BATCH_Custom_Quote_Text"));
            this.mUseCustomQuotes.setToolTipText(iSQLUtilites.getString("BATCH_Custom_Quote_Tip"));
            this.mUseEOL.setText(iSQLUtilites.getString("BATCH_EOL_Statement_Text"));
            this.mUseEOL.setToolTipText(iSQLUtilites.getString("BATCH_EOL_Statement_Tip"));
            this.mUseVariantChar.setText(iSQLUtilites.getString("BATCH_Custom_Delim_Text"));
            this.mUseVariantChar.setToolTipText(iSQLUtilites.getString("BATCH_Custom_Delim_Tip"));
            this.mUseSlashStar.setText(iSQLUtilites.getString("BATCH_Slash_Star_Text"));
            this.mUseSlashStar.setToolTipText(iSQLUtilites.getString("BATCH_Slash_Star_Tip"));
            this.mUseSlashSlash.setText(iSQLUtilites.getString("BATCH_Slash_Slash_Text"));
            this.mUseSlashSlash.setToolTipText(iSQLUtilites.getString("BATCH_Slash_Slash_Tip"));
            this.mUseNoComments.setText(iSQLUtilites.getString("BATCH_No_Comment_Text"));
            this.mUseNoComments.setToolTipText(iSQLUtilites.getString("BATCH_No_Comment_Tip"));
            this.mUseNoQuotes.setText(iSQLUtilites.getString("BATCH_No_Quote_Text"));
            this.mUseNoQuotes.setToolTipText(iSQLUtilites.getString("BATCH_No_Quote_Tip"));
            this.mUseSingleLine.setText(iSQLUtilites.getString("BATCH_Single_Line_Comment_Text"));
            this.mUseSingleLine.setToolTipText(iSQLUtilites.getString("BATCH_Single_Line_Comment_Tip"));
            this.mForceLowerCase.setText(iSQLUtilites.getString("BATCH_Force_Lower_Text"));
            this.mForceLowerCase.setToolTipText(iSQLUtilites.getString("BATCH_Force_Lower_Tip"));
            this.mUseDoulbeQuotes.addActionListener(this);
            this.mUseCustomQuotes.addActionListener(this);
            this.mUseEOL.addActionListener(this);
            this.mUseNoComments.addActionListener(this);
            this.mUseNoQuotes.addActionListener(this);
            this.mUseSingleLine.addActionListener(this);
            this.mUseSingleQuotes.addActionListener(this);
            this.mUseSlashSlash.addActionListener(this);
            this.mUseSlashStar.addActionListener(this);
            this.mUseVariantChar.addActionListener(this);
            switch (config.getIntProperty("Batch.Literal.Style", 0)) {
                case 1: {
                    this.mUseNoQuotes.setSelected(true);
                    this.mLiteralDelimInput.setEnabled(false);
                    break;
                }
                case 2: {
                    this.mUseSingleQuotes.setSelected(true);
                    this.mLiteralDelimInput.setEnabled(false);
                    break;
                }
                case 3: {
                    this.mUseCustomQuotes.setSelected(true);
                    this.mCommentDelimInput.setText(config.getProperty("Batch.Literal.Char", "\""));
                    this.mLiteralDelimInput.setEnabled(true);
                    break;
                }
                default: {
                    this.mUseDoulbeQuotes.setSelected(true);
                    this.mLiteralDelimInput.setEnabled(false);
                }
            }
            switch (config.getIntProperty("Batch.Seperator.Style", 0)) {
                case 1: {
                    this.mUseEOL.setSelected(true);
                    this.mStatementDelimInput.setEnabled(false);
                    this.mStatementDelimInput.setText("");
                    break;
                }
                default: {
                    this.mUseVariantChar.setSelected(true);
                    this.mStatementDelimInput.setText(config.getProperty("Batch.Seperator.Char", ";"));
                    this.mStatementDelimInput.setEnabled(true);
                }
            }
            switch (config.getIntProperty("Batch.Comment.Style", 0)) {
                case 1: {
                    this.mUseNoComments.setSelected(true);
                    this.mCommentDelimInput.setEnabled(false);
                    break;
                }
                case 2: {
                    this.mUseSlashSlash.setSelected(true);
                    this.mCommentDelimInput.setEnabled(false);
                    break;
                }
                case 3: {
                    this.mUseSlashStar.setSelected(true);
                    this.mCommentDelimInput.setEnabled(false);
                    break;
                }
                default: {
                    this.mUseSingleLine.setSelected(true);
                    this.mCommentDelimInput.setText(config.getProperty("Batch.Comment.Char", "#"));
                    this.mCommentDelimInput.setEnabled(true);
                }
            }
        }
    }

    private class WizardFileSelect
    extends JPanel
    implements ListSelectionListener,
    ActionListener {
        private File mCurrentScript = null;
        private JTable mFileList = new JTable();
        private JLabel mFileLabel = new JLabel();
        private JLabel mServiceLabel = new JLabel();
        private JButton mBrowseButton = new JButton(iSQLUtilites.getString("Elipsis"));
        private JButton mOpenButton = new JButton(iSQLUtilites.loadToolbarIconResource("Open"));
        private JButton mSaveButton = new JButton(iSQLUtilites.loadToolbarIconResource("Save"));
        private JButton mAddButton = new JButton(iSQLUtilites.loadToolbarIconResource("Add"));
        private JButton mDelButton = new JButton(iSQLUtilites.loadToolbarIconResource("Delete"));
        private JButton mSaveAsButton = new JButton(iSQLUtilites.loadToolbarIconResource("SaveAs"));
        private JButton mNewButton = new JButton(iSQLUtilites.loadToolbarIconResource("New"));
        private JScrollPane mFileListScroller = new JScrollPane(this.mFileList);
        private JPanel mOptionContainer = new JPanel(new GridLayout(2, 1, 0, 2));
        private JPanel mToolBoxContainer = new JPanel(new GridLayout(2, 3, 2, 2));
        private JTextField mBatchFileField = new JTextField(16);
        private JCheckBox mUseTransActions = new JCheckBox();
        private JCheckBox mOverrideSupport = new JCheckBox();
        private JComboBox mServiceSelector = new JComboBox<String>(iSQLConfig.getInstance().getAvailableServices());
        private JFileChooser mFileChooser = new JFileChooser(iSQLConfig.getiSQLSubDir("scripts"));

        protected WizardFileSelect() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                t.printStackTrace();
                return;
            }
            this.actionPerformed(new ActionEvent(this.mNewButton, 0, ""));
        }

        private synchronized void loadScript(File f) throws IOException {
            WizardFileSelect wizardFileSelect = this;
            synchronized (wizardFileSelect) {
                BufferedReader br = new BufferedReader(new FileReader(f));
                BatchTableModel model = new BatchTableModel();
                StringTokenizer st = new StringTokenizer("", File.pathSeparator, false, false);
                int Column = 0;
                int Row = 0;
                block7: while (br.ready()) {
                    st.setString(br.readLine());
                    model.addNewRow();
                    Row = model.getRowCount() - 1;
                    Column = 0;
                    while (st.hasMoreTokens()) {
                        try {
                            String Tok = st.nextToken();
                            model.setValueAt(Tok, Row, Column++);
                        }
                        catch (Exception exception) {
                            continue block7;
                        }
                    }
                }
                frmBatchRunner.this.setTitle(String.valueOf(iSQLUtilites.getString("Batch_Runner_Title")) + " :: " + f.getName());
                frmBatchRunner.this.batchTableModel = model;
                this.mFileList.setModel(frmBatchRunner.this.batchTableModel);
                this.mFileList.setAutoResizeMode(0);
                if (this.mFileList.getPreferredSize().getWidth() < this.mFileListScroller.getViewport().getPreferredSize().getWidth()) {
                    this.mFileList.setAutoResizeMode(4);
                }
                try {
                    st = null;
                    br.close();
                }
                catch (IOException iOException) {}
            }
            System.runFinalization();
        }

        private synchronized void saveScript(File f) throws IOException {
            WizardFileSelect wizardFileSelect = this;
            synchronized (wizardFileSelect) {
                if (!f.exists()) {
                    f.createNewFile();
                }
                frmBatchRunner.this.setTitle(String.valueOf(iSQLUtilites.getString("Batch_Runner_Title")) + " :: " + f.getName());
                BufferedWriter bw = new BufferedWriter(new FileWriter(f));
                int i = 0;
                while (i < this.mFileList.getRowCount()) {
                    bw.write(frmBatchRunner.this.batchTableModel.toRowString(i));
                    if (i != this.mFileList.getRowCount() - 1) {
                        bw.newLine();
                    }
                    ++i;
                }
                try {
                    bw.flush();
                    bw.close();
                    bw = null;
                }
                catch (IOException iOException) {}
            }
        }

        private synchronized void initUI() throws Exception {
            this.setLayout(frmBatchRunner.this.gbl);
            this.mFileList.setModel(frmBatchRunner.this.batchTableModel);
            this.mFileList.setRowSelectionAllowed(true);
            this.mFileList.setColumnSelectionAllowed(false);
            this.mFileList.getSelectionModel().addListSelectionListener(this);
            this.mFileLabel.setText(iSQLUtilites.getString("BATCH_Select_Batch_File"));
            this.mServiceLabel.setText(iSQLUtilites.getString("BATCH_Select_iSQL_Service"));
            this.mSaveButton.setToolTipText(iSQLUtilites.getString("BATCH_Save_Script_Tip"));
            this.mOpenButton.setToolTipText(iSQLUtilites.getString("BATCH_Open_Script_Tip"));
            this.mAddButton.setToolTipText(iSQLUtilites.getString("BATCH_Add_Batch_Tip"));
            this.mDelButton.setToolTipText(iSQLUtilites.getString("BATCH_Remove_Batch_Tip"));
            this.mSaveAsButton.setToolTipText(iSQLUtilites.getString("BATCH_Save_Script_As_Tip"));
            this.mNewButton.setToolTipText(iSQLUtilites.getString("BATCH_New_Script_Tip"));
            this.mBatchFileField.setToolTipText(iSQLUtilites.getString("BATCH_Batch_Name_Tip"));
            this.mBrowseButton.setToolTipText(iSQLUtilites.getString("Browse_File_System"));
            this.mUseTransActions.setToolTipText(iSQLUtilites.getString("BATCH_Use_Transaction_Tip"));
            this.mUseTransActions.setText(iSQLUtilites.getString("BATCH_Use_Transaction_Text"));
            this.mOverrideSupport.setToolTipText(iSQLUtilites.getString("BATCH_Override_Support_Tip"));
            this.mOverrideSupport.setText(iSQLUtilites.getString("BATCH_Override_Support_Text"));
            this.mServiceSelector.setToolTipText(iSQLUtilites.getString("BATCH_Batch_Service_Tip"));
            this.mSaveButton.addActionListener(this);
            this.mOpenButton.addActionListener(this);
            this.mAddButton.addActionListener(this);
            this.mDelButton.addActionListener(this);
            this.mNewButton.addActionListener(this);
            this.mSaveAsButton.addActionListener(this);
            this.mBatchFileField.addActionListener(this);
            this.mBrowseButton.addActionListener(this);
            this.mServiceSelector.addActionListener(this);
            this.mUseTransActions.addActionListener(this);
            this.mOverrideSupport.addActionListener(this);
            this.mToolBoxContainer.setBorder(new TitledBorder(iSQLUtilites.getString("BATCH_Script_Tools")));
            this.mToolBoxContainer.add(this.mOpenButton);
            this.mToolBoxContainer.add(this.mNewButton);
            this.mToolBoxContainer.add(this.mSaveButton);
            this.mToolBoxContainer.add(this.mDelButton);
            this.mToolBoxContainer.add(this.mAddButton);
            this.mToolBoxContainer.add(this.mSaveAsButton);
            this.mOptionContainer.setBorder(new TitledBorder(iSQLUtilites.getString("BATCH_Options")));
            this.mOptionContainer.add(this.mUseTransActions);
            this.mOptionContainer.add(this.mOverrideSupport);
            this.add((Component)this.mFileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mBatchFileField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, frmBatchRunner.this.ins, 5, 5));
            this.add((Component)this.mBrowseButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mServiceLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mServiceSelector, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 18, 2, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mToolBoxContainer, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mOptionContainer, new GridBagConstraints(1, 2, 2, 1, 0.0, 0.0, 18, 1, frmBatchRunner.this.ins, 0, 0));
            this.add((Component)this.mFileListScroller, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 18, 1, frmBatchRunner.this.ins, 0, 0));
            this.mFileChooser.addChoosableFileFilter(new ExtensionFileFilter("script", "iSQL-Viewer Script (*.script)"));
            this.mFileChooser.addChoosableFileFilter(new ExtensionFileFilter("txt", "Plain Text (*.txt)"));
            this.mFileChooser.addChoosableFileFilter(new ExtensionFileFilter("sql", "SQL Script (*.sql)"));
        }

        public void valueChanged(ListSelectionEvent evt) {
            boolean singleSelection = this.mFileList.getSelectedRows().length == 1;
            this.mBatchFileField.setEnabled(singleSelection);
            this.mBrowseButton.setEnabled(singleSelection);
            if (singleSelection) {
                int row = this.mFileList.getSelectedRow();
                this.mBatchFileField.setText(frmBatchRunner.this.batchTableModel.getValueAt(row, 0).toString());
                this.mServiceSelector.setSelectedItem(frmBatchRunner.this.batchTableModel.getValueAt(row, 1));
                this.mUseTransActions.setSelected((Boolean)frmBatchRunner.this.batchTableModel.getValueAt(row, 2));
                this.mOverrideSupport.setSelected((Boolean)frmBatchRunner.this.batchTableModel.getValueAt(row, 3));
            }
        }

        public void actionPerformed(ActionEvent evt) {
            block16: {
                int res;
                block25: {
                    Object src;
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    block20: {
                                        block19: {
                                            block18: {
                                                block17: {
                                                    block15: {
                                                        src = evt.getSource();
                                                        if (!src.equals(this.mAddButton)) break block15;
                                                        frmBatchRunner.this.batchTableModel.addNewRow();
                                                        this.mFileList.setRowSelectionInterval(this.mFileList.getRowCount() - 1, this.mFileList.getRowCount() - 1);
                                                        break block16;
                                                    }
                                                    if (!src.equals(this.mBrowseButton) || this.mFileList.getSelectedRow() == -1) break block17;
                                                    File f = (File)frmBatchRunner.this.batchTableModel.getValueAt(this.mFileList.getSelectedRow(), 0);
                                                    if (f.exists()) {
                                                        this.mFileChooser.setSelectedFile(f);
                                                    } else {
                                                        this.mFileChooser.setCurrentDirectory(iSQLConfig.getBaseDirectory());
                                                    }
                                                    int res2 = this.mFileChooser.showOpenDialog(this);
                                                    if (res2 != 0) break block16;
                                                    frmBatchRunner.this.batchTableModel.setValueAt(this.mFileChooser.getSelectedFile(), this.mFileList.getSelectedRow(), 0);
                                                    this.mBatchFileField.setText(this.mFileChooser.getSelectedFile().getAbsolutePath());
                                                    break block16;
                                                }
                                                if (!src.equals(this.mNewButton)) break block18;
                                                frmBatchRunner.this.batchTableModel.setNumRows(0);
                                                this.mCurrentScript = null;
                                                frmBatchRunner.this.batchTableModel.addNewRow();
                                                this.mFileList.setRowSelectionInterval(this.mFileList.getRowCount() - 1, this.mFileList.getRowCount() - 1);
                                                break block16;
                                            }
                                            if (!src.equals(this.mBatchFileField) || this.mFileList.getSelectedRow() == -1) break block19;
                                            frmBatchRunner.this.batchTableModel.setValueAt(new File(this.mBatchFileField.getText()), this.mFileList.getSelectedRow(), 0);
                                            break block16;
                                        }
                                        if (!src.equals(this.mServiceSelector) || this.mFileList.getSelectedRow() == -1) break block20;
                                        int[] rows = this.mFileList.getSelectedRows();
                                        int i = 0;
                                        while (i < rows.length) {
                                            frmBatchRunner.this.batchTableModel.setValueAt(this.mServiceSelector.getSelectedItem(), rows[i], 1);
                                            ++i;
                                        }
                                        break block16;
                                    }
                                    if (!src.equals(this.mUseTransActions) || this.mFileList.getSelectedRow() == -1) break block21;
                                    int[] rows = this.mFileList.getSelectedRows();
                                    int i = 0;
                                    while (i < rows.length) {
                                        frmBatchRunner.this.batchTableModel.setValueAt(new Boolean(this.mUseTransActions.isSelected()), rows[i], 2);
                                        ++i;
                                    }
                                    break block16;
                                }
                                if (!src.equals(this.mOverrideSupport) || this.mFileList.getSelectedRow() == -1) break block22;
                                int[] rows = this.mFileList.getSelectedRows();
                                int i = 0;
                                while (i < rows.length) {
                                    frmBatchRunner.this.batchTableModel.setValueAt(new Boolean(this.mOverrideSupport.isSelected()), rows[i], 3);
                                    ++i;
                                }
                                break block16;
                            }
                            if (!evt.getSource().equals(this.mDelButton) || this.mFileList.getSelectedRow() == -1) break block23;
                            int[] rows = this.mFileList.getSelectedRows();
                            int i = rows.length - 1;
                            while (i >= 0) {
                                frmBatchRunner.this.batchTableModel.removeRow(rows[i]);
                                --i;
                            }
                            try {
                                this.mFileList.setRowSelectionInterval(this.mFileList.getRowCount() - 1, this.mFileList.getRowCount() - 1);
                            }
                            catch (Exception exception) {}
                            break block16;
                        }
                        if (!src.equals(this.mSaveButton) || this.mCurrentScript == null) break block24;
                        try {
                            this.saveScript(this.mCurrentScript);
                        }
                        catch (IOException e) {
                            System.out.println(String.valueOf(iSQLUtilites.getString("Error_Writing_File")) + " :: " + this.mCurrentScript);
                            System.out.println(String.valueOf(iSQLUtilites.getString("Exception")) + " :: " + e);
                        }
                        break block16;
                    }
                    if (!src.equals(this.mSaveAsButton) && (!src.equals(this.mSaveButton) || this.mCurrentScript != null)) break block25;
                    String f = null;
                    int res3 = this.mFileChooser.showSaveDialog(this);
                    if (res3 != 0) break block16;
                    try {
                        f = this.mFileChooser.getSelectedFile().toString();
                        if (!f.endsWith(".script")) {
                            f = f.concat(".script");
                        }
                        this.mCurrentScript = new File(f);
                        this.saveScript(this.mCurrentScript);
                    }
                    catch (IOException e) {
                        System.out.println(String.valueOf(iSQLUtilites.getString("Error_Writing_File")) + " :: " + f);
                        System.out.println(String.valueOf(iSQLUtilites.getString("Exception")) + " :: " + e);
                    }
                    break block16;
                }
                if (!evt.getSource().equals(this.mOpenButton) || (res = this.mFileChooser.showOpenDialog(this)) != 0) break block16;
                try {
                    this.mCurrentScript = this.mFileChooser.getSelectedFile();
                    this.loadScript(this.mCurrentScript);
                }
                catch (IOException e) {
                    System.out.println(String.valueOf(iSQLUtilites.getString("Error_Reading_File")) + " :: " + this.mCurrentScript);
                    System.out.println(String.valueOf(iSQLUtilites.getString("Exception")) + " :: " + e);
                }
            }
        }
    }

    private class WizardPreview
    extends JPanel
    implements ActionListener {
        private BatchPreviewTableModel mPreviewModel = new BatchPreviewTableModel();
        private JPanel mPreviewToolBox = new JPanel(new GridLayout(2, 1, 2, 2));
        private JTable mPreviewList = new JTable(this.mPreviewModel);
        private JScrollPane mPreviewPane = new JScrollPane(this.mPreviewList);
        private JButton mRefreshAll = new JButton(iSQLUtilites.loadIconResource("Refresh24"));
        private JButton mRefreshOne = new JButton(iSQLUtilites.loadIconResource("Redo24"));

        public WizardPreview() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void actionPerformed(ActionEvent parm1) {
            block21: {
                Object src = parm1.getSource();
                if (src.equals(this.mRefreshAll)) {
                    this.refreshall();
                } else if (src.equals(this.mRefreshOne)) {
                    this.refreshselected();
                } else if (src instanceof BatchRunner) {
                    BatchRunner br = (BatchRunner)src;
                    if (parm1.getModifiers() == 2 && br.getBatchID() <= this.mPreviewModel.getRowCount() - 1) {
                        try {
                            this.mPreviewModel.setValueAt(parm1.getActionCommand(), br.getBatchID(), 1);
                        }
                        catch (Exception exception) {}
                    } else if (parm1.getModifiers() == 4 && br.getBatchID() <= ((frmBatchRunner)frmBatchRunner.this).mProgressPanel.mProgressModel.getRowCount() - 1) {
                        try {
                            ((frmBatchRunner)frmBatchRunner.this).mProgressPanel.mProgressModel.setValueAt(parm1.getActionCommand(), br.getBatchID(), 1);
                            if (Integer.parseInt(parm1.getActionCommand()) >= 100) {
                                if (br.getConnection() != null) {
                                    try {
                                        frmWarningViewer.addConnectionWarnings(br.getConnection().getConnectionWarnings());
                                    }
                                    catch (Throwable throwable) {}
                                }
                                try {
                                    br.halt();
                                }
                                catch (Exception exception) {}
                            }
                            if (!((frmBatchRunner)frmBatchRunner.this).mProgressPanel.mProgressModel.isFinished()) break block21;
                            frmBatchRunner.this.mHomeButton.setEnabled(true);
                            frmBatchRunner.this.mPrevButton.setEnabled(true);
                            frmBatchRunner.this.mNextButton.setEnabled(true);
                            frmBatchRunner.this.mExitButton.setEnabled(true);
                            Vector vector = frmBatchRunner.this.BatchThreads;
                            synchronized (vector) {
                                frmBatchRunner.this.BatchThreads.clear();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }

        private synchronized void initUI() throws Exception {
            this.setLayout(new BorderLayout());
            this.mPreviewToolBox.setBorder(new TitledBorder(iSQLUtilites.getString("BATCH_Preview_Tools")));
            this.mPreviewToolBox.add(this.mRefreshAll);
            this.mPreviewToolBox.add(this.mRefreshOne);
            this.mPreviewList.setSelectionMode(2);
            this.mPreviewList.setRowSelectionAllowed(true);
            this.mPreviewList.setColumnSelectionAllowed(false);
            this.mRefreshOne.addActionListener(this);
            this.mRefreshAll.addActionListener(this);
            this.mRefreshOne.setToolTipText(iSQLUtilites.getString("BATCH_Refresh_Selected_Tip"));
            this.mRefreshAll.setToolTipText(iSQLUtilites.getString("BATCH_Refresh_All_Tip"));
            this.add((Component)this.mPreviewToolBox, "North");
            this.add((Component)this.mPreviewPane, "Center");
        }

        public synchronized void refreshselected() {
            int[] rows = this.mPreviewList.getSelectedRows();
            int i = 0;
            while (i < rows.length) {
                try {
                    BatchRunner br;
                    int row = rows[i];
                    Vector vector = frmBatchRunner.this.BatchThreads;
                    synchronized (vector) {
                        BatchRunner batchRunner = br = (BatchRunner)frmBatchRunner.this.BatchThreads.get(row);
                        synchronized (batchRunner) {
                            br.halt();
                        }
                        this.mPreviewModel.setValueAt(String.valueOf(iSQLUtilites.getString("Refreshing_Data")) + "...", row, 1);
                    }
                    br.loadStatements();
                }
                catch (Exception exception) {}
                ++i;
            }
        }

        public synchronized void refreshall() {
            WizardPreview wizardPreview = this;
            synchronized (wizardPreview) {
                this.mPreviewModel.setNumRows(0);
                frmBatchRunner.this.haltAllBatchThreads();
                int i = 0;
                while (i < frmBatchRunner.this.batchTableModel.getRowCount()) {
                    this.mPreviewModel.addRow(new Object[]{frmBatchRunner.this.batchTableModel.getValueAt(i, 0), String.valueOf(iSQLUtilites.getString("Parsing_File")) + "..."});
                    ++i;
                }
                frmBatchRunner.this.loadAllBatchThreads();
            }
        }

        public synchronized void doBatch() {
            WizardPreview wizardPreview = this;
            synchronized (wizardPreview) {
                ((frmBatchRunner)frmBatchRunner.this).mProgressPanel.mProgressModel.setRowCount(0);
                int i = 0;
                while (i < frmBatchRunner.this.batchTableModel.getRowCount()) {
                    ((frmBatchRunner)frmBatchRunner.this).mProgressPanel.mProgressModel.addRow(new Object[]{frmBatchRunner.this.batchTableModel.getValueAt(i, 0), new Integer(0)});
                    ++i;
                }
            }
        }
    }

    private class WizardProgress
    extends JPanel
    implements TableModelListener,
    ActionListener {
        BatchProgressTableModel mProgressModel = new BatchProgressTableModel();
        JButton btn = new JButton(iSQLUtilites.loadToolbarIconResource("Stop"));
        JPanel mProgressToolBox = new JPanel(new GridLayout(1, 2, 2, 2));
        JTable mProgressTable = new JTable(this.mProgressModel);
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public WizardProgress() {
            try {
                this.initUI();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private synchronized void initUI() throws Exception {
            this.setLayout(new BorderLayout());
            this.mProgressTable.setRowHeight(24);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.Integer");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.mProgressTable.setDefaultRenderer(clazz, new ProgressListCellRenderer());
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.mProgressTable.setDefaultRenderer(clazz2, new BatchControlEditor());
            Class<?> clazz3 = class$1;
            if (clazz3 == null) {
                try {
                    clazz3 = class$1 = Class.forName("java.lang.Boolean");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.mProgressTable.setDefaultEditor(clazz3, new BatchControlEditor());
            this.mProgressModel.addTableModelListener(this);
            this.mProgressToolBox.setBorder(new TitledBorder(iSQLUtilites.getString("BATCH_Progress_Tools")));
            this.btn.setToolTipText(iSQLUtilites.getString("BATCH_Halt_All_Batch_Jobs"));
            this.btn.addActionListener(this);
            this.mProgressToolBox.add(this.btn);
            this.mProgressToolBox.add(new JLabel());
            this.add((Component)this.mProgressToolBox, "North");
            this.add((Component)new JScrollPane(this.mProgressTable), "Center");
        }

        public void actionPerformed(ActionEvent evt) {
            frmBatchRunner.this.haltAllBatchThreads();
            frmBatchRunner.this.mHomeButton.setEnabled(true);
            frmBatchRunner.this.mPrevButton.setEnabled(true);
            frmBatchRunner.this.mNextButton.setEnabled(true);
            frmBatchRunner.this.mExitButton.setEnabled(true);
            this.mProgressModel.setRowCount(0);
        }

        public void tableChanged(TableModelEvent evt) {
            if (this.mProgressTable.getSelectedRow() != -1 && evt.getColumn() == 2) {
                int row = this.mProgressTable.getSelectedRow();
                try {
                    BatchRunner br = (BatchRunner)frmBatchRunner.this.BatchThreads.get(row);
                    boolean f = (Boolean)this.mProgressModel.getValueAt(row, 2);
                    if (f) {
                        br.pause();
                    } else {
                        br.unpause();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

