/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.I00acres.isql.swing.AbstractTableTool;
import org.I00acres.isql.swing.JNumberEditor;
import org.I00acres.isql.swing.table.TableWizardModel;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;

public final class frmTableWizard
extends AbstractTableTool
implements ActionListener,
TableModelListener,
CaretListener {
    private iSQLConfig config = iSQLConfig.getInstance();
    private TableWizardModel mTableModel = new TableWizardModel();
    private JToolBar mTableToolBar = new JToolBar(0);
    private JTable mTable = new JTable(this.mTableModel);
    private JTextField mNameField = new JTextField(16);
    private JButton mAddAbove = new JButton(iSQLUtilites.loadToolbarIconResource("RowInsertBefore"));
    private JButton mAddBelow = new JButton(iSQLUtilites.loadToolbarIconResource("RowInsertAfter"));
    private JButton mMoveUp = new JButton(iSQLUtilites.loadToolbarIconResource("Up"));
    private JButton mMoveDown = new JButton(iSQLUtilites.loadToolbarIconResource("Down"));
    private JButton mDelete = new JButton(iSQLUtilites.loadToolbarIconResource("RowDelete"));
    private JButton mNew = new JButton(iSQLUtilites.loadToolbarIconResource("New"));
    private JButton mEdit = new JButton(iSQLUtilites.loadToolbarIconResource("Edit"));
    private JButton mExecute = new JButton(iSQLUtilites.loadToolbarIconResource("Play"));
    private StringBuffer sqlBuffer = new StringBuffer("");
    private boolean isEnabled = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public frmTableWizard() {
        try {
            this.initUI();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public String getToolName() {
        return "Table Creator";
    }

    protected String getSQL() {
        return this.sqlBuffer.toString();
    }

    public boolean validateTool() {
        return this.mNameField.getText().trim().length() >= 1 && this.mTable.getRowCount() >= 1;
    }

    public synchronized void reset() {
        super.reset();
        this.sqlBuffer.setLength(0);
        this.mTableModel.clearTable();
        this.mNameField.setText("");
        this.synch();
    }

    public void actionPerformed(ActionEvent evt) {
        if (!this.isEnabled) {
            return;
        }
        Object src = evt.getSource();
        if (!(this.mTable.getSelectedRow() != -1 || src.equals(this.mEdit) && src.equals(this.mExecute) || this.mTableModel.getRowCount() < 1)) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        if (src.equals(this.mAddAbove) || src.equals(this.mAddBelow)) {
            int row = src.equals(this.mAddBelow) ? this.mTable.getSelectedRow() + 1 : this.mTable.getSelectedRow();
            this.mTableModel.insertBlankRow(row);
            this.mTable.getSelectionModel().setSelectionInterval(row, row);
        } else if (src.equals(this.mDelete)) {
            if (this.mTableModel.getRowCount() >= 1) {
                int[] rows = this.mTable.getSelectedRows();
                int i = rows.length - 1;
                while (i >= 0) {
                    this.mTableModel.removeRow(rows[i]);
                    --i;
                }
                rows = null;
                this.mTable.clearSelection();
            }
        } else if (src.equals(this.mMoveUp)) {
            if (this.mTable.getSelectedRow() >= 1 && this.mTableModel.getRowCount() >= 1) {
                int rows = this.mTable.getSelectedRow();
                this.mTableModel.moveRow(rows, rows, rows - 1);
                this.mTable.getSelectionModel().setSelectionInterval(rows - 1, rows - 1);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (src.equals(this.mMoveDown)) {
            if (this.mTable.getSelectedRow() < this.mTable.getRowCount() - 1 && this.mTableModel.getRowCount() >= 1) {
                int rows = this.mTable.getSelectedRow();
                this.mTableModel.moveRow(rows, rows, rows + 1);
                this.mTable.getSelectionModel().setSelectionInterval(rows + 1, rows + 1);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }

    private synchronized void initUI() throws Exception {
        this.setLayout(new BorderLayout());
        this.mEdit.addActionListener(this);
        this.mAddAbove.addActionListener(this);
        this.mAddBelow.addActionListener(this);
        this.mDelete.addActionListener(this);
        this.mExecute.addActionListener(this);
        this.mNew.addActionListener(this);
        this.mMoveDown.addActionListener(this);
        this.mMoveUp.addActionListener(this);
        this.mEdit.setToolTipText(iSQLUtilites.getString("TW_Manual_Edit"));
        this.mAddAbove.setToolTipText(iSQLUtilites.getString("TW_Add_Above"));
        this.mAddBelow.setToolTipText(iSQLUtilites.getString("TW_Add_Below"));
        this.mDelete.setToolTipText(iSQLUtilites.getString("TW_Delete"));
        this.mExecute.setToolTipText(iSQLUtilites.getString("TW_Create_Table"));
        this.mNew.setToolTipText(iSQLUtilites.getString("TW_New_Table"));
        this.mMoveDown.setToolTipText(iSQLUtilites.getString("TW_Move_Down"));
        this.mMoveUp.setToolTipText(iSQLUtilites.getString("TW_Move_Up"));
        this.mNameField.setFont(this.mNameField.getFont().deriveFont(0, 12.0f));
        JToolBar tb = new JToolBar(1);
        tb.setFloatable(false);
        tb.add(this.mAddAbove);
        tb.add(this.mAddBelow);
        tb.addSeparator();
        tb.add(this.mMoveUp);
        tb.add(this.mMoveDown);
        tb.addSeparator();
        tb.add(this.mDelete);
        this.mTableToolBar.setFloatable(false);
        this.mTableToolBar.add(Box.createHorizontalStrut(tb.getPreferredSize().width));
        this.mTableToolBar.add(new JLabel(iSQLUtilites.getString("Table_Name")));
        this.mTableToolBar.add(Box.createRigidArea(new Dimension(8, 16)));
        this.mTableToolBar.add(this.mNameField);
        this.mNameField.setPreferredSize(new Dimension(this.mNameField.getWidth(), 24));
        this.mNameField.setMaximumSize(this.mNameField.getPreferredSize());
        this.mNameField.setMinimumSize(this.mNameField.getPreferredSize());
        this.mNameField.addCaretListener(this);
        this.mTable.getTableHeader().setReorderingAllowed(false);
        this.mTable.getSelectionModel().setSelectionMode(0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mTable.setDefaultEditor(clazz, new DefaultCellEditor(new JNumberEditor()));
        iSQLUtilites.optimizeTableView(this.mTable);
        this.mTable.setAutoResizeMode(0);
        JScrollPane jsp = new JScrollPane(this.mTable);
        jsp.setPreferredSize(new Dimension(this.mTable.getPreferredSize().width, tb.getPreferredSize().height));
        this.add((Component)jsp, "Center");
        this.add((Component)this.mTableToolBar, "North");
        this.add((Component)tb, "West");
        this.mTableModel.addTableModelListener(this);
        this.mTableModel.setRowCount(0);
        this.setSize(800, 600);
        this.validate();
    }

    public void caretUpdate(CaretEvent e) {
        this.tableChanged(null);
    }

    public Icon toIcon() {
        return iSQLUtilites.loadIconResource("Table16");
    }

    protected void connectionUpdated() {
        if (this.databaseConnection == null) {
            this.mTable.removeEditor();
        } else {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.mTable.setDefaultEditor(clazz, this.mTableModel.getSQLTypeEditor(this.databaseConnection.getDatabaseInformation()));
        }
    }

    protected void setToolEnabled(boolean f) {
        this.isEnabled = f;
        this.mTable.setEnabled(f);
        this.mNameField.setEnabled(f);
        this.mTableToolBar.setEnabled(f);
    }

    public void tableChanged(TableModelEvent e) {
        if (!this.isEnabled) {
            return;
        }
        this.sqlBuffer.setLength(0);
        String[] params = new String[]{this.mNameField.getText()};
        this.sqlBuffer.append(iSQLUtilites.getString("SQL_CREATE_TABLE", params));
        this.sqlBuffer.append(" ( ");
        int i = 0;
        while (i < this.mTable.getRowCount()) {
            this.sqlBuffer.append(this.mTableModel.getSQLStringforRow(i).concat(","));
            ++i;
        }
        this.sqlBuffer.setCharAt(this.sqlBuffer.length() - 1, ' ');
        this.sqlBuffer.append(" )");
        this.updateSQL(this.getSQL());
    }
}

