/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Color;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JTextArea;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;

public class JConsole
extends JTextArea {
    private static iSQLConfig config = iSQLConfig.getInstance();
    private OutputStream os = new FilteredWidgetOutputStream(null);
    private static final String TSPattern = "[HH:mm:ss]";
    private SimpleDateFormat sdf = new SimpleDateFormat();

    public JConsole() {
        this("", 0, 0);
    }

    public JConsole(String text) {
        this(text, 0, 0);
    }

    public JConsole(int rows, int columns) {
        this("", rows, columns);
    }

    public JConsole(String text, int rows, int columns) {
        super(text, rows, columns);
        this.sdf.applyPattern(TSPattern);
        this.setRows(3);
        this.setTabSize(TSPattern.length());
        this.setEditable(false);
        this.setWrapStyleWord(true);
        this.setFont(config.getFontProperty("Console"));
        this.setForeground(config.getColorProperty("Console.Foreground", Color.black));
        this.setBackground(config.getColorProperty("Console.Background", Color.white));
        this.setLineWrap(true);
    }

    public void append(String s) {
        if (s.trim().length() > 0) {
            if (TSPattern.trim().length() != 0 && !TSPattern.equalsIgnoreCase("null")) {
                if (this.sdf == null) {
                    this.sdf = new SimpleDateFormat(TSPattern);
                }
                String ts = this.sdf.format(new Date(System.currentTimeMillis()));
                super.append(ts);
                super.append(" ");
                super.append(s);
            } else {
                super.append(s);
            }
        } else {
            super.append(s);
        }
        this.setCaretPosition(this.getText().length());
    }

    public void setText(String text) {
        if (text == null) {
            return;
        }
        if (text.trim().length() == 0) {
            super.setText("");
            this.append(String.valueOf(iSQLUtilites.getString("Default_Console_String")) + "\n");
        } else {
            super.setText(text);
        }
    }

    public OutputStream createFilteredStream(String category) {
        if (category != null) {
            return new FilteredWidgetOutputStream(category);
        }
        return this.toOutputStream();
    }

    public OutputStream toOutputStream() {
        return this.os;
    }

    private class FilteredWidgetOutputStream
    extends OutputStream {
        private StringBuffer buf = new StringBuffer("");
        private String category = "";

        public FilteredWidgetOutputStream(String category) {
            if (category != null) {
                this.category = new String(category);
            }
        }

        public synchronized void write(int b) {
            char c = (char)(b &= 0xFF);
            this.buf.append(String.valueOf(c));
        }

        public synchronized void write(byte[] b, int offset, int length) {
            this.buf.append(new String(b, offset, length));
        }

        public synchronized void write(byte[] b) {
            this.buf.append(new String(b));
        }

        public synchronized void flush() {
            StringBuffer stringBuffer = this.buf;
            synchronized (stringBuffer) {
                char last;
                if (this.buf.length() > 0 && ((last = this.buf.charAt(this.buf.length() - 1)) == '\n' || last == '\r')) {
                    if (this.category.trim().length() >= 1) {
                        JConsole.this.append("<" + this.category + "> " + this.buf.toString());
                    } else {
                        JConsole.this.append(this.buf.toString());
                    }
                    this.buf.setLength(0);
                }
            }
        }
    }
}

