/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.I00acres.isql.util.iSQLUtilites;

public class MetaTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    public MetaTreeCellRenderer() {
        this.setForeground(Color.black);
        this.setFont(this.getFont().deriveFont(1, 11.0f));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.setText(value.toString());
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        int depth = node.getLevel();
        switch (depth) {
            case 0: {
                this.setIcon(iSQLUtilites.loadIconResource("Database16"));
                break;
            }
            case 1: {
                if (!leaf) {
                    this.setIcon(iSQLUtilites.loadIconResource("Query16"));
                    break;
                }
                this.setIcon(iSQLUtilites.loadIconResource("Information16"));
                break;
            }
            case 2: {
                if (!leaf) {
                    this.setIcon(iSQLUtilites.loadIconResource("Table16"));
                    break;
                }
                this.setIcon(iSQLUtilites.loadIconResource("Applet16"));
                break;
            }
            case 3: {
                if (!leaf && !expanded) {
                    this.setIcon(iSQLUtilites.loadIconResource("J2EEApplication16"));
                    break;
                }
                if (expanded && !leaf) {
                    this.setIcon(iSQLUtilites.loadIconResource("Application16"));
                    break;
                }
                if (!leaf) break;
                this.setIcon(iSQLUtilites.loadIconResource("Applet16"));
                break;
            }
            case 4: {
                this.setIcon(iSQLUtilites.loadIconResource("Applet16"));
                break;
            }
        }
        this.setOpaque(selected);
        return this;
    }
}

