/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Date;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.I00acres.isql.forms.frmPrinterPreview;
import org.I00acres.isql.swing.JTextComponentPopup;
import org.I00acres.isql.swing.table.HexViewModel;
import org.I00acres.isql.util.iSQLUtilites;

public class MutableContentViewer
extends JComponent {
    private DefaultComboBoxModel viewList = new DefaultComboBoxModel<String>(new String[]{iSQLUtilites.getString("VIEW_MODE_TEXT"), iSQLUtilites.getString("VIEW_MODE_HEX"), iSQLUtilites.getString("VIEW_MODE_IMAGE")});
    private HexViewModel HexModel = new HexViewModel("");
    private JScrollPane mContentContainer = new JScrollPane(20, 30);
    private JEditorPane mTextView = new JEditorPane();
    private JTable mHexView = new JTable(this.HexModel);
    private JLabel mImageView = new JLabel();
    private JButton printPreview = new JButton(iSQLUtilites.loadToolbarIconResource("PrintPreview"));
    private JButton saveContent = new JButton(iSQLUtilites.loadToolbarIconResource("SaveAs"));
    private JComboBox mContentSelector = new JComboBox(this.viewList);
    private JTextComponentPopup popupMenu = new JTextComponentPopup();
    private Object content;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public MutableContentViewer() {
        this.setLayout(new BorderLayout());
        JToolBar tb = new JToolBar(0);
        tb.setFloatable(false);
        tb.add(this.printPreview);
        tb.add(this.saveContent);
        tb.add(Box.createHorizontalGlue());
        tb.add(new JLabel(iSQLUtilites.getString("SELECT_VIEW_FILTER")));
        tb.add(this.mContentSelector);
        this.add((Component)tb, "North");
        this.add((Component)this.mContentContainer, "Center");
        this.mTextView.setEditable(false);
        this.printPreview.setToolTipText(iSQLUtilites.getString("Content_Print_Tip"));
        this.saveContent.setToolTipText(iSQLUtilites.getString("Content_Save_Tip"));
        this.popupMenu.addJTextComponent(this.mTextView);
        this.mImageView.setAlignmentX(0.5f);
        this.mImageView.setHorizontalAlignment(0);
        this.mHexView.getTableHeader().setReorderingAllowed(false);
        this.mHexView.getTableHeader().setResizingAllowed(false);
        this.mHexView.setAutoResizeMode(0);
        HexRenderer rndr = new HexRenderer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mHexView.setDefaultRenderer(clazz, rndr);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Number");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mHexView.setDefaultRenderer(clazz2, rndr);
        this.saveContent.setEnabled(false);
        this.mContentContainer.setViewportView(this.mTextView);
        ContentChanger al = new ContentChanger();
        this.mContentSelector.addActionListener(al);
        this.printPreview.addActionListener(al);
        this.saveContent.addActionListener(al);
    }

    private void optimizeview(JTable Table) {
        FontMetrics fm = ((Component)Table).getFontMetrics(Table.getFont());
        int i = 0;
        while (i < Table.getColumnCount()) {
            TableColumn c = Table.getColumnModel().getColumn(i);
            switch (i) {
                case 0: {
                    c.setPreferredWidth(fm.stringWidth("Offset000"));
                    break;
                }
                case 18: {
                    c.setPreferredWidth(fm.stringWidth("W W W W W W W W W W W W W W W W"));
                    break;
                }
                default: {
                    c.setPreferredWidth(fm.stringWidth("FFF"));
                }
            }
            ++i;
        }
    }

    public void setContent(Object newContent) {
        if (newContent == null) {
            return;
        }
        this.saveContent.setEnabled(false);
        this.content = newContent;
        this.mContentSelector.setSelectedIndex(this.mContentSelector.getSelectedIndex());
        SwingUtilities.invokeLater(new TextLoader());
        SwingUtilities.invokeLater(new ImageLoader());
        SwingUtilities.invokeLater(new HexLoader());
    }

    private class ContentChanger
    implements ActionListener {
        ContentChanger() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == MutableContentViewer.this.mContentSelector) {
                switch (MutableContentViewer.this.mContentSelector.getSelectedIndex()) {
                    case 0: {
                        MutableContentViewer.this.printPreview.setEnabled(false);
                        MutableContentViewer.this.mContentContainer.setViewportView(MutableContentViewer.this.mTextView);
                        break;
                    }
                    case 1: {
                        MutableContentViewer.this.printPreview.setEnabled(true);
                        MutableContentViewer.this.mContentContainer.setViewportView(MutableContentViewer.this.mHexView);
                        break;
                    }
                    case 2: {
                        MutableContentViewer.this.printPreview.setEnabled(true);
                        MutableContentViewer.this.mContentContainer.setViewportView(MutableContentViewer.this.mImageView);
                    }
                }
            } else if (e.getSource() == MutableContentViewer.this.printPreview) {
                JFrame frm = new JFrame();
                ((Component)frm).setSize(640, 480);
                frmPrinterPreview.showPrintPreviewDialog(frm, MutableContentViewer.this.mContentContainer.getViewport().getComponent(0), "");
            } else if (e.getSource() == MutableContentViewer.this.saveContent) {
                File f = iSQLUtilites.saveSystemFile(MutableContentViewer.this);
                if (f == null) {
                    return;
                }
                if (!f.exists()) {
                    try {
                        if (!f.createNewFile()) {
                            System.out.println(iSQLUtilites.getString("Error_Writing_File", f.getAbsolutePath()));
                            return;
                        }
                    }
                    catch (IOException iOException) {
                        System.out.println(iSQLUtilites.getString("Error_Writing_File", f.getAbsolutePath()));
                        return;
                    }
                }
                try {
                    FileOutputStream fos = new FileOutputStream(f);
                    byte[] data = MutableContentViewer.this.HexModel.toString().getBytes();
                    fos.write(data, 0, data.length);
                    fos.flush();
                    fos.close();
                }
                catch (IOException iOException) {
                    System.out.println(iSQLUtilites.getString("Error_Writing_File", f.getAbsolutePath()));
                }
            }
        }
    }

    private class HexRenderer
    extends DefaultTableCellRenderer {
        Font fnt = new Font("Monospaced", 0, 10);

        public HexRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setFont(this.fnt);
            if (value instanceof Number) {
                try {
                    String txt = Integer.toHexString(((Number)value).intValue()).toUpperCase();
                    if (txt.length() == 1) {
                        txt = "0" + txt;
                    }
                    this.setText(txt);
                }
                catch (Throwable throwable) {}
            } else {
                String s = column == table.getColumnCount() - 1 ? (String)value : ((String)value).toUpperCase();
                this.setText(s);
            }
            return this;
        }
    }

    private class ImageLoader
    implements Runnable {
        ImageLoader() {
        }

        public void run() {
            MutableContentViewer.this.mImageView.setCursor(Cursor.getPredefinedCursor(3));
            if (MutableContentViewer.this.content instanceof String) {
                String txt = (String)MutableContentViewer.this.content;
                try {
                    MutableContentViewer.this.mImageView.setText("");
                    ImageIcon ico = new ImageIcon(txt.getBytes());
                    ico.setDescription("VarBinary(" + txt.length() + ") ImageSize [" + ico.getIconWidth() + "," + ico.getIconHeight() + "]");
                    MutableContentViewer.this.mImageView.setIcon(ico);
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.mImageView.setIcon(null);
                    MutableContentViewer.this.mImageView.setText(iSQLUtilites.getString("Image_Not_Available"));
                }
            } else if (MutableContentViewer.this.content instanceof Blob) {
                try {
                    Blob b = (Blob)MutableContentViewer.this.content;
                    ImageIcon ico = new ImageIcon(b.getBytes(0L, (int)b.length()));
                    ico.setDescription("BLOB(" + b.length() + ") ImageSize [" + ico.getIconWidth() + "," + ico.getIconHeight() + "]");
                    MutableContentViewer.this.mImageView.setIcon(ico);
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.mImageView.setIcon(null);
                    MutableContentViewer.this.mImageView.setText(iSQLUtilites.getString("Image_Not_Available"));
                }
            } else if (MutableContentViewer.this.content instanceof Clob) {
                try {
                    Clob c = (Clob)MutableContentViewer.this.content;
                    ImageIcon ico = new ImageIcon(c.getSubString(0L, (int)c.length()).getBytes());
                    ico.setDescription("Clob(" + c.length() + ") ImageSize [" + ico.getIconWidth() + "," + ico.getIconHeight() + "]");
                    MutableContentViewer.this.mImageView.setIcon(ico);
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.mImageView.setIcon(null);
                    MutableContentViewer.this.mImageView.setText(iSQLUtilites.getString("Image_Not_Available"));
                }
            } else {
                MutableContentViewer.this.mImageView.setIcon(null);
                MutableContentViewer.this.mImageView.setText(iSQLUtilites.getString("Image_Not_Available"));
            }
            MutableContentViewer.this.mImageView.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class HexLoader
    implements Runnable {
        HexLoader() {
        }

        public void run() {
            MutableContentViewer.this.mHexView.setCursor(Cursor.getPredefinedCursor(3));
            if (MutableContentViewer.this.content instanceof String) {
                String txt = (String)MutableContentViewer.this.content;
                try {
                    MutableContentViewer.this.HexModel.setData(txt);
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Clob) {
                try {
                    Clob c = (Clob)MutableContentViewer.this.content;
                    MutableContentViewer.this.HexModel.setData(c.getSubString(0L, (int)c.length()));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Blob) {
                try {
                    Blob b = (Blob)MutableContentViewer.this.content;
                    MutableContentViewer.this.HexModel.setData(b.getBytes(0L, (int)b.length()));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Double) {
                try {
                    MutableContentViewer.this.HexModel.setData(HexViewModel.getDoubleBytes((Double)MutableContentViewer.this.content));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Float) {
                try {
                    MutableContentViewer.this.HexModel.setData(HexViewModel.getFloatBytes((Float)MutableContentViewer.this.content));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Long) {
                try {
                    MutableContentViewer.this.HexModel.setData(HexViewModel.getLongBytes((Long)MutableContentViewer.this.content));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Integer) {
                try {
                    MutableContentViewer.this.HexModel.setData(HexViewModel.getIntBytes((Integer)MutableContentViewer.this.content));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Short) {
                try {
                    MutableContentViewer.this.HexModel.setData(HexViewModel.getShortBytes((Short)MutableContentViewer.this.content));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else if (MutableContentViewer.this.content instanceof Date) {
                try {
                    MutableContentViewer.this.HexModel.setData(HexViewModel.getLongBytes(new Long(((Date)MutableContentViewer.this.content).getTime())));
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else {
                MutableContentViewer.this.HexModel.setData("");
            }
            MutableContentViewer.this.optimizeview(MutableContentViewer.this.mHexView);
            MutableContentViewer.this.saveContent.setEnabled(MutableContentViewer.this.mHexView.toString().length() >= 1);
            MutableContentViewer.this.mHexView.setCursor(Cursor.getDefaultCursor());
        }
    }

    private class TextLoader
    implements Runnable {
        TextLoader() {
        }

        public void run() {
            MutableContentViewer.this.mTextView.setCursor(Cursor.getPredefinedCursor(3));
            if (MutableContentViewer.this.content instanceof String) {
                String txt = (String)MutableContentViewer.this.content;
                try {
                    if (txt.trim().regionMatches(true, 0, "<html>", 0, 6)) {
                        MutableContentViewer.this.mTextView.setContentType("text/html");
                    } else {
                        MutableContentViewer.this.mTextView.setContentType("text/plain");
                    }
                    MutableContentViewer.this.mTextView.setText(txt.trim());
                }
                catch (Throwable t) {
                    MutableContentViewer.this.mTextView.setContentType("text/plain");
                    MutableContentViewer.this.mTextView.setText("Error " + t);
                }
            } else if (MutableContentViewer.this.content instanceof Clob) {
                try {
                    Clob c = (Clob)MutableContentViewer.this.content;
                    String txt = c.getSubString(0L, (int)c.length());
                    if (txt.trim().regionMatches(true, 0, "<html>", 0, 6)) {
                        MutableContentViewer.this.mTextView.setContentType("text/html");
                    } else {
                        MutableContentViewer.this.mTextView.setContentType("text/plain");
                    }
                    MutableContentViewer.this.mTextView.setText(txt.trim());
                }
                catch (Throwable throwable) {
                    MutableContentViewer.this.HexModel.setData("");
                }
            } else {
                MutableContentViewer.this.mTextView.setContentType("text/plain");
                MutableContentViewer.this.mTextView.setText("" + MutableContentViewer.this.content);
            }
            MutableContentViewer.this.mTextView.setCursor(Cursor.getDefaultCursor());
        }
    }
}

