/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.DatabaseMetaData;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.I00acres.lib.sql.ResultSetUtilities;

public class TableSelector
extends JComponent {
    private DefaultComboBoxModel mCatalogList = new DefaultComboBoxModel();
    private DefaultComboBoxModel mSchemaList = new DefaultComboBoxModel();
    private DefaultComboBoxModel mTableList;
    private JComboBox mCatalogSelector = new JComboBox(this.mCatalogList);
    private JComboBox mSchemaSelector = new JComboBox(this.mSchemaList);
    private JComboBox mTableSelector;
    private DatabaseMetaData dmd;
    private ChangeHandler mActionHandler = new ChangeHandler();
    private transient Vector changeListeners;

    public TableSelector(DatabaseMetaData dmd, boolean allowTableSelection) {
        this.dmd = dmd;
        if (allowTableSelection) {
            this.mTableList = new DefaultComboBoxModel();
            this.mTableSelector = new JComboBox(this.mTableList);
            this.configCombobox(this.mTableSelector);
            this.mTableSelector.setEditable(true);
        }
        this.initCatalogSelector();
        this.initSchemaSelector();
        if (this.mSchemaList == null && this.mCatalogList == null && !allowTableSelection) {
            this.dmd = null;
            return;
        }
        try {
            Insets ins = new Insets(2, 2, 2, 2);
            this.setLayout(new GridBagLayout());
            this.add((Component)new JLabel("Select Catalog"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, ins, 0, 0));
            this.add((Component)this.mCatalogSelector, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
            this.add((Component)new JLabel("Select Schema"), new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, ins, 0, 0));
            this.add((Component)this.mSchemaSelector, new GridBagConstraints(3, 0, 1, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
            if (allowTableSelection) {
                this.add((Component)new JLabel("Select Table"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, ins, 0, 0));
                this.add((Component)this.mTableSelector, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 10, 2, ins, 0, 0));
            }
            if (this.mCatalogList.getSize() >= 1) {
                this.mCatalogSelector.setSelectedIndex(0);
            }
            if (this.mSchemaList.getSize() >= 1) {
                this.mSchemaSelector.setSelectedIndex(0);
            }
            if (allowTableSelection && this.mTableList.getSize() >= 1) {
                this.mTableSelector.setSelectedIndex(0);
            }
        }
        catch (Throwable throwable) {}
    }

    public boolean compareSelection(TableSelector other) {
        return !(this.mCatalogSelector.isEnabled() && other.mCatalogSelector.isEnabled() && !other.getSelectedCatalog().equalsIgnoreCase(this.getSelectedCatalog()) || this.mSchemaSelector.isEnabled() && other.mSchemaSelector.isEnabled() && !other.getSelectedSchema().equalsIgnoreCase(this.getSelectedSchema()) || this.mTableSelector != null && other.mTableSelector != null && !other.getSelectedTable().equalsIgnoreCase(this.getSelectedTable()));
    }

    public void updateMetaData(DatabaseMetaData dmd) {
        if (dmd == null) {
            try {
                this.mTableList.removeAllElements();
                this.mSchemaList.removeAllElements();
                this.mCatalogList.removeAllElements();
                this.setEnabled(false);
            }
            catch (Throwable throwable) {}
        } else {
            this.dmd = dmd;
            this.setEnabled(true);
            this.initCatalogSelector();
            this.initSchemaSelector();
        }
    }

    public void setEnabled(boolean f) {
        this.mTableSelector.setEnabled(f);
        this.mCatalogSelector.setEnabled(f);
        this.mSchemaSelector.setEnabled(f);
    }

    private void initSchemaSelector() {
        try {
            Object[] schems = ResultSetUtilities.getSingleColumn(this.dmd.getSchemas(), "TABLE_SCHEM");
            this.mSchemaList.removeAllElements();
            int i = 0;
            while (i < schems.length) {
                String s;
                String string = s = schems[i] == null ? "" : schems[i].toString();
                if (s.trim().length() >= 1) {
                    this.mSchemaList.addElement(s);
                }
                ++i;
            }
            this.configCombobox(this.mSchemaSelector);
            this.mSchemaSelector.setSelectedItem(this.dmd.getUserName());
            this.mSchemaSelector.setEnabled(this.mSchemaList.getSize() >= 1);
        }
        catch (Throwable throwable) {
            this.mSchemaSelector.setEnabled(false);
        }
    }

    private void configCombobox(JComboBox box) {
        box.addActionListener(this.mActionHandler);
        box.setMaximumRowCount(5);
        box.setEditable(false);
    }

    public String getSelectedTable() {
        if (this.mTableList == null) {
            return null;
        }
        return (String)this.mTableList.getSelectedItem();
    }

    public String getSelectedCatalog() {
        return (String)this.mCatalogList.getSelectedItem();
    }

    public String getSelectedSchema() {
        return (String)this.mSchemaList.getSelectedItem();
    }

    private void initCatalogSelector() {
        try {
            Object[] schems = ResultSetUtilities.getSingleColumn(this.dmd.getCatalogs(), 1).toArray();
            this.mCatalogList.removeAllElements();
            int i = 0;
            while (i < schems.length) {
                String s;
                String string = s = schems[i] == null ? "" : schems[i].toString();
                if (s.trim().length() >= 1) {
                    this.mCatalogList.addElement(s);
                }
                ++i;
            }
            this.configCombobox(this.mCatalogSelector);
            this.mCatalogSelector.setEnabled(this.mCatalogList.getSize() >= 1);
        }
        catch (Throwable throwable) {}
    }

    private void loadTableList() {
        if (this.mTableList == null) {
            return;
        }
        String Catalog = this.mCatalogList == null ? null : (String)this.mCatalogList.getSelectedItem();
        String Schema = this.mSchemaList == null ? null : (String)this.mSchemaList.getSelectedItem();
        try {
            Object[] tables = ResultSetUtilities.getSingleColumn(this.dmd.getTables(Catalog, Schema, null, new String[]{"TABLE"}), "TABLE_NAME");
            this.mTableList.removeAllElements();
            if (tables != null) {
                int i = 0;
                while (i < tables.length) {
                    this.mTableList.addElement(new String((String)tables[i]));
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.changeListeners != null && this.changeListeners.contains(l)) {
            Vector v = (Vector)this.changeListeners.clone();
            v.removeElement(l);
            this.changeListeners = v;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        Vector v;
        Vector vector = v = this.changeListeners == null ? new Vector(2) : (Vector)this.changeListeners.clone();
        if (!v.contains(l)) {
            v.addElement(l);
            this.changeListeners = v;
        }
    }

    protected void fireStateChanged(ChangeEvent e) {
        if (this.changeListeners != null) {
            Vector listeners = this.changeListeners;
            int count = listeners.size();
            int i = 0;
            while (i < count) {
                ((ChangeListener)listeners.elementAt(i)).stateChanged(e);
                ++i;
            }
        }
    }

    private class ChangeHandler
    implements ActionListener {
        ChangeHandler() {
        }

        public void actionPerformed(ActionEvent ae) {
            Object src = ae.getSource();
            if (src.equals(TableSelector.this.mCatalogSelector)) {
                TableSelector.this.loadTableList();
            } else if (src.equals(TableSelector.this.mSchemaSelector)) {
                TableSelector.this.loadTableList();
            } else {
                src.equals(TableSelector.this.mTableSelector);
            }
            TableSelector.this.fireStateChanged(new ChangeEvent(TableSelector.this));
        }
    }
}

