/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.I00acres.isql.swing.action.iSQLActionConstants;
import org.I00acres.isql.swing.action.iSQLActionManager;
import org.I00acres.isql.swing.iSQLCommandToolBar;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;

public class iSQLCommandConsole
extends JPanel
implements KeyListener {
    private static final KeyStroke CTRL_U = iSQLUtilites.createKeyStroke(85, 2);
    private iSQLConfig config = iSQLConfig.getInstance();
    private iSQLActionManager manager;
    private JTextPane sQueryField = new JTextPane();
    private JScrollPane jsp = new JScrollPane(this.sQueryField);
    private int currentQuery = 0;
    private LinkedList QueryHistory = null;
    private iSQLCommandToolBar tb = null;
    private boolean discardDuplicates = true;

    public void addCaretListener(CaretListener l) {
        this.sQueryField.addCaretListener(l);
    }

    public void addHistoryElement(Object obj) {
        if (obj == null) {
            return;
        }
        try {
            if (obj.toString().length() == 0 || obj.toString().trim().equalsIgnoreCase("null")) {
                return;
            }
            if (this.QueryHistory.contains(obj) && this.discardDuplicates) {
                this.QueryHistory.remove(obj);
                this.QueryHistory.addFirst(obj);
            } else if (this.QueryHistory.size() >= this.config.getIntProperty("General.History.MaxSize")) {
                this.QueryHistory.removeLast();
                this.QueryHistory.addFirst(obj);
            } else {
                this.QueryHistory.addFirst(obj);
            }
        }
        catch (Exception exception) {}
    }

    public void setHIstoryElement(int idx) {
        String s = this.getHistoryElement(idx);
        if (s == null) {
            this.sQueryField.setText("");
        } else {
            this.sQueryField.setText(s);
        }
    }

    public String getHistoryElement(int idx) {
        try {
            if (idx <= this.config.getIntProperty("General.History.MaxSize")) {
                return (String)this.QueryHistory.get(idx);
            }
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Collection getHistory() {
        try {
            int idx = this.QueryHistory.lastIndexOf("null");
            idx = idx < 0 ? this.QueryHistory.lastIndexOf("") : idx;
            return this.QueryHistory.subList(0, idx);
        }
        catch (Exception exception) {
            return this.QueryHistory;
        }
    }

    public void clearHistory() {
        this.QueryHistory.clear();
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void removeToolBar() {
        if (this.tb != null) {
            try {
                try {
                    this.remove(this.tb);
                }
                catch (Exception exception) {
                    this.tb = null;
                }
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                Runtime.getRuntime().runFinalization();
                throw throwable;
            }
            Object var2_3 = null;
            Runtime.getRuntime().runFinalization();
        }
        this.revalidate();
    }

    public void addToolBar() {
        if (!this.config.getBooleanProperty("ToolBar.History.visible")) {
            return;
        }
        this.removeToolBar();
        String s = this.config.getStringProperty("ToolBar.History.Dock");
        this.tb = new iSQLCommandToolBar(this.manager);
        if (s.equalsIgnoreCase("East") || s.equalsIgnoreCase("West")) {
            this.tb.setOrientation(1);
        }
        this.add((Component)this.tb, s);
        this.revalidate();
    }

    public JTextComponent getTextComponent() {
        return this.sQueryField;
    }

    public String getText() {
        return this.sQueryField.getText();
    }

    public void setActionManager(iSQLActionManager manager) {
        if (manager == null) {
            throw new NullPointerException();
        }
        this.manager = manager;
        this.sQueryField.getKeymap().addActionForKeyStroke(iSQLActionConstants.CMD_EXECSQL_ACCEL, manager.getAction("17"));
        this.addToolBar();
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public void save(PrintWriter pw) throws Exception {
        int x = this.config.getIntProperty("General.History.MaxSize");
        int i = 0;
        Iterator itr = this.QueryHistory.iterator();
        while (itr.hasNext() && i++ < x) {
            pw.println(itr.next());
        }
        pw.flush();
        pw.close();
    }

    public void updateHistorySet(Collection c, boolean clear) {
        if (c == null) {
            return;
        }
        Iterator itr = c.iterator();
        if (clear) {
            this.QueryHistory.clear();
        }
        while (itr.hasNext()) {
            this.addHistoryElement(itr.next());
        }
    }

    public iSQLCommandConsole() {
        try {
            this.QueryHistory = new LinkedList();
            if (!this.config.getBooleanProperty("General.UseDiscreteHistory")) {
                this.updateHistorySet(this.config.getLastHistorySet(), true);
            }
            this.initUI();
        }
        catch (Exception exception) {}
    }

    private synchronized void initUI() throws Exception {
        this.setLayout(new BorderLayout());
        this.sQueryField.addKeyListener(this);
        this.sQueryField.setCaretPosition(0);
        this.updateFont(this.config.getFontProperty("Query"));
        this.updateColor(this.config.getColorProperty("Query.Foreground", Color.black), this.config.getColorProperty("Query.Background", Color.white));
        this.add((Component)this.jsp, "Center");
        this.setPreferredSize(new Dimension(320, 100));
    }

    public void updateColor(Color fg, Color bg) {
        this.sQueryField.setForeground(fg);
        this.sQueryField.setBackground(bg);
    }

    public void updateFont(Font fnt) {
        this.sQueryField.setFont(fnt);
    }

    public void actionShowLastQuery() {
        try {
            this.currentQuery = 0;
            if (this.QueryHistory.getFirst() != null) {
                this.sQueryField.setText((String)this.QueryHistory.getFirst());
                this.sQueryField.setCaretPosition(this.sQueryField.getText().length());
            }
        }
        catch (Exception exception) {}
    }

    public void actionShowFirstQuery() {
        try {
            this.currentQuery = this.QueryHistory.size() - 1;
            if (this.QueryHistory.getLast() != null) {
                this.sQueryField.setText((String)this.QueryHistory.getLast());
                this.sQueryField.setCaretPosition(this.sQueryField.getText().length());
            }
        }
        catch (Exception exception) {}
    }

    public void actionShowNextQuery() {
        --this.currentQuery;
        if (this.currentQuery >= this.QueryHistory.size() || this.currentQuery <= 0) {
            this.actionShowLastQuery();
            return;
        }
        if (this.QueryHistory.get(this.currentQuery) != null) {
            this.sQueryField.setText((String)this.QueryHistory.get(this.currentQuery));
            this.sQueryField.setCaretPosition(this.sQueryField.getText().length());
        }
    }

    public void actionShowPreviousQuery() {
        ++this.currentQuery;
        if (this.currentQuery >= this.QueryHistory.size() || this.currentQuery <= 0) {
            this.actionShowFirstQuery();
            return;
        }
        if (this.QueryHistory.get(this.currentQuery) != null) {
            this.sQueryField.setText((String)this.QueryHistory.get(this.currentQuery));
            this.sQueryField.setCaretPosition(this.sQueryField.getText().length());
        }
    }

    public void keyPressed(KeyEvent e) {
        KeyStroke ev = KeyStroke.getKeyStrokeForEvent(e);
        if (ev.equals(CTRL_U)) {
            this.sQueryField.setText("");
            this.sQueryField.setCaretPosition(0);
            this.currentQuery = 0;
        }
    }

    public void clear() {
        this.sQueryField.setText("");
        this.sQueryField.setCaretPosition(0);
        this.currentQuery = 0;
    }

    public int getCaretCol(int idx) throws Exception {
        return Math.abs(Utilities.getRowStart(this.sQueryField, idx) - idx);
    }

    public int getCaretRow(int idx) throws Exception {
        return this.getLineOfOffset(idx);
    }

    protected int getLineOfOffset(int offset) throws BadLocationException {
        Document doc = this.sQueryField.getDocument();
        if (offset < 0) {
            throw new BadLocationException("", -1);
        }
        if (offset > doc.getLength()) {
            throw new BadLocationException("", doc.getLength() + 1);
        }
        Element map = this.sQueryField.getDocument().getDefaultRootElement();
        return map.getElementIndex(offset);
    }

    public void updateUI() {
        super.updateUI();
        if (this.manager != null) {
            this.sQueryField.getKeymap().addActionForKeyStroke(iSQLActionConstants.CMD_EXECSQL_ACCEL, this.manager.getAction("17"));
        }
    }
}

