/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.I00acres.isql.swing.print.DefaultPaperComponent;
import org.I00acres.lib.util.xProperties;

public final class JTablePaper
extends DefaultPaperComponent {
    public static final int MODE_OVERDOWN = 0;
    public static final int MODE_DOWNOVER = 1;
    private Font fntCellHeader = new Font("Lucinda Sans", 1, 10);
    private int printMode = 0;
    private int[] columnsPerPage = null;
    private int[] rowsPerPage = null;
    private int[] columnOffsets = null;
    private int[] rowOffsets = null;
    private int[] columnwidths = null;
    private PageCfg[] pageConfig = null;
    private int pageCount = 0;
    private int mCurrentPage = 0;
    private int h_ColumnHeaderBox = 0;
    private int w_ColumnHeaderBox = 0;
    private int h_CellBox = 0;
    private boolean showGridlines = true;
    private boolean includeColumnHeaders = true;
    private boolean printRowNumbers = true;
    private int xPad = this.showGridlines ? 6 : 4;
    private int yPad = this.showGridlines ? 6 : 4;
    private JTable table;

    public void setContent(Object Data) {
        this.table = (JTable)Data;
        this.columnsPerPage = null;
        this.rowsPerPage = null;
        this.columnOffsets = null;
        this.rowOffsets = null;
        this.columnwidths = null;
        this.pageCount = 0;
        this.mCurrentPage = 0;
        this.h_ColumnHeaderBox = 0;
        this.w_ColumnHeaderBox = 0;
        this.h_CellBox = 0;
        this.isValid = false;
        this.invalidate();
    }

    protected String getHeaderString(int PageIndex) {
        return "Total Record Count [" + this.table.getRowCount() + "]";
    }

    protected String getFooterString(int PageIndex) {
        PageCfg cfg = this.pageConfig[PageIndex];
        int rowx = cfg.rowCount + cfg.rowOffset;
        return "Rows [ " + (cfg.rowOffset + 1) + " -- " + (rowx >= this.table.getRowCount() ? this.table.getRowCount() : rowx) + " ]";
    }

    private Component getTableRenderer(int row, int col) {
        return this.table.getCellRenderer(row, col).getTableCellRendererComponent(this.table, this.table.getValueAt(row, col), false, false, row, col);
    }

    public void initialize(Graphics2D g2) {
        this.firePropertyChange("init", false, true);
        super.initialize(g2);
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            this.firePropertyChange("init", true, false);
            this.isValid = true;
            return;
        }
        try {
            this.h_CellBox = g2.getFontMetrics(this.getTableRenderer(0, 0).getFont()).getHeight() + this.yPad;
            FontMetrics hm = g2.getFontMetrics(this.fntCellHeader);
            this.h_ColumnHeaderBox = 1 * (hm.getHeight() + 4) - hm.getDescent();
            this.w_ColumnHeaderBox = this.getContentWidth();
            int cellContentHieght = this.getContentHeight() - this.h_ColumnHeaderBox;
            this.h_CellBox = Math.max(this.h_CellBox, this.table.getRowHeight() + this.yPad);
            int rPP = cellContentHieght / this.h_CellBox;
            this.columnsPerPage = this.calcuateColumnsPerPage(hm);
            this.rowsPerPage = this.calcuateRowsPerPage(rPP);
            this.pageCount = this.rowsPerPage.length * this.columnsPerPage.length;
            this.pageConfig = new PageCfg[this.pageCount];
            int i = 0;
            while (i < this.pageCount) {
                this.pageConfig[i] = new PageCfg();
                switch (this.printMode) {
                    case 0: {
                        this.pageConfig[i].columnCount = this.columnsPerPage[i % this.columnsPerPage.length];
                        this.pageConfig[i].columnOffset = i % this.columnsPerPage.length == 0 ? 0 : this.pageConfig[i - 1].columnOffset + this.columnsPerPage[(i - 1) % this.columnsPerPage.length];
                        this.pageConfig[i].rowOffset = i == 0 ? 0 : (i % this.columnsPerPage.length == 0 ? this.pageConfig[i - 1].rowOffset + this.pageConfig[i - 1].rowCount : this.pageConfig[i - 1].rowOffset);
                        try {
                            this.pageConfig[i].rowCount = this.columnsPerPage.length == 1 ? this.rowsPerPage[i] : this.rowsPerPage[i % this.columnsPerPage.length];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            this.pageConfig[i].rowCount = i == 0 ? 0 : this.pageConfig[i - 1].rowCount;
                        }
                        break;
                    }
                    case 1: {
                        int idx = i / this.rowsPerPage.length;
                        this.pageConfig[i].columnCount = this.columnsPerPage[idx];
                        this.pageConfig[i].columnOffset = idx == 0 ? 0 : this.columnsPerPage[(idx - 1) % this.columnsPerPage.length];
                        this.pageConfig[i].rowCount = this.rowsPerPage[i % this.rowsPerPage.length];
                        this.pageConfig[i].rowOffset = i % this.rowsPerPage.length == 0 ? 0 : this.pageConfig[i - 1].rowOffset + this.pageConfig[i - 1].rowCount;
                        break;
                    }
                }
                ++i;
            }
            this.isValid = true;
        }
        catch (Throwable throwable) {}
        this.isValid = true;
        this.firePropertyChange("init", true, false);
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public void configure(xProperties properties) {
        super.configure(properties);
        this.showGridlines = properties.getBooleanProperty("Print.IncludeGridlines");
        this.printMode = properties.getBooleanProperty("Print.Table.DownOver") ? 1 : 0;
        this.xPad = this.showGridlines ? 6 : 4;
        this.yPad = this.showGridlines ? 6 : 4;
        this.isValid = false;
        this.invalidate();
    }

    protected void drawPageContents(Graphics2D g, int pageIndex) {
        this.drawTableColumnHeaders(g, pageIndex);
        this.drawTableContents(g, pageIndex);
        if (this.showGridlines) {
            this.drawGridLines(g, pageIndex);
        }
    }

    private void drawTableColumnHeaders(Graphics2D g, int pageIndex) {
        FontMetrics fm = g.getFontMetrics(this.fntCellHeader);
        int fontHeight = fm.getHeight();
        int fontDesent = fm.getDescent();
        g.setFont(this.fntCellHeader);
        g.setColor(this.table.getSelectionBackground());
        g.fillRect(0, 0, this.w_ColumnHeaderBox, this.h_ColumnHeaderBox);
        g.setColor(Color.black);
        g.drawRect(0, -1, this.w_ColumnHeaderBox, this.h_ColumnHeaderBox + 1);
        int hCount = this.pageConfig[pageIndex].columnCount;
        int x = 0;
        int y = -1;
        int lx = 0;
        g.setColor(this.table.getSelectionForeground());
        int i = 0;
        while (i < hCount) {
            block4: {
                try {
                    x += this.columnwidths[this.pageConfig[pageIndex].columnOffset + i];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    break block4;
                }
                if (i + 1 < hCount) {
                    g.drawLine(x - this.xPad, y, x - this.xPad, y + this.h_ColumnHeaderBox + 1);
                }
                g.drawString(this.table.getColumnName(this.pageConfig[pageIndex].columnOffset + i), lx + this.xPad / 2, y + this.h_ColumnHeaderBox / fontHeight + (fontHeight - fontDesent));
                lx = x;
            }
            ++i;
        }
    }

    private void drawGridLines(Graphics2D g, int pageIndex) {
        int cX = 0;
        int cY = 0;
        int r = 0;
        PageCfg cfg = this.pageConfig[pageIndex];
        int rowx = cfg.rowCount;
        g.translate(0, cY += this.h_ColumnHeaderBox);
        if (this.useColor()) {
            g.setColor(this.table.getGridColor());
        } else {
            g.setColor(Color.darkGray);
        }
        r = 1;
        while (r <= rowx) {
            g.drawLine(0, r * this.h_CellBox, this.getContentWidth(), r * this.h_CellBox);
            ++r;
        }
        int c = 0;
        while (c < cfg.columnCount - 1) {
            g.drawLine((cX += this.columnwidths[cfg.columnOffset + c]) - this.xPad, 0, cX - this.xPad, r * this.h_CellBox);
            ++c;
        }
        g.translate(0, -cY);
    }

    private void drawTableContents(Graphics2D g, int pageIndex) {
        PageCfg cfg = this.pageConfig[pageIndex];
        int cO = 0;
        int cW = 0;
        int cX = 0;
        int cY = this.h_ColumnHeaderBox;
        g.translate(0, cY);
        g.setColor(Color.black);
        try {
            int r = 0;
            while (r < cfg.rowCount) {
                int c = 0;
                while (c < cfg.columnCount) {
                    int realColumn = cfg.columnOffset + c;
                    int realRow = cfg.rowOffset + r;
                    if (realColumn < this.table.getColumnCount() && realRow < this.table.getRowCount()) {
                        cW = this.columnwidths[realColumn];
                        cX += c == 0 ? 0 : this.columnwidths[realColumn - 1];
                        TableCellRenderer rend = this.table.getCellRenderer(realRow, realColumn);
                        Component comp = rend.getTableCellRendererComponent(this.table, this.table.getValueAt(realRow, realColumn), false, false, realRow, realColumn);
                        comp.setBounds(this.xPad / 2, this.yPad / 2, cW - this.xPad, this.h_CellBox - this.yPad);
                        comp.setSize(cW - this.xPad, this.h_CellBox - this.yPad);
                        comp.validate();
                        cO = r * this.h_CellBox;
                        Graphics2D cmpGraphics = (Graphics2D)g.create((cX += c == 0 ? this.xPad / 2 : 0) - this.xPad / 2, cO + this.yPad / 2, cW - this.xPad, this.h_CellBox - this.yPad);
                        comp.paint(cmpGraphics);
                    }
                    ++c;
                }
                cX = 0;
                ++r;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        g.translate(0, -cY);
    }

    private int[] calcuateRowsPerPage(int rpp) {
        int[] newArr;
        int[] rowDivisions = null;
        int rows = this.table.getRowCount();
        rows -= rpp;
        while (rows >= rpp) {
            if (rowDivisions == null) {
                rowDivisions = new int[]{rpp};
                continue;
            }
            newArr = new int[rowDivisions.length + 1];
            System.arraycopy(rowDivisions, 0, newArr, 0, rowDivisions.length);
            newArr[newArr.length - 1] = rpp;
            rowDivisions = null;
            rowDivisions = newArr;
            rows -= rpp;
        }
        if (rowDivisions == null) {
            rowDivisions = rows >= 1 ? new int[]{rpp, this.table.getRowCount() - rpp} : new int[]{rpp};
        } else {
            newArr = new int[rowDivisions.length + 1];
            System.arraycopy(rowDivisions, 0, newArr, 0, rowDivisions.length);
            newArr[newArr.length - 1] = rows;
            rowDivisions = null;
            rowDivisions = newArr;
        }
        return rowDivisions;
    }

    private int[] calcuateColumnsPerPage(FontMetrics headerMetrics) {
        if (this.columnwidths == null) {
            this.columnwidths = new int[this.table.getColumnCount()];
        }
        if (this.columnwidths.length < this.table.getColumnCount()) {
            this.columnwidths = new int[this.table.getColumnCount()];
        }
        int[] colDivisions = null;
        int cMaxwidth = 0;
        int cPageWidth = 0;
        int cPP = 0;
        int c = 0;
        while (c < this.table.getColumnCount()) {
            boolean moreColumns;
            int columnHeaderWidth = headerMetrics.stringWidth(this.table.getColumnName(c)) + this.xPad;
            int delta = cPP >= 2 ? cPP - 1 : 0;
            int pageWidth = this.getContentWidth() - delta;
            cMaxwidth = Math.min(pageWidth, columnHeaderWidth);
            int r = 0;
            while (r < this.table.getRowCount()) {
                cMaxwidth = Math.max(cMaxwidth, this.calculateWidthAt(r, c, r == 0 ? -1 : cMaxwidth, columnHeaderWidth));
                ++r;
            }
            this.columnwidths[c] = cMaxwidth + this.xPad;
            ++cPP;
            boolean bl = moreColumns = c + 1 < this.table.getColumnCount();
            if ((cPageWidth += this.columnwidths[c] + delta) >= pageWidth) {
                if (colDivisions == null) {
                    if (moreColumns) {
                        colDivisions = new int[]{cPP - 1};
                    } else {
                        colDivisions = new int[]{cPP - 1, 1};
                        cPP = 0;
                    }
                } else {
                    int[] newArr = new int[colDivisions.length + 1];
                    System.arraycopy(colDivisions, 0, newArr, 0, colDivisions.length);
                    newArr[newArr.length - 1] = cPP - 1;
                    colDivisions = null;
                    colDivisions = newArr;
                }
                if (moreColumns) {
                    cPP = 1;
                    cPageWidth = cMaxwidth;
                } else {
                    cPP = 0;
                    cPageWidth = 0;
                }
                cMaxwidth = 0;
            }
            ++c;
        }
        if (colDivisions != null && cPP > 0) {
            int[] newArr = new int[colDivisions.length + 1];
            System.arraycopy(colDivisions, 0, newArr, 0, colDivisions.length);
            newArr[newArr.length - 1] = cPP;
            colDivisions = null;
            colDivisions = newArr;
        } else if (colDivisions == null) {
            colDivisions = new int[]{cPP};
        }
        return colDivisions;
    }

    private int calculateWidthAt(int row, int col, int currentMax, int headerwidth) {
        TableCellRenderer rend = this.table.getCellRenderer(row, col);
        Component comp = rend.getTableCellRendererComponent(this.table, this.table.getValueAt(row, col), false, false, row, col);
        comp.validate();
        int compWidth = comp.getPreferredSize().width;
        int width = Math.max(currentMax == -1 ? headerwidth : currentMax, compWidth);
        if (width > 4 * headerwidth && headerwidth >= 64) {
            width = 4 * headerwidth;
        }
        return width;
    }

    private class PageCfg {
        int columnOffset = 0;
        int columnCount = 0;
        int rowOffset = 0;
        int rowCount = 0;
        boolean canAverage = false;
    }
}

