/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.I00acres.isql.util.SimpleTableFilter;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.util.StringTokenizer;
import org.I00acres.lib.util.StringUtilities;

public class CSVTableFilter
extends SimpleTableFilter {
    static /* synthetic */ Class class$0;

    protected void addExportProperties() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("javax.swing.table.TableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setExportableClass(clazz);
        this.addExportProperty(iSQLUtilites.getString("ASCII_Delimiter_Name"), null, iSQLUtilites.getString("ASCII_Delimiter_Value"), true, iSQLUtilites.getString("ASCII_Delimiter_Desc"));
        this.addBooleanExportProperty(iSQLUtilites.getString("ASCII_IncludeCols_Name"), null, false, iSQLUtilites.getString("ASCII_IncludeCols_Desc"));
        this.addBooleanExportProperty(iSQLUtilites.getString("ASCII_IncludeHead_Name"), null, false, iSQLUtilites.getString("ASCII_IncludeHead_Desc"));
        this.addExportProperty(iSQLUtilites.getString("ASCII_CustomHeader_Name"), null, iSQLUtilites.getString("ASCII_CustomHeader_Value"), false, iSQLUtilites.getString("ASCII_CustomHeader_Desc"));
        this.addBooleanExportProperty(iSQLUtilites.getString("ASCII_Encode_NPC_Name"), null, false, iSQLUtilites.getString("ASCII_Encode_NPC_Desc"));
        this.addBooleanExportProperty(iSQLUtilites.getString("ASCII_SmartQuotes_Name"), null, false, iSQLUtilites.getString("ASCII_SmartQuotes_Desc"));
    }

    protected void addImportProperties() {
        this.addImportProperty(iSQLUtilites.getString("ASCII_Delimiter_Name"), null, iSQLUtilites.getString("ASCII_Delimiter_Value"), true, iSQLUtilites.getString("ASCII_Delimiter_Desc"));
        this.addImportProperty(iSQLUtilites.getString("ASCII_Skip_Name"), null, iSQLUtilites.getString("ASCII_Skip_Value"), false, iSQLUtilites.getString("ASCII_Skip_Desc"));
        this.addImportProperty(iSQLUtilites.getString("ASCII_Quote_Name"), null, iSQLUtilites.getString("ASCII_Quote_Value"), false, iSQLUtilites.getString("ASCII_Quote_Desc"));
        this.addImportProperty(iSQLUtilites.getString("ASCII_Comment_Name"), null, iSQLUtilites.getString("ASCII_Comment_Value"), false, iSQLUtilites.getString("ASCII_Comment_Desc"));
        this.addBooleanImportProperty(iSQLUtilites.getString("ASCII_DblTok_Name"), iSQLUtilites.getString("ASCII_DblTok_Value"), false, iSQLUtilites.getString("ASCII_DblTok_Desc"));
    }

    public String getName() {
        return iSQLUtilites.getString("ASCII_Handler_Name");
    }

    public boolean isImportable() {
        return true;
    }

    public boolean isExportable() {
        return true;
    }

    public String getContentType() {
        return "text/plain";
    }

    public Icon getUserIcon() {
        return iSQLUtilites.loadIconResource("Csv16");
    }

    public int filter(DefaultTableModel tm, InputStream is) throws IOException, InterruptedException {
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        int totalByteCount = is.available();
        int bytesRead = 0;
        String delims = StringUtilities.decode(this.config.getStringProperty(iSQLUtilites.getString("ASCII_Delimiter_Name"), ","));
        boolean dTokens = this.config.getBooleanProperty(iSQLUtilites.getString("ASCII_DblTok_Name"), true);
        int skipcnt = this.config.getIntProperty(iSQLUtilites.getString("ASCII_Skip_Name"), 0);
        char textQualifier = this.config.getCharacterProperty(iSQLUtilites.getString("ASCII_Quote_Name"), '\u0000');
        char commentQualifier = this.config.getCharacterProperty(iSQLUtilites.getString("ASCII_Comment_Name"), '#');
        StringTokenizer line = new StringTokenizer("", delims, false, !dTokens);
        StringBuffer buff = new StringBuffer("");
        Vector<String> row = new Vector<String>();
        int i = 0;
        while (i < skipcnt) {
            if (br.ready()) {
                this.fireFilterProgress((int)((double)(bytesRead += br.readLine().getBytes().length) / (double)totalByteCount * 100.0));
            }
            ++i;
        }
        while (br.ready()) {
            buff.setLength(0);
            buff.append(br.readLine());
            this.fireFilterProgress((int)((double)(bytesRead += buff.toString().getBytes().length) / (double)totalByteCount * 100.0));
            if (buff.charAt(0) == commentQualifier) continue;
            line.setString(buff.toString());
            row.clear();
            while (line.hasMoreTokens()) {
                String Token = line.nextToken(delims);
                if (Token.charAt(0) == textQualifier && Token.charAt(Token.length() - 1) != textQualifier) {
                    String before = Token;
                    Token = before.concat(line.nextToken(String.valueOf(textQualifier) + "\r\n"));
                    line.nextToken(delims);
                }
                if (Token.indexOf(textQualifier) >= 0) {
                    Token = Token.substring(Token.indexOf(textQualifier) + 1, Token.lastIndexOf(textQualifier)).trim();
                }
                row.add(new String(Token.toCharArray()));
                this.checkIfCancelled();
            }
            if (row.size() > tm.getColumnCount()) {
                tm.setColumnCount(row.size());
            }
            if (row.size() == 1 && tm.getColumnCount() != 1) continue;
            tm.addRow((Vector)row.clone());
        }
        try {
            br.close();
        }
        catch (Throwable throwable) {}
        return 0;
    }

    public int filter(Object data, OutputStream os) throws IOException, InterruptedException {
        TableModel model = (TableModel)data;
        StringBuffer buff = new StringBuffer("");
        String Delimiter = StringUtilities.decode(this.config.getStringProperty(iSQLUtilites.getString("ASCII_Delimiter_Name"), ","));
        PrintWriter pw = new PrintWriter(os);
        boolean useSmartQuotes = this.config.getBooleanProperty(iSQLUtilites.getString("ASCII_SmartQuotes_Name"), false);
        boolean useHeader = this.config.getBooleanProperty(iSQLUtilites.getString("ASCII_IncludeHead_Name"), false);
        boolean doEncode = this.config.getBooleanProperty(iSQLUtilites.getString("ASCII_Encode_NPC_Name"), false);
        boolean includeColumNames = this.config.getBooleanProperty(iSQLUtilites.getString("ASCII_IncludeCols_Name"), false);
        if (useHeader) {
            pw.println("# " + this.config.getStringProperty(iSQLUtilites.getString("ASCII_CustomHeader_Name"), iSQLUtilites.getString("ASCII_CustomHeader_Value")));
            pw.println("# " + new Date());
        }
        if (includeColumNames) {
            buff.setLength(0);
            int j = 0;
            while (j < model.getColumnCount()) {
                String s = model.getColumnName(j);
                if (useSmartQuotes && s != null && (s.indexOf(Delimiter) >= 0 || s.indexOf(32) >= 0)) {
                    s = "\"" + s + "\"";
                }
                if (doEncode) {
                    buff.append(StringUtilities.encode(s, false, false));
                } else {
                    buff.append(s);
                }
                buff.append(Delimiter);
                ++j;
            }
            pw.println(buff);
            pw.flush();
        }
        int r = 0;
        while (r < model.getRowCount()) {
            buff.setLength(0);
            int c = 0;
            while (c < model.getColumnCount()) {
                Object o = model.getValueAt(r, c);
                String s = o instanceof String ? (String)o : (o != null ? o.toString() : "null");
                if (useSmartQuotes && s != null && (s.indexOf(Delimiter) >= 0 || s.indexOf(32) >= 0)) {
                    s = "\"" + s + "\"";
                }
                if (doEncode) {
                    buff.append(StringUtilities.encode(s, false, false));
                } else {
                    buff.append(s);
                }
                buff.append(Delimiter);
                ++c;
            }
            pw.println(buff);
            pw.flush();
            this.fireFilterProgress((int)(100.0 * ((double)(r + 1) / (double)model.getRowCount())));
            try {
                this.checkIfCancelled();
            }
            catch (InterruptedException ie) {
                try {
                    pw.flush();
                    pw.close();
                }
                catch (Exception exception) {}
                throw ie;
            }
            ++r;
        }
        try {
            pw.flush();
            pw.close();
        }
        catch (Exception exception) {}
        return 0;
    }
}

