/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.swing.Icon;
import javax.swing.table.DefaultTableModel;
import org.I00acres.isql.swing.table.ResultSetTableModel;
import org.I00acres.isql.util.SimpleTableFilter;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.util.StringUtilities;

public class XMLTableFilter
extends SimpleTableFilter {
    static /* synthetic */ Class class$0;

    public XMLTableFilter() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.I00acres.isql.swing.table.ResultSetTableModel");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setExportableClass(clazz);
    }

    public String getContentType() {
        return "text/xml";
    }

    public int filter(DefaultTableModel tm, InputStream is) throws IOException {
        return -1;
    }

    public int filter(Object data, OutputStream os) throws IOException, InterruptedException {
        ResultSetTableModel model = (ResultSetTableModel)data;
        PrintWriter pw = new PrintWriter(os);
        boolean isPCDATA = this.config.getBooleanProperty(this.getExportProperties()[0].name, false);
        if (!model.isShowingMetadata()) {
            model.showMetaData();
        }
        int COLUMN_NAME = this.LocateColumnByName("ColumnName", model);
        pw.println("<?xml version=\"1.0\"?>");
        pw.println(" <ResultSet>");
        int r = 0;
        while (r < model.getRowCount()) {
            pw.println("  <Column name=\"" + model.getValueAt(r, COLUMN_NAME) + "\">");
            int c = 0;
            while (c < model.getColumnCount()) {
                if (c != COLUMN_NAME) {
                    if (isPCDATA) {
                        pw.println("   <Property name=\"" + model.getColumnName(c) + "\" >" + model.getValueAt(r, c) + "</Property>");
                    } else {
                        pw.println("   <Property name=\"" + model.getColumnName(c) + "\" value=\"" + StringUtilities.encodeXML(model.getValueAt(r, c).toString()) + "\" />");
                    }
                }
                ++c;
            }
            pw.println("  </Column>");
            this.fireFilterProgress((int)(100.0 * ((double)(r + 1) / (double)model.getRowCount())));
            try {
                this.checkIfCancelled();
            }
            catch (InterruptedException ie) {
                try {
                    pw.flush();
                    pw.close();
                }
                catch (Exception exception) {}
                throw ie;
            }
            ++r;
        }
        pw.println(" </ResultSet>");
        try {
            pw.flush();
            pw.close();
        }
        catch (Exception exception) {}
        return 1;
    }

    public boolean isExportable() {
        return true;
    }

    public boolean isImportable() {
        return false;
    }

    protected void addExportProperties() {
        this.addBooleanExportProperty(iSQLUtilites.getString("XML_SetValue_Name"), null, false, iSQLUtilites.getString("XML_SetValue_Desc"));
    }

    protected void addImportProperties() {
    }

    public String getName() {
        return iSQLUtilites.getString("XML_Handler_Name");
    }

    public String getExportContentType() {
        return "text/xml";
    }

    public Icon getUserIcon() {
        return iSQLUtilites.loadIconResource("Xml16");
    }

    private int LocateColumnByName(String Col, ResultSetTableModel model) {
        int i = 0;
        while (i < model.getColumnCount()) {
            if (model.getColumnName(i).equalsIgnoreCase(Col)) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

