/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.swing;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;

public class CompoundIcon
implements Icon {
    static int lastX = 0;
    static int lastY = 0;
    Icon right;
    Icon left;

    public CompoundIcon(Icon ico1, Icon ico2) {
        this.left = ico1;
        this.right = ico2;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        lastX = x;
        lastY = y;
        if (this.left != null) {
            this.left.paintIcon(c, g, x, y);
        }
        if (this.right != null) {
            this.right.paintIcon(c, g, x + this.left.getIconWidth() + 2, y);
        }
    }

    public Icon getRightIcon() {
        return this.right;
    }

    public Icon getLeftIcon() {
        return this.left;
    }

    public void setRightIcon(Icon icon) {
        this.right = icon;
    }

    public int getIconWidth() {
        return this.left.getIconWidth() + this.right.getIconWidth() + 2;
    }

    public boolean isOverIcon(int x, int y) {
        if (x < lastX || x > lastX + this.left.getIconWidth()) {
            return false;
        }
        return y >= lastY && y <= lastX + this.left.getIconHeight();
    }

    public int getIconHeight() {
        return Math.max(this.right.getIconHeight(), this.left.getIconHeight());
    }
}

