/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.OdbcDef;
import IT.picosoft.jdbc.OdbcStatement;
import IT.picosoft.jdbc.PicoBoundCol;
import IT.picosoft.jdbc.PicoConnection;
import IT.picosoft.jdbc.PicoDbApi;
import IT.picosoft.jdbc.PicoInputStream;
import IT.picosoft.jdbc.PicoLimits;
import IT.picosoft.jdbc.PicoPseudoCol;
import IT.picosoft.jdbc.PicoResultSetMetaData;
import IT.picosoft.jdbc.PicoSQLWarning;
import IT.picosoft.jdbc.PicoStatement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Map;

public class PicoResultSet
implements ResultSet {
    protected PicoDbApi odbcApi;
    protected PicoConnection con;
    private OdbcStatement hStmt;
    protected SQLWarning lastWarning;
    protected PicoBoundCol[] boundCols;
    protected int numberOfCols;
    protected int numResultCols;
    protected int firstPseudoCol;
    protected int lastPseudoCol;
    protected PicoPseudoCol[] pseudoCols;
    protected int[] colMappings;
    protected ResultSetMetaData rsmd;
    private Hashtable colNameToNum;
    private Hashtable colNumToName;
    private boolean lastColumnNull;
    private boolean closed;
    private int sqlTypeColumn;
    private boolean freed;
    protected PicoStatement ownerStatement;
    protected Object[] data;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;

    private String rmDot(String string) {
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string;
    }

    private Object getData(int n, Class clazz) throws SQLException {
        Object object = null;
        if (this.data == null) {
            if (this.firstPseudoCol > 0) {
                int n2 = this.firstPseudoCol - 1;
            } else {
                int n3 = this.getColumnCount();
            }
            this.data = this.odbcApi.SQLGetAllData(this.getHSTMT(), this.boundCols);
        }
        if (n > this.data.length) {
            object.toString();
            object = clazz == (class$java$lang$Double == null ? (class$java$lang$Double = PicoResultSet.class$("java.lang.Double")) : class$java$lang$Double) ? this.odbcApi.SQLGetDataDouble(this.getHSTMT(), n) : (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = PicoResultSet.class$("java.lang.Float")) : class$java$lang$Float) ? this.odbcApi.SQLGetDataFloat(this.getHSTMT(), n) : (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = PicoResultSet.class$("java.lang.Integer")) : class$java$lang$Integer) ? this.odbcApi.SQLGetDataInteger(this.getHSTMT(), n) : (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PicoResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp) ? this.odbcApi.SQLGetDataTimestamp(this.getHSTMT(), n) : (clazz == (array$B == null ? (array$B = PicoResultSet.class$("[B")) : array$B) ? (Object)this.odbcApi.SQLGetDataBytes(this.getHSTMT(), n) : this.odbcApi.SQLGetDataString(this.getHSTMT(), n, 256, false)))));
        } else {
            object = this.data[n - 1];
            if (object != null) {
                if (clazz == (class$java$lang$String == null ? (class$java$lang$String = PicoResultSet.class$("java.lang.String")) : class$java$lang$String)) {
                    if (!(object instanceof String)) {
                        object = object.toString();
                    }
                } else if (clazz == (class$java$lang$Double == null ? (class$java$lang$Double = PicoResultSet.class$("java.lang.Double")) : class$java$lang$Double)) {
                    if (!(object instanceof Double)) {
                        object = new Double(object.toString());
                    }
                } else if (clazz == (class$java$lang$Float == null ? (class$java$lang$Float = PicoResultSet.class$("java.lang.Float")) : class$java$lang$Float)) {
                    if (!(object instanceof Float)) {
                        object = new Float(object.toString());
                    }
                } else if (clazz == (class$java$lang$Integer == null ? (class$java$lang$Integer = PicoResultSet.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    if (!(object instanceof Integer)) {
                        object = new Integer(this.rmDot(object.toString()));
                    }
                } else if (clazz == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PicoResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                    if (!(object instanceof Timestamp)) {
                        object = Timestamp.valueOf(object.toString());
                    }
                } else if (clazz == (class$java$sql$Date == null ? (class$java$sql$Date = PicoResultSet.class$("java.sql.Date")) : class$java$sql$Date)) {
                    if (!(object instanceof Date)) {
                        object = Date.valueOf(object.toString());
                    }
                } else if (clazz == (class$java$sql$Time == null ? (class$java$sql$Time = PicoResultSet.class$("java.sql.Time")) : class$java$sql$Time) && !(object instanceof Time)) {
                    object = Time.valueOf(object.toString());
                }
            }
        }
        return object;
    }

    protected OdbcStatement getHSTMT() {
        if (this.ownerStatement != null) {
            return this.ownerStatement.getHSTMT();
        }
        return this.hStmt;
    }

    private PicoResultSet(PicoDbApi picoDbApi, PicoConnection picoConnection) throws SQLException {
        this.odbcApi = picoDbApi;
        this.con = picoConnection;
        this.hStmt = null;
        this.lastWarning = null;
        this.numResultCols = -1;
        this.lastColumnNull = false;
        this.ownerStatement = null;
    }

    public PicoResultSet(PicoDbApi picoDbApi, OdbcStatement odbcStatement, PicoConnection picoConnection) throws SQLException {
        this(picoDbApi, picoConnection);
        this.hStmt = odbcStatement;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ResultSet.initialize " + this + ",hStmt=" + odbcStatement);
        }
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new PicoBoundCol[this.numberOfCols];
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i] = new PicoBoundCol();
        }
    }

    public PicoResultSet(PicoDbApi picoDbApi, PicoStatement picoStatement) throws SQLException {
        this(picoDbApi, picoStatement.myConnection);
        this.ownerStatement = picoStatement;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ResultSet.initialize " + this + ",hStmt=" + this.getHSTMT() + ",stmt=" + this.ownerStatement);
        }
        this.numberOfCols = this.getColumnCount();
        this.boundCols = new PicoBoundCol[this.numberOfCols];
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i] = new PicoBoundCol();
        }
    }

    public boolean absolute(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.absolute(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void afterLast() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.afterLast()");
        }
        throw new UnsupportedOperationException();
    }

    public void beforeFirst() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.beforeFirst()");
        }
        throw new UnsupportedOperationException();
    }

    public void cancelRowUpdates() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.cancelRowUpdates()");
        }
        throw new UnsupportedOperationException();
    }

    public void clearWarnings() throws SQLException {
        this.lastWarning = null;
    }

    public synchronized void close() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*close ResultSet=" + this.getHSTMT() + ", freed=" + this.freed + ", stmt=" + this.ownerStatement + ", this=" + this);
        }
        if (!this.closed && !this.con.isClosed() && this.odbcApi != null) {
            this.closeInputStreams();
            this.clearWarnings();
            this.lastColumnNull = false;
            if (this.ownerStatement != null) {
                if (!this.freed) {
                    this.getHSTMT().close();
                    this.freed = true;
                }
            } else {
                this.getHSTMT().drop();
            }
        }
        this.closed = true;
    }

    protected void closeInputStreams() {
        for (int i = 0; i < this.numberOfCols; ++i) {
            this.boundCols[i].closeInputStream();
        }
    }

    public void deleteRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.deleteRow()");
        }
        throw new UnsupportedOperationException();
    }

    protected void finalize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("ResultSet.finalize " + this);
        }
        try {
            this.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public synchronized int findColumn(String string) throws SQLException {
        Integer n;
        if (this.rsmd == null) {
            this.rsmd = this.getMetaData();
            this.colNameToNum = new Hashtable();
            this.colNumToName = new Hashtable();
        }
        if ((n = (Integer)this.colNameToNum.get(string)) == null) {
            for (int i = 1; i <= this.rsmd.getColumnCount(); ++i) {
                String string2 = (String)this.colNumToName.get(new Integer(i));
                if (string2 == null) {
                    string2 = this.rsmd.getColumnName(i);
                    this.colNameToNum.put(string2, new Integer(i));
                    this.colNumToName.put(new Integer(i), string2);
                }
                if (!string2.equalsIgnoreCase(string)) continue;
                return i;
            }
            throw new SQLException("Column not found", "S0022");
        }
        return n;
    }

    public boolean first() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.first()");
        }
        throw new UnsupportedOperationException();
    }

    public Array getArray(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getArray(int i");
        }
        throw new UnsupportedOperationException();
    }

    public Array getArray(String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getArray(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateArray(int n, Array array) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateArray(int columnIndex, Array x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateArray(String string, Array array) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateArray(String columnName, Array x)");
        }
        throw new UnsupportedOperationException();
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
            }
        }
        PicoInputStream picoInputStream = new PicoInputStream(this.odbcApi, this.getHSTMT(), n, 1, n3, this.ownerStatement);
        this.setInputStream(n, picoInputStream);
        return picoInputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        BigDecimal bigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            String string = this.getDataString(n, PicoLimits.DEFAULT_BUFFER_LENGTH, true);
            if (string != null) {
                bigDecimal = new BigDecimal(string.trim());
            }
        } else {
            this.lastColumnNull = true;
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        BigDecimal bigDecimal = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            String string = this.getDataString(n, PicoLimits.DEFAULT_BUFFER_LENGTH, true);
            if (string != null) {
                bigDecimal = new BigDecimal(string.trim());
                bigDecimal = bigDecimal.setScale(n2, 4);
            }
        } else {
            this.lastColumnNull = true;
        }
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
            }
        }
        PicoInputStream picoInputStream = new PicoInputStream(this.odbcApi, this.getHSTMT(), n, 3, n3, this.ownerStatement);
        this.setInputStream(n, picoInputStream);
        return picoInputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public Blob getBlob(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getBlob(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Blob getBlob(String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getBlob(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBlob(int n, Blob blob) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBlob(int columnIndex, Blob x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBlob(String string, Blob blob) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBlob(String columnName, Blob x)");
        }
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(int n) throws SQLException {
        boolean bl = false;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            bl = this.getInt(n) != 0;
        } else {
            this.lastColumnNull = true;
        }
        return bl;
    }

    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLException {
        byte by = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            by = (byte)this.getInt(n);
        } else {
            this.lastColumnNull = true;
        }
        return by;
    }

    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        byte[] byArray = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            byArray = (byte[])this.getData(n, array$B == null ? (array$B = PicoResultSet.class$("[B")) : array$B);
        } else {
            this.lastColumnNull = true;
        }
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    public Reader getCharacterStream(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getCharacterStream(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Reader getCharacterStream(String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getCharacterStream(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public Clob getClob(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getClob(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Clob getClob(String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getClob(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateClob(int n, Clob clob) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateClob(int columnIndex, Clob x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateClob(String string, Clob clob) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateClob(String columnName, Clob x)");
        }
        throw new UnsupportedOperationException();
    }

    public int getColAttribute(int n, short s) throws SQLException {
        int n2 = 0;
        this.clearWarnings();
        try {
            n2 = this.odbcApi.SQLColAttributes(this.getHSTMT(), (short)n, s);
            if (s == 2) {
                n2 = OdbcDef.odbcTypeToJdbc(n2);
            }
        }
        catch (PicoSQLWarning picoSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)picoSQLWarning.value;
            n2 = bigDecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        return n2;
    }

    public int getColumnCount() throws SQLException {
        int n = 0;
        this.clearWarnings();
        if (this.lastPseudoCol > 0) {
            return this.lastPseudoCol;
        }
        if (this.colMappings != null) {
            return this.colMappings.length;
        }
        try {
            if (this.numResultCols == -1) {
                this.numResultCols = this.odbcApi.SQLNumResultCols(this.getHSTMT());
            }
            n = this.numResultCols;
        }
        catch (PicoSQLWarning picoSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)picoSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        return n;
    }

    public int getColumnLength(int n) throws SQLException {
        int n2 = -1;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.boundCols[n - 1].getLength();
        }
        if (n2 == -1) {
            n2 = this.getColAttribute(n, (short)3);
            if (n > 0 && n <= this.numberOfCols) {
                this.boundCols[n - 1].setLength(n2);
            }
        }
        return n2;
    }

    public int getColumnType(int n) throws SQLException {
        int n2 = 9999;
        if (n > 0 && n <= this.numberOfCols) {
            n2 = this.boundCols[n - 1].getType();
        }
        if (n2 == 9999) {
            n2 = this.getColAttribute(n, (short)2);
            if (n > 0 && n <= this.numberOfCols) {
                this.boundCols[n - 1].setType(n2);
            }
        }
        return n2;
    }

    public int getConcurrency() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.getConcurrency()");
        }
        return 1008;
    }

    public String getCursorName() throws SQLException {
        String string = "";
        this.clearWarnings();
        try {
            string = this.odbcApi.SQLGetCursorName(this.getHSTMT());
        }
        catch (PicoSQLWarning picoSQLWarning) {
            string = (String)picoSQLWarning.value;
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        return string.trim();
    }

    public Double getDataDouble(int n) throws SQLException {
        Double d;
        this.lastColumnNull = false;
        try {
            d = (Double)this.getData(n, class$java$lang$Double == null ? (class$java$lang$Double = PicoResultSet.class$("java.lang.Double")) : class$java$lang$Double);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            d = (Double)picoSQLWarning.value;
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        if (d == null) {
            this.lastColumnNull = true;
        }
        return d;
    }

    public Float getDataFloat(int n) throws SQLException {
        Float f;
        this.lastColumnNull = false;
        try {
            f = (Float)this.getData(n, class$java$lang$Float == null ? (class$java$lang$Float = PicoResultSet.class$("java.lang.Float")) : class$java$lang$Float);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            f = (Float)picoSQLWarning.value;
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        if (f == null) {
            this.lastColumnNull = true;
        }
        return f;
    }

    public Integer getDataInteger(int n) throws SQLException {
        Integer n2;
        this.lastColumnNull = false;
        try {
            n2 = (Integer)this.getData(n, class$java$lang$Integer == null ? (class$java$lang$Integer = PicoResultSet.class$("java.lang.Integer")) : class$java$lang$Integer);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            n2 = (Integer)picoSQLWarning.value;
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        if (n2 == null) {
            this.lastColumnNull = true;
        } else if (n == this.sqlTypeColumn) {
            n2 = new Integer(OdbcDef.odbcTypeToJdbc(n2));
        }
        return n2;
    }

    public Long getDataLong(int n) throws SQLException {
        Long l = null;
        Double d = this.getDataDouble(n);
        if (d != null) {
            l = new Long(d.longValue());
        }
        return l;
    }

    public String getDataString(int n, int n2, boolean bl) throws SQLException {
        String string;
        this.lastColumnNull = false;
        try {
            string = (String)this.getData(n, class$java$lang$String == null ? (class$java$lang$String = PicoResultSet.class$("java.lang.String")) : class$java$lang$String);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            string = (String)picoSQLWarning.value;
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        if (string == null) {
            this.lastColumnNull = true;
        } else if (n == this.sqlTypeColumn) {
            try {
                int n3 = OdbcDef.odbcTypeToJdbc(Integer.valueOf(string));
                string = String.valueOf(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    public Date getDate(int n) throws SQLException {
        return new Date(this.getTimestamp(n).getTime());
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return new Date(this.getTimestamp(n, calendar).getTime());
    }

    public Date getDate(String string) throws SQLException {
        return this.getDate(this.findColumn(string));
    }

    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLException {
        double d = 0.0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Double d2 = this.getDataDouble(n);
            if (d2 != null) {
                d = d2;
            }
        } else {
            this.lastColumnNull = true;
        }
        return d;
    }

    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    public int getFetchDirection() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getFetchDirection()");
        }
        throw new UnsupportedOperationException();
    }

    public int getFetchSize() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getFetchSize()");
        }
        throw new UnsupportedOperationException();
    }

    public float getFloat(int n) throws SQLException {
        float f = 0.0f;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Float f2 = this.getDataFloat(n);
            if (f2 != null) {
                f = f2.floatValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return f;
    }

    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLException {
        int n2 = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Integer n3 = this.getDataInteger(n);
            if (n3 != null) {
                n2 = n3;
            }
        } else {
            this.lastColumnNull = true;
        }
        return n2;
    }

    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLException {
        long l = 0L;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            Double d = this.getDataDouble(n);
            if (d != null) {
                l = d.longValue();
            }
        } else {
            this.lastColumnNull = true;
        }
        return l;
    }

    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    protected int getMaxBinaryLen(int n) throws SQLException {
        int n2 = this.getColumnLength(n);
        if (n2 != -1 && (n2 <= 0 || n2 > PicoLimits.MAX_GET_DATA_LENGTH)) {
            n2 = PicoLimits.MAX_GET_DATA_LENGTH;
        }
        return n2;
    }

    protected int getMaxCharLen(int n) throws SQLException {
        int n2 = this.getColumnType(n);
        int n3 = this.getColumnLength(n);
        if (n3 != -1) {
            switch (n2) {
                case -4: 
                case -3: 
                case -2: {
                    n3 *= 2;
                    break;
                }
                case 91: {
                    n3 = 10;
                    break;
                }
                case 92: {
                    n3 = 8;
                    break;
                }
                case 93: {
                    n3 = 29;
                    break;
                }
                case 2: 
                case 3: {
                    n3 += 2;
                    break;
                }
                case -7: {
                    n3 = 1;
                    break;
                }
                case -6: {
                    n3 = 4;
                    break;
                }
                case 5: {
                    n3 = 6;
                    break;
                }
                case 4: {
                    n3 = 11;
                    break;
                }
                case -5: {
                    n3 = 20;
                    break;
                }
                case 7: {
                    n3 = 13;
                    break;
                }
                case 6: 
                case 8: {
                    n3 = 22;
                }
            }
            if (n3 <= 0 || n3 > PicoLimits.MAX_GET_DATA_LENGTH) {
                n3 = PicoLimits.MAX_GET_DATA_LENGTH;
            }
        }
        return n3;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSet.getMetaData");
        }
        if (this.closed) {
            throw new SQLException("ResultSet is closed");
        }
        return new PicoResultSetMetaData(this.odbcApi, this);
    }

    public Object getObject(int n) throws SQLException {
        Object object = null;
        int n2 = this.getColumnType(n);
        int n3 = n;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                object = this.getString(n);
                break;
            }
            case 2: 
            case 3: {
                object = this.getBigDecimal(n, this.getScale(n3));
                break;
            }
            case -7: {
                object = new Boolean(this.getBoolean(n));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                object = new Integer(this.getInt(n));
                break;
            }
            case -5: {
                object = new Long(this.getLong(n));
                break;
            }
            case 7: {
                object = new Float(this.getFloat(n));
                break;
            }
            case 6: 
            case 8: {
                object = new Double(this.getDouble(n));
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                object = this.getBytes(n);
                break;
            }
            case 91: {
                object = this.getDate(n);
                break;
            }
            case 92: {
                object = this.getTime(n);
                break;
            }
            case 93: {
                object = this.getTimestamp(n);
            }
        }
        if (this.wasNull()) {
            object = null;
        }
        return object;
    }

    public Object getObject(int n, Map map) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getObject(int i, Map map)");
        }
        throw new UnsupportedOperationException();
    }

    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(String string, Map map) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getObject(String s, Map map)");
        }
        throw new UnsupportedOperationException();
    }

    public PicoPseudoCol getPseudoCol(int n) {
        PicoPseudoCol picoPseudoCol = null;
        if (n > 0 && n >= this.firstPseudoCol && n <= this.lastPseudoCol) {
            picoPseudoCol = this.pseudoCols[n - this.firstPseudoCol];
        }
        return picoPseudoCol;
    }

    public Ref getRef(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getRef(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public Ref getRef(String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getRef(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateRef(int n, Ref ref) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateRef(int columnIndex, Ref x)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateRef(String string, Ref ref) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateRef(String columnName, Ref x)");
        }
        throw new UnsupportedOperationException();
    }

    public int getRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getRow()");
        }
        throw new UnsupportedOperationException();
    }

    public int getRowCount() throws SQLException {
        int n = 0;
        this.clearWarnings();
        try {
            n = this.odbcApi.SQLRowCount(this.getHSTMT());
        }
        catch (PicoSQLWarning picoSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)picoSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        return n;
    }

    public int getRowNumber() throws SQLException {
        int n = 0;
        this.clearWarnings();
        try {
            n = this.odbcApi.SQLGetStmtOption(this.getHSTMT(), (short)14);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            BigDecimal bigDecimal = (BigDecimal)picoSQLWarning.value;
            n = bigDecimal.intValue();
            this.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        return n;
    }

    public int getScale(int n) throws SQLException {
        int n2;
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            n2 = 0;
        } else {
            n2 = this.getColAttribute(n, (short)5);
        }
        return n2;
    }

    public short getShort(int n) throws SQLException {
        short s = 0;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            s = (short)this.getInt(n);
        } else {
            this.lastColumnNull = true;
        }
        return s;
    }

    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    public Statement getStatement() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.getStatement()");
        }
        throw new UnsupportedOperationException();
    }

    public String getString(int n) throws SQLException {
        String string;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) != null) {
            this.lastColumnNull = true;
            return null;
        }
        int n2 = this.getMaxCharLen(n);
        if (n2 == -1) {
            return null;
        }
        boolean bl = false;
        int n3 = this.getColumnType(n);
        if ((string = this.getDataString(n, ++n2, bl)) == null) {
            return string;
        }
        int n4 = string.length();
        if (n4 == n2 - 1 && !bl) {
            string = string.substring(0, n2 - 1);
        }
        if ((n3 == -1 || n3 == -4) && n4 == n2 - 1) {
            String string2 = string;
            while (string2.length() == PicoLimits.MAX_GET_DATA_LENGTH && (string2 = this.getDataString(n, n2, bl)) != null) {
                if (DriverManager.getLogWriter() != null) {
                    DriverManager.println(string2.length() + " byte(s) read");
                }
                if (string2.length() == n2) {
                    string2 = string2.substring(0, n2 - 1);
                }
                string = string + string2;
                if (DriverManager.getLogWriter() == null) continue;
                DriverManager.println(string.length() + " bytes total");
            }
        }
        return string;
    }

    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLException {
        return new Time(this.getTimestamp(n).getTime());
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return new Time(this.getTimestamp(n, calendar).getTime());
    }

    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        Timestamp timestamp = null;
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        if (this.getPseudoCol(n) == null) {
            timestamp = (Timestamp)this.getData(n, class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PicoResultSet.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        } else {
            this.lastColumnNull = true;
        }
        return timestamp;
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        calendar.setTime(this.getTimestamp(n));
        return new Timestamp(calendar.getTime().getTime());
    }

    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public URL getURL(int n) throws SQLException {
        URL uRL = null;
        try {
            uRL = new URL(this.getString(n));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public URL getURL(String string) throws SQLException {
        URL uRL = null;
        try {
            uRL = new URL(this.getString(string));
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return uRL;
    }

    public int getType() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.getType()");
        }
        return 1005;
    }

    public InputStream getUnicodeStream(int n) throws SQLException {
        this.clearWarnings();
        this.lastColumnNull = false;
        n = this.mapColumn(n);
        int n2 = this.getColumnType(n);
        int n3 = -2;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                n3 = 1;
            }
        }
        PicoInputStream picoInputStream = new PicoInputStream(this.odbcApi, this.getHSTMT(), n, 2, n3, this.ownerStatement);
        this.setInputStream(n, picoInputStream);
        return picoInputStream;
    }

    public InputStream getUnicodeStream(String string) throws SQLException {
        return this.getUnicodeStream(this.findColumn(string));
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.lastWarning;
    }

    public void insertRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.insertRow()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isAfterLast() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isAfterLast()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isBeforeFirst() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isBeforeFirst()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isFirst() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isFirst()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean isLast() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.isLast()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean last() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.last()");
        }
        throw new UnsupportedOperationException();
    }

    public int mapColumn(int n) {
        int n2 = n;
        if (this.colMappings != null) {
            n2 = n > 0 && n <= this.colMappings.length ? this.colMappings[n - 1] : -1;
        }
        return n2;
    }

    public void moveToCurrentRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.moveToCurrentRow()");
        }
        throw new UnsupportedOperationException();
    }

    public void moveToInsertRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.moveToInsertRow()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean next() throws SQLException {
        boolean bl = true;
        this.lastColumnNull = false;
        this.closeInputStreams();
        this.clearWarnings();
        this.data = null;
        try {
            bl = this.odbcApi.SQLFetch(this.getHSTMT());
        }
        catch (PicoSQLWarning picoSQLWarning) {
            this.setWarning(picoSQLWarning);
        }
        return bl;
    }

    public boolean previous() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.previous()");
        }
        throw new UnsupportedOperationException();
    }

    public void refreshRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.refreshRow()");
        }
        throw new UnsupportedOperationException();
    }

    public boolean relative(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.relative(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public boolean rowDeleted() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.rowDeleted()=false");
        }
        return false;
    }

    public boolean rowInserted() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.rowInserted()=false");
        }
        return false;
    }

    public boolean rowUpdated() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSet.rowUpdated()=false");
        }
        return false;
    }

    public void setColumnMappings(int[] nArray) {
        this.colMappings = nArray;
    }

    public void setFetchDirection(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.setFetchDirection(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void setFetchSize(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.setFetchSize(int i)");
        }
        throw new UnsupportedOperationException();
    }

    protected void setInputStream(int n, PicoInputStream picoInputStream) {
        if (n > 0 && n <= this.numberOfCols) {
            this.boundCols[n - 1].setInputStream(picoInputStream);
        }
    }

    public void setPseudoCols(int n, int n2, PicoPseudoCol[] picoPseudoColArray) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Setting pseudo columns, first=" + n + ", last=" + n2);
        }
        this.firstPseudoCol = n;
        this.lastPseudoCol = n2;
        this.pseudoCols = picoPseudoColArray;
    }

    public void setSQLTypeColumn(int n) {
        this.sqlTypeColumn = n;
    }

    public void setWarning(SQLWarning sQLWarning) throws SQLException {
        this.lastWarning = sQLWarning;
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateAsciiStream(int i, InputStream inputstream, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateAsciiStream(String s, InputStream inputstream, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBigDecimal(int i, BigDecimal bigdecimal)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBigDecimal(String s, BigDecimal bigdecimal)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBinaryStream(int i, InputStream inputstream, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBinaryStream(String s, InputStream inputstream, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(int n, boolean bl) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBoolean(int i, boolean flag)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBoolean(String string, boolean bl) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBoolean(String s, boolean flag)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateByte(int n, byte by) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateByte(int i, byte byte0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateByte(String string, byte by) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateByte(String s, byte byte0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBytes(int n, byte[] byArray) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBytes(int i, byte abyte0[])");
        }
        throw new UnsupportedOperationException();
    }

    public void updateBytes(String string, byte[] byArray) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateBytes(String s, byte abyte0[])");
        }
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(int n, Reader reader, int n2) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateCharacterStream(int i, Reader reader, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateCharacterStream(String string, Reader reader, int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateCharacterStream(String s, Reader reader, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDate(int n, Date date) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDate(int i, java.sql.Date date)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDate(String string, Date date) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDate(String s, java.sql.Date date)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDouble(int n, double d) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDouble(int i, double d)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateDouble(String string, double d) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateDouble(String s, double d)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateFloat(int n, float f) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateFloat(int i, float f)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateFloat(String string, float f) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateFloat(String s, float f)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateInt(int n, int n2) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateInt(int i, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateInt(String string, int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateInt(String s, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateLong(int n, long l) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateLong(int i, long l)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateLong(String string, long l) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateLong(String s, long l)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateNull(int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateNull(int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateNull(String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateNull(String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(int n, Object object) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(int i, Object obj)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(int n, Object object, int n2) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(int i, Object obj, int j)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(String string, Object object) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(String s, Object obj)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateObject(String string, Object object, int n) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateObject(String s, Object obj, int i)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateRow() {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateRow()");
        }
        throw new UnsupportedOperationException();
    }

    public void updateShort(int n, short s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateShort(int i, short word0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateShort(String string, short s) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateShort(String s, short word0)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateString(int n, String string) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateString(int i, String s)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateString(String string, String string2) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateString(String s, String s1)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTime(int n, Time time) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTime(int i, Time time)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTime(String string, Time time) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTime(String s, Time time)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(int n, Timestamp timestamp) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTimestamp(int i, Timestamp timestamp)");
        }
        throw new UnsupportedOperationException();
    }

    public void updateTimestamp(String string, Timestamp timestamp) {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("Unsupported PicoResultSet.updateTimestamp(String s, Timestamp timestamp)");
        }
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws SQLException {
        return this.lastColumnNull;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

