/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import org.I00acres.isql.swing.table.Sortable;

public class SortableHeaderRenderer
extends JLabel
implements TableCellRenderer {
    private int sortedColumn = -1;
    private String sortedColumnName = null;
    private boolean sortAsc = false;
    private int renderColumn = -1;
    private TableColumnModelListener columnListener = new SortableColumnModelListener();

    public SortableHeaderRenderer(JTable table) {
        table.getColumnModel().addColumnModelListener(this.columnListener);
        this.setHorizontalAlignment(0);
        this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon ico;
        JTableHeader header;
        if (table != null && (header = table.getTableHeader()) != null) {
            this.setForeground(header.getForeground());
            this.setBackground(header.getBackground());
            this.setFont(header.getFont());
        }
        if (this.sortedColumnName != null && this.renderColumn == column) {
            String tColumn = table.getColumnName(column);
            if (tColumn.compareTo(this.sortedColumnName) == 0) {
                if (this.sortAsc) {
                    this.setIcon(new BasicArrowIcon(5, 4));
                } else {
                    this.setIcon(new BasicArrowIcon(1, 4));
                }
            }
        } else {
            this.setIcon(null);
        }
        if ((ico = this.getIcon()) != null) {
            this.setSize(this.getPreferredSize().width + ico.getIconWidth(), this.getHeight());
        } else {
            this.setSize(this.getPreferredSize());
        }
        this.setText(value == null ? "" : value.toString());
        SwingUtilities.layoutCompoundLabel(this, ((Component)this).getFontMetrics(this.getFont()), this.getText(), this.getIcon(), 0, 2, 0, 2, new Rectangle(this.getPreferredSize()), new Rectangle(this.getWidth() - 16, 16, 16, 16), new Rectangle(0, 0, this.getWidth() - 16, this.getHeight()), 0);
        return this;
    }

    public boolean isAscending() {
        return this.sortAsc;
    }

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public int getRenderedSortedColumn() {
        return this.renderColumn;
    }

    public synchronized void setSortedColumn(int column, JTable Table, boolean asc) {
        this.sortAsc = asc;
        this.renderColumn = column;
        String guiColumnName = Table.getColumnName(column);
        Sortable mdl = (Sortable)((Object)Table.getModel());
        this.sortedColumn = mdl.getIndexOfColumnName(guiColumnName);
        this.sortedColumnName = guiColumnName;
    }

    public static class BasicArrowIcon
    implements Icon,
    SwingConstants {
        private int direction = 1;
        private int size = 0;

        public BasicArrowIcon() {
            this(3);
        }

        public BasicArrowIcon(int dir) {
            this(dir, 16);
        }

        public BasicArrowIcon(int dir, int size) {
            this.size = size;
            this.direction = dir;
        }

        public int getIconHeight() {
            return this.size;
        }

        public int getIconWidth() {
            return this.size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            boolean isEnabled = c.isEnabled();
            int j = 0;
            this.size = Math.max(this.size, 2);
            int mid = this.size / 2;
            g.translate(x, y);
            if (isEnabled) {
                g.setColor(UIManager.getColor("controlDkShadow"));
            } else {
                g.setColor(UIManager.getColor("controlShadow"));
            }
            switch (this.direction) {
                case 1: {
                    int i = 0;
                    while (i < this.size) {
                        g.drawLine(mid - i, i, mid + i, i);
                        ++i;
                    }
                    if (isEnabled) break;
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    g.drawLine(mid - i + 2, i, mid + i, i);
                    break;
                }
                case 5: {
                    int i;
                    if (!isEnabled) {
                        g.translate(1, 1);
                        g.setColor(UIManager.getColor("controlLtHighlight"));
                        i = this.size - 1;
                        while (i >= 0) {
                            g.drawLine(mid - i, j, mid + i, j);
                            ++j;
                            --i;
                        }
                        g.translate(-1, -1);
                        g.setColor(UIManager.getColor("controlShadow"));
                    }
                    j = 0;
                    i = this.size - 1;
                    while (i >= 0) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                        --i;
                    }
                    break;
                }
                case 7: {
                    int i = 0;
                    while (i < this.size) {
                        g.drawLine(i, mid - i, i, mid + i);
                        ++i;
                    }
                    if (isEnabled) break;
                    g.setColor(UIManager.getColor("controlLtHighlight"));
                    g.drawLine(i, mid - i + 2, i, mid + i);
                    break;
                }
                case 3: {
                    int i;
                    if (!isEnabled) {
                        g.translate(1, 1);
                        g.setColor(UIManager.getColor("controlLtHighlight"));
                        i = this.size - 1;
                        while (i >= 0) {
                            g.drawLine(j, mid - i, j, mid + i);
                            ++j;
                            --i;
                        }
                        g.translate(-1, -1);
                        g.setColor(UIManager.getColor("controlShadow"));
                    }
                    j = 0;
                    i = this.size - 1;
                    while (i >= 0) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                        --i;
                    }
                    break;
                }
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }
    }

    private class SortableColumnModelListener
    implements TableColumnModelListener {
        SortableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMoved(TableColumnModelEvent e) {
            int from = e.getFromIndex();
            int to = e.getToIndex();
            if (to == from) {
                return;
            }
            if (to == SortableHeaderRenderer.this.renderColumn) {
                SortableHeaderRenderer.this.renderColumn = from;
            } else if (from == SortableHeaderRenderer.this.renderColumn) {
                SortableHeaderRenderer.this.renderColumn = to;
            }
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

