/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing;

import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.I00acres.isql.swing.JTextComponentPopup;
import org.I00acres.isql.swing.action.JCheckBoxAction;
import org.I00acres.isql.swing.action.iSQLAction;
import org.I00acres.isql.swing.action.iSQLActionManager;
import org.I00acres.isql.util.iSQLConfig;
import org.I00acres.isql.util.iSQLUtilites;
import org.I00acres.lib.swing.UIMenuBar;

public class iSQLMenuBar
extends UIMenuBar {
    private JMenu ServiceMenu;
    private JMenuItem RowColDeleteAction;
    private JMenuItem ResultToggleAction;
    private JMenuItem LockAction;
    private JTextComponentPopup editmenu;

    public iSQLMenuBar(iSQLActionManager manager) {
        super(manager);
    }

    public synchronized void toggleDeleteColumnRowAction(Action action) {
        if (action == null) {
            return;
        }
        this.RowColDeleteAction.setAction(action);
        this.configureMenuItem(this.RowColDeleteAction, action);
    }

    public synchronized void toggleLockAction(Action action) {
        if (action == null) {
            return;
        }
        this.LockAction.setAction(action);
        this.configureMenuItem(this.LockAction, action);
    }

    public synchronized void toggleResultSetViewAction(Action action) {
        if (action == null) {
            return;
        }
        this.ResultToggleAction.setAction(action);
        this.configureMenuItem(this.ResultToggleAction, action);
    }

    protected synchronized void configureMenu() {
        this.add(this.createFileMenu(iSQLUtilites.getString("MENU_File"), '0'));
        if (this.editmenu == null) {
            this.editmenu = new JTextComponentPopup();
        }
        this.add(this.editmenu.toJMenu());
        this.add(this.createServiceMenu(iSQLUtilites.getString("MENU_Service"), '0'));
        this.add(this.createViewMenu(iSQLUtilites.getString("MENU_View"), '0'));
        this.add(this.createToolMenu(iSQLUtilites.getString("MENU_Tool"), '0'));
        JMenu t = this.createMenu(iSQLUtilites.getString("MENU_Help"), '0');
        this.addMenuItem(t, this.manager.getAction("29"));
        this.addMenuItem(t, this.manager.getAction("37"));
        this.add(t);
    }

    public void setTextComponent(JTextComponent comp) {
        this.editmenu.addJTextComponent(comp, false);
    }

    private JMenu createViewMenu(String name, char mnemonic) {
        JMenu vMenu = this.createMenu(name, mnemonic);
        JMenu tbMenu = new JMenu(iSQLUtilites.getString("MENU_Toolbars"));
        JMenu HistoryMenu = this.createMenu(iSQLUtilites.getString("MENU_Goto"), '0');
        JMenu ResultSetMenu = this.createMenu(iSQLUtilites.getString("MENU_Resultset"), '0');
        this.addMenuItem(HistoryMenu, this.manager.getAction("19"));
        this.addMenuItem(HistoryMenu, this.manager.getAction("20"));
        HistoryMenu.addSeparator();
        this.addMenuItem(HistoryMenu, this.manager.getAction("21"));
        this.addMenuItem(HistoryMenu, this.manager.getAction("22"));
        JCheckBoxAction fjca = new JCheckBoxAction(iSQLUtilites.getString("File_Toolbar"), "0");
        JCheckBoxAction hjca = new JCheckBoxAction(iSQLUtilites.getString("History_Toolbar"), "1");
        JCheckBoxAction rjca = new JCheckBoxAction(iSQLUtilites.getString("Resultset_Toolbar"), "2");
        this.addCheckBoxMenuItem(tbMenu, fjca, iSQLConfig.getInstance().getBooleanProperty("ToolBar.File.visible"));
        this.addCheckBoxMenuItem(tbMenu, hjca, iSQLConfig.getInstance().getBooleanProperty("ToolBar.History.visible"));
        this.addCheckBoxMenuItem(tbMenu, rjca, iSQLConfig.getInstance().getBooleanProperty("ToolBar.ResultSet.visible"));
        vMenu.add(tbMenu);
        vMenu.addSeparator();
        vMenu.add(ResultSetMenu);
        vMenu.addSeparator();
        vMenu.add(HistoryMenu);
        this.addMenuItem(vMenu, this.manager.getAction("18"));
        this.addMenuItem(vMenu, this.manager.getAction("8"));
        this.addMenuItem(vMenu, this.manager.getAction("30"));
        this.RowColDeleteAction = new JMenuItem(this.manager.getAction("24"));
        this.configureMenuItem(this.RowColDeleteAction, this.manager.getAction("24"));
        ResultSetMenu.add(this.RowColDeleteAction);
        this.ResultToggleAction = new JMenuItem(this.manager.getAction("33"));
        this.configureMenuItem(this.ResultToggleAction, this.manager.getAction("33"));
        ResultSetMenu.add(this.ResultToggleAction);
        this.LockAction = new JMenuItem(this.manager.getAction("35"));
        this.configureMenuItem(this.LockAction, this.manager.getAction("35"));
        ResultSetMenu.add(this.LockAction);
        this.addMenuItem(ResultSetMenu, this.manager.getAction("34"));
        return vMenu;
    }

    private JMenu createFileMenu(String name, char mnemonic) {
        JMenu menu = this.createMenu(name, mnemonic);
        JMenu tImpMenu = this.createMenu(iSQLUtilites.getString("MENU_Import"), '0');
        JMenu tExpMenu = this.createMenu(iSQLUtilites.getString("MENU_Export"), '0');
        this.addMenuItem(menu, this.manager.getAction("0"));
        this.addMenuItem(menu, this.manager.getAction("1"));
        this.addMenuItem(menu, this.manager.getAction("39"));
        menu.addSeparator();
        this.addMenuItem(menu, this.manager.getAction("2"));
        this.addMenuItem(menu, this.manager.getAction("6"));
        menu.addSeparator();
        menu.add(tImpMenu);
        this.addMenuItem(tImpMenu, this.manager.getAction("11"));
        this.addMenuItem(tImpMenu, this.manager.getAction("7"));
        menu.add(tExpMenu);
        this.addMenuItem(tExpMenu, this.manager.getAction("12"));
        menu.addSeparator();
        this.addMenuItem(menu, this.manager.getAction("9"));
        return menu;
    }

    private JMenu createToolMenu(String name, char mnemonic) {
        JMenu menu = this.createMenu(name, mnemonic);
        JMenu tSubMenu = new JMenu(iSQLUtilites.getString("Transaction"));
        this.addMenuItem(menu, this.manager.getAction("3"));
        this.addMenuItem(menu, this.manager.getAction("4"));
        this.addMenuItem(menu, this.manager.getAction("5"));
        this.addMenuItem(menu, this.manager.getAction("27"));
        menu.addSeparator();
        menu.add(tSubMenu);
        this.addMenuItem(tSubMenu, this.manager.getAction("14"));
        this.addMenuItem(tSubMenu, this.manager.getAction("16"));
        this.addMenuItem(tSubMenu, this.manager.getAction("15"));
        return menu;
    }

    public void refreshServiceMenu(Object[] services) {
        this.setServices(services, this.ServiceMenu);
    }

    protected void setServices(Object[] objs, JMenu menu) {
        if (menu == null) {
            menu = new JMenu();
        }
        menu.removeAll();
        int i = 0;
        while (i < objs.length) {
            this.addMenuService(menu, objs[i].toString());
            ++i;
        }
        menu.addSeparator();
        this.addMenuItem(menu, this.manager.getAction("31"));
    }

    public void addMenuService(JMenu menu, String Service) {
        iSQLAction action = new iSQLAction("SERVICE");
        action.putValue("Name", "iSQL-Service");
        action.putValue("Default", Service);
        action.putValue("ActionCommandKey", "23");
        if (menu.getMenuComponentCount() >= 0 && menu.getMenuComponentCount() <= 9) {
            char code = Character.forDigit(menu.getMenuComponentCount(), 10);
            KeyStroke ks = KeyStroke.getKeyStroke(code, 2, false);
            action.putValue("AcceleratorKey", ks);
        }
        this.addMenuItem(menu, (Action)action);
    }

    private JMenu createServiceMenu(String name, char mnemonic) {
        this.ServiceMenu = this.createMenu(name, mnemonic);
        this.setServices(iSQLConfig.getInstance().getAvailableServices(), this.ServiceMenu);
        return this.ServiceMenu;
    }

    protected void configureMenuItem(JMenuItem menuItem, Action action) {
        super.configureMenuItem(menuItem, action);
        if (action instanceof iSQLAction) {
            iSQLAction act = (iSQLAction)action;
            try {
                menuItem.setActionCommand((String)act.getValue("Default"));
            }
            catch (Exception exception) {}
            try {
                menuItem.setText((String)act.getValue("Default"));
            }
            catch (Exception exception) {}
            try {
                String s = (String)action.getValue("ICON_NAME");
                menuItem.setIcon(this.manager.getSmallIcon(s, "png"));
            }
            catch (Exception exception) {}
        }
    }
}

