/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.isql.swing.table;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.sql.DriverPropertyInfo;
import java.util.EventObject;
import java.util.Properties;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.I00acres.isql.util.iSQLUtilites;

public class DriverPropertyTableModel
extends DefaultTableModel {
    private static final String[] mColumnNames = new String[]{iSQLUtilites.getString("Driver_Property_Required"), iSQLUtilites.getString("Driver_Property_Name"), iSQLUtilites.getString("Property_Choice_Value")};
    protected DriverPropertyInfo[] data;
    protected boolean tooltips = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public DriverPropertyTableModel() {
        this.setColumnIdentifiers(mColumnNames);
    }

    public DriverPropertyTableModel(DriverPropertyInfo[] properties) {
        this();
        this.setData(properties);
    }

    public DriverPropertyInfo getPropertyInfo(int row) {
        return this.data[row];
    }

    public void setData(DriverPropertyInfo[] properties) {
        this.data = properties;
        this.dataVector.clear();
        if (properties != null) {
            int i = 0;
            while (i < properties.length) {
                this.addRow(new Object[]{new Boolean(properties[i].required), properties[i].name, properties[i].choices});
                ++i;
            }
        }
    }

    public void setToolTipsEnabled(boolean f) {
        this.tooltips = f;
    }

    public void setProperties(Properties props) {
        int i = 0;
        while (i < this.getRowCount()) {
            String s = this.getValueAt(i, 1).toString();
            this.setValueAt(props.getProperty(s, ""), i, 2);
            ++i;
        }
    }

    public synchronized Properties getTableAsProperties() {
        Properties props = new Properties();
        int r = 0;
        while (r < this.getRowCount()) {
            try {
                if (this.getValueAt(r, 2).toString().trim().length() > 0) {
                    props.setProperty(this.getValueAt(r, 1).toString(), this.getValueAt(r, 2).toString());
                }
            }
            catch (NullPointerException nullPointerException) {}
            ++r;
        }
        return props;
    }

    public DefaultCellEditor getChoiceEditor() {
        return new ChoiceRenderer();
    }

    public boolean hasRequiredData() {
        try {
            int r = 0;
            while (r < this.getRowCount()) {
                block7: {
                    try {
                        boolean f = (Boolean)this.getValueAt(r, 0);
                        String s = (String)this.getValueAt(r, 2);
                        if (!f) break block7;
                        if (s != null) {
                            if (s.trim().length() < 1) {
                                return false;
                            }
                            break block7;
                        }
                        return false;
                    }
                    catch (NullPointerException nullPointerException) {}
                }
                ++r;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public Class getColumnClass(int idx) {
        switch (idx) {
            case 0: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.Boolean");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            default: {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return clazz;
            }
            case 2: 
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("[Ljava.lang.String;");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    public boolean isCellEditable(int row, int col) {
        return col == 2;
    }

    private class ChoiceRenderer
    extends DefaultCellEditor {
        public ChoiceRenderer() {
            super(new JComboBox());
        }

        private void createChoiceDelegate(JComboBox comboBox) {
            this.delegate = new DefaultCellEditor.EditorDelegate(this, comboBox){
                private final /* synthetic */ JComboBox val$comboBox;
                {
                    this.val$comboBox = jComboBox;
                }

                public void setValue(Object value) {
                    this.val$comboBox.setSelectedItem(value);
                }

                public Object getCellEditorValue() {
                    return this.val$comboBox.getSelectedItem();
                }

                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }
            };
        }

        private void createSingleDelegate(JTextField textField) {
            this.delegate = new DefaultCellEditor.EditorDelegate(this, textField){
                private final /* synthetic */ JTextField val$textField;
                {
                    this.val$textField = jTextField;
                }

                public void setValue(Object value) {
                    if (value != null) {
                        this.val$textField.setText(value.toString());
                    } else {
                        this.val$textField.setText("");
                    }
                }

                public Object getCellEditorValue() {
                    return this.val$textField.getText();
                }

                public boolean shouldSelectCell(EventObject anEvent) {
                    if (anEvent instanceof MouseEvent) {
                        MouseEvent e = (MouseEvent)anEvent;
                        return e.getID() != 506;
                    }
                    return true;
                }
            };
        }

        public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int col) {
            try {
                boolean choiceFlag = DriverPropertyTableModel.this.data[row].choices.length >= 0;
                JComboBox<String> component = null;
                if (choiceFlag) {
                    component = new JComboBox<String>(DriverPropertyTableModel.this.data[row].choices);
                    if (DriverPropertyTableModel.this.tooltips) {
                        component.setToolTipText(DriverPropertyTableModel.this.data[row].description);
                    }
                    component.addActionListener(this.delegate);
                    component.setEditable(false);
                    component.setSelectedItem(obj);
                    component.setMaximumRowCount(3);
                    this.createChoiceDelegate(component);
                    this.editorComponent = component;
                }
            }
            catch (Exception exception) {
                JTextField txt = new JTextField(obj == null ? DriverPropertyTableModel.this.data[row].value : obj.toString());
                this.createSingleDelegate(txt);
                txt.addActionListener(this.delegate);
                if (DriverPropertyTableModel.this.tooltips) {
                    txt.setToolTipText(DriverPropertyTableModel.this.data[row].description);
                }
                this.editorComponent = txt;
            }
            return super.getTableCellEditorComponent(table, obj, isSelected, row, col);
        }
    }
}

