/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.sql;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;
import org.I00acres.lib.sql.DatabaseConnection;

public final class ResultSetUtilities {
    private static final String RESULT_RESERVED_CHARS = "srctfzwCST";

    public static Vector getSingleColumn(ResultSet rs, int ColumnId) throws SQLException {
        if (rs == null) {
            return null;
        }
        Vector<Object> returns = new Vector<Object>();
        while (rs.next()) {
            returns.addElement(rs.getObject(ColumnId));
        }
        return returns;
    }

    public static Object[] getSingleColumn(ResultSet rs, String ColumnId) throws SQLException {
        if (rs == null) {
            return null;
        }
        return ResultSetUtilities.getSingleColumn(rs, rs.findColumn(ColumnId)).toArray();
    }

    public static Vector getSingleRow(ResultSet rs, int RowNumber) throws SQLException {
        if (rs == null) {
            return null;
        }
        Vector<Object> returns = new Vector<Object>();
        int rownum = 1;
        while (rs.next()) {
            if (rownum++ != RowNumber) continue;
            int colcount = rs.getMetaData().getColumnCount();
            int i = 1;
            while (i <= colcount) {
                returns.addElement(rs.getObject(i));
                ++i;
            }
        }
        return returns;
    }

    public static void addWarning(String reason, String state, ResultSet rs) {
        try {
            rs.getWarnings().setNextWarning(new SQLWarning(reason, "ISQLV-" + state, 74615));
        }
        catch (Throwable throwable) {}
    }

    public static String getResultString(String str, ResultSet rs, int rowCount, DatabaseConnection dbc) {
        StringBuffer buff = new StringBuffer(str);
        String s = buff.toString();
        int end = 0;
        int idx0 = 0;
        int idx1 = 0;
        end = s.lastIndexOf(37);
        if (end >= 0 && (rs != null || dbc != null)) {
            while (idx0 < end) {
                idx0 = s.indexOf(37, idx1);
                if ((idx1 = idx0 + 1) >= s.length()) {
                    idx1 = s.length() - 1;
                }
                if (RESULT_RESERVED_CHARS.indexOf(s.charAt(idx1)) < 0) continue;
                try {
                    char x = '\u0000';
                    x = s.charAt(idx0 + 1);
                    String y = "";
                    switch (x) {
                        case 'C': {
                            try {
                                y = rs.getMetaData().getCatalogName(1);
                            }
                            catch (Throwable t) {
                                if (DatabaseConnection.getVerboseOn()) {
                                    ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("Catalog_Not_Supported"), "RS", rs);
                                }
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = "null";
                            }
                            break;
                        }
                        case 'T': {
                            try {
                                y = rs.getMetaData().getTableName(1);
                            }
                            catch (Throwable t) {
                                if (DatabaseConnection.getVerboseOn()) {
                                    ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("TableName_Not_Supported"), "RS", rs);
                                }
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = "null";
                            }
                            break;
                        }
                        case 'S': {
                            try {
                                y = rs.getMetaData().getSchemaName(1);
                            }
                            catch (Throwable t) {
                                ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("Schema_Not_Supported"), "RS", rs);
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = "null";
                            }
                            break;
                        }
                        case 's': {
                            y = dbc.getConnectionName();
                            break;
                        }
                        case 'r': {
                            y = Integer.toString(rowCount);
                            break;
                        }
                        case 'c': {
                            try {
                                y = Integer.toString(rs.getMetaData().getColumnCount());
                            }
                            catch (Throwable t) {
                                if (DatabaseConnection.getVerboseOn()) {
                                    ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("ColumnCount_Not_Supported"), "RS", rs);
                                }
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = Integer.toString(-1);
                            }
                            break;
                        }
                        case 't': {
                            try {
                                y = Integer.toString(rs.getType());
                            }
                            catch (Throwable t) {
                                if (DatabaseConnection.getVerboseOn()) {
                                    ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("ResultSetType_Not_Supported"), "RS", rs);
                                }
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = Integer.toString(1003);
                            }
                            break;
                        }
                        case 'f': {
                            try {
                                y = Integer.toString(rs.getFetchDirection());
                            }
                            catch (Throwable t) {
                                if (DatabaseConnection.getVerboseOn()) {
                                    ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("FetchDirection_Not_Supported"), "RS", rs);
                                }
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = Integer.toString(1002);
                            }
                            break;
                        }
                        case 'x': {
                            try {
                                y = rs.getCursorName();
                            }
                            catch (Throwable t) {
                                if (DatabaseConnection.getVerboseOn()) {
                                    ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("Cursor_Not_Supported"), "RS", rs);
                                }
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = "null";
                            }
                        }
                        case 'z': {
                            try {
                                y = Integer.toString(rs.getFetchSize());
                            }
                            catch (Throwable t) {
                                if (DatabaseConnection.getVerboseOn()) {
                                    ResultSetUtilities.addWarning(DatabaseConnection.resStrings.getString("FetchSize_Not_Supported"), "RS", rs);
                                }
                                if (DatabaseConnection.getDebugOn()) {
                                    t.printStackTrace();
                                }
                                y = Integer.toString(-1);
                            }
                            break;
                        }
                    }
                    if (idx1 + 1 >= buff.length()) {
                        idx1 = buff.length() - 1;
                    }
                    if (y == null) {
                        buff.replace(idx0, idx1 + 1, "null");
                    } else {
                        buff.replace(idx0, idx1 + 1, y);
                    }
                    s = buff.toString();
                    end = s.lastIndexOf(37);
                }
                catch (NumberFormatException numberFormatException) {
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    try {
                        buff.replace(idx0, idx1, "");
                        s = buff.toString();
                        end = s.lastIndexOf(37);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return buff.toString().trim();
    }
}

