/*
 * Decompiled with CFR 0.152.
 */
package org.I00acres.lib.util;

public abstract class StringUtilities {
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeXML(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    outBuffer.append(' ');
                    break;
                }
                case '\"': {
                    outBuffer.append("&quot;");
                    break;
                }
                case '>': {
                    outBuffer.append("&gt;");
                    break;
                }
                case '<': {
                    outBuffer.append("&lt;");
                    break;
                }
                case '\\': {
                    outBuffer.append('\\');
                    break;
                }
                case '\t': {
                    outBuffer.append(' ');
                    break;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    break;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    break;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    break;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('&');
                        outBuffer.append('#');
                        outBuffer.append(StringUtilities.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar & 0xF));
                        break;
                    }
                    outBuffer.append(aChar);
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static String encode(String theString, boolean asHTML, boolean escapeSpaces) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (asHTML) {
                        outBuffer.append("&nbsp;");
                        break;
                    }
                    if (escapeSpaces) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    break;
                }
                case '\\': {
                    outBuffer.append('\\');
                    break;
                }
                case '\t': {
                    if (asHTML) {
                        outBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                        break;
                    }
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    break;
                }
                case '\"': {
                    if (asHTML) {
                        outBuffer.append("&quot;");
                        break;
                    }
                    outBuffer.append('\"');
                    break;
                }
                case '>': {
                    if (asHTML) {
                        outBuffer.append("&gt;");
                        break;
                    }
                    outBuffer.append('>');
                    break;
                }
                case '<': {
                    if (asHTML) {
                        outBuffer.append("&lt;");
                        break;
                    }
                    outBuffer.append('<');
                    break;
                }
                case '\n': {
                    if (asHTML) {
                        outBuffer.append("<BR>");
                        break;
                    }
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    break;
                }
                case '\r': {
                    if (asHTML) {
                        outBuffer.append("<BR>");
                        break;
                    }
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    break;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    break;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        if (asHTML) {
                            outBuffer.append('&');
                            outBuffer.append('#');
                        } else {
                            outBuffer.append('\\');
                            outBuffer.append('u');
                        }
                        outBuffer.append(StringUtilities.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar & 0xF));
                        break;
                    }
                    outBuffer.append(aChar);
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static String createSwingHTML(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer("<HTML>");
        int x = 0;
        while (x < len) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    outBuffer.append("&nbsp;");
                    break;
                }
                case '\\': {
                    outBuffer.append('\\');
                    break;
                }
                case '\t': {
                    outBuffer.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                    break;
                }
                case '\n': 
                case '\r': {
                    outBuffer.append("<P>");
                    break;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    break;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('&');
                        outBuffer.append('#');
                        outBuffer.append(StringUtilities.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(StringUtilities.toHex(aChar & 0xF));
                        break;
                    }
                    outBuffer.append(aChar);
                }
            }
            ++x;
        }
        return outBuffer.toString();
    }

    public static String decode(String theString) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = theString.charAt(x++)) == 92) {
                if ((aChar = theString.charAt(x++)) == 117) {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = theString.charAt(x++);
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                outBuffer.append((char)aChar);
                continue;
            }
            outBuffer.append((char)aChar);
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }
}

