/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.PicoDbApi;
import IT.picosoft.jdbc.PicoPseudoCol;
import IT.picosoft.jdbc.PicoResultSet;
import IT.picosoft.jdbc.PicoSQLWarning;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;

public class PicoResultSetMetaData
implements ResultSetMetaData {
    protected PicoDbApi odbcApi;
    protected PicoResultSet resultSet;
    private Hashtable columnNameMap;

    public PicoResultSetMetaData(PicoDbApi picoDbApi, PicoResultSet picoResultSet) {
        this.odbcApi = picoDbApi;
        this.resultSet = picoResultSet;
        this.columnNameMap = new Hashtable();
        this.columnNameMap.put("TABLE_QUALIFIER", "TABLE_CAT");
        this.columnNameMap.put("TABLE_OWNER", "TABLE_SCHEM");
        this.columnNameMap.put("PRECISION", "COLUMN_SIZE");
        this.columnNameMap.put("LENGTH", "BUFFER_LENGTH");
        this.columnNameMap.put("SCALE", "DECIMAL_DIGITS");
        this.columnNameMap.put("RADIX", "NUM_PREC_RADIX");
    }

    public String getCatalogName(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getCatalogName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 17);
    }

    protected int getColAttribute(int n, int n2) throws SQLException {
        return this.resultSet.getColAttribute(n, (short)n2);
    }

    protected boolean getColAttributeBoolean(int n, int n2) throws SQLException {
        int n3 = this.getColAttribute(n, n2);
        boolean bl = false;
        if (n3 == 1) {
            bl = true;
        }
        return bl;
    }

    protected String getColAttributeString(int n, int n2) throws SQLException {
        String string = "";
        this.resultSet.clearWarnings();
        try {
            string = this.odbcApi.SQLColAttributesString(this.resultSet.getHSTMT(), n, (short)n2);
        }
        catch (PicoSQLWarning picoSQLWarning) {
            string = (String)picoSQLWarning.value;
            this.resultSet.setWarning(PicoDbApi.convertWarning(picoSQLWarning));
        }
        return string.trim();
    }

    public String getColumnClassName(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("PicoResultSetMetaData.getColumnClassName(int col)");
        }
        String string = new String().getClass().getName();
        int n2 = this.getColumnType(n);
        switch (n2) {
            case 2: 
            case 3: {
                string = new BigDecimal(0.0).getClass().getName();
                break;
            }
            case -7: {
                string = new Boolean(false).getClass().getName();
                break;
            }
            case -6: {
                string = new Byte("0").getClass().getName();
                break;
            }
            case 5: {
                string = new Short("0").getClass().getName();
                break;
            }
            case 4: {
                string = new Integer(0).getClass().getName();
                break;
            }
            case -5: {
                string = new Long(0L).getClass().getName();
                break;
            }
            case 7: {
                string = new Float(0.0f).getClass().getName();
                break;
            }
            case 6: 
            case 8: {
                string = new Double(0.0).getClass().getName();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] byArray = new byte[]{};
                string = byArray.getClass().getName();
                break;
            }
            case 91: {
                string = new Date(0L).getClass().getName();
                break;
            }
            case 92: {
                string = new Time(0L).getClass().getName();
                break;
            }
            case 93: {
                string = new Timestamp(0L).getClass().getName();
            }
        }
        return string;
    }

    public int getColumnCount() throws SQLException {
        return this.resultSet.getColumnCount();
    }

    public int getColumnDisplaySize(int n) throws SQLException {
        PicoPseudoCol picoPseudoCol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnDisplaySize (" + n + ")");
        }
        int n2 = (picoPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? picoPseudoCol.getColumnDisplaySize() : this.getColAttribute(n, 6);
        return n2;
    }

    public String getColumnLabel(int n) throws SQLException {
        PicoPseudoCol picoPseudoCol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnLabel (" + n + ")");
        }
        String string = (picoPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? picoPseudoCol.getColumnLabel() : this.getColAttributeString(n, 18);
        return string;
    }

    public String getColumnName(int n) throws SQLException {
        String string;
        PicoPseudoCol picoPseudoCol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnName (" + n + ")");
        }
        if ((picoPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null) {
            string = picoPseudoCol.getColumnLabel();
        } else {
            string = this.getColAttributeString(n, 1);
            String string2 = (String)this.columnNameMap.get(string);
            if (string2 != null) {
                string = string2;
            }
        }
        return string;
    }

    public int getColumnType(int n) throws SQLException {
        PicoPseudoCol picoPseudoCol = this.resultSet.getPseudoCol(n);
        int n2 = picoPseudoCol != null ? picoPseudoCol.getColumnType() - 1 : this.resultSet.getColumnType(n);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnType (" + n + ")=" + n2);
        }
        return n2;
    }

    public String getColumnTypeName(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getColumnTypeName (" + n + ")");
        }
        String string = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? "" : this.getColAttributeString(n, 14);
        return string;
    }

    public int getPrecision(int n) throws SQLException {
        PicoPseudoCol picoPseudoCol;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getPrecision (" + n + ")");
        }
        int n2 = (picoPseudoCol = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n))) != null ? picoPseudoCol.getColumnDisplaySize() - 1 : this.getColAttribute(n, 4);
        return n2;
    }

    public int getScale(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getScale (" + n + ")");
        }
        return this.resultSet.getScale(n);
    }

    public String getSchemaName(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getSchemaName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 16);
    }

    public String getTableName(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.getTableName (" + n + ")");
        }
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            n = 1;
        }
        return this.getColAttributeString(n, 15);
    }

    public boolean isAutoIncrement(int n) throws SQLException {
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 11);
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isAutoIncrement (" + n + ")=" + bl);
        }
        return bl;
    }

    public boolean isCaseSensitive(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isCaseSensitive (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 12);
        return bl;
    }

    public boolean isCurrency(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isCurrency (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : this.getColAttributeBoolean(n, 9);
        return bl;
    }

    public boolean isDefinitelyWritable(int n) throws SQLException {
        int n2;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isDefinitelyWritable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 1;
        return bl;
    }

    public int isNullable(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isNullable (" + n + ")");
        }
        int n2 = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? 0 : this.getColAttribute(n, 7);
        return n2;
    }

    public boolean isReadOnly(int n) throws SQLException {
        boolean bl;
        if (this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null) {
            bl = true;
        } else {
            int n2 = this.getColAttribute(n, 10);
            boolean bl2 = bl = n2 == 0;
        }
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isReadOnly (" + n + ")=" + bl);
        }
        return bl;
    }

    public boolean isSearchable(int n) throws SQLException {
        int n2;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isSearchable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 13)) != 0;
        return bl;
    }

    public boolean isSigned(int n) throws SQLException {
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isSigned (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : !this.getColAttributeBoolean(n, 8);
        return bl;
    }

    public boolean isWritable(int n) throws SQLException {
        int n2;
        if (DriverManager.getLogWriter() != null) {
            DriverManager.println("*ResultSetMetaData.isWritable (" + n + ")");
        }
        boolean bl = this.resultSet.getPseudoCol(n = this.resultSet.mapColumn(n)) != null ? false : (n2 = this.getColAttribute(n, 10)) == 2;
        return bl;
    }
}

