/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
static char rcsid[] = "$Id$";
# ifdef WIN32
# include <windows.h>
# include <sql.h>
# include <sqlext.h>
# else
# include "sqltype.h"
#endif
#ifdef __cplusplus
extern "C" {
# include "corba.h"
}
#else
# include "corba.h"
#endif

extern CORBA_TCKindDesc Timestamp_struct;
extern CORBA_TCKindDesc Time_struct;
extern CORBA_TCKindDesc Date_struct;

int
SqlToCDefault(int sqlType)
{
   switch (sqlType) {
   default:
   case SQL_CHAR:
   case SQL_VARCHAR:
   case SQL_NUMERIC:
   case SQL_DECIMAL:
      return SQL_C_CHAR;
   case SQL_REAL:
      return SQL_C_FLOAT;
   case SQL_FLOAT:
   case SQL_DOUBLE:
      return SQL_C_DOUBLE;
   case SQL_INTEGER:
      return SQL_C_LONG;
   case SQL_SMALLINT:
      return SQL_C_SHORT;
   case SQL_TIMESTAMP:
      return SQL_C_TIMESTAMP;
   case SQL_DATE:
      return SQL_C_DATE;
   case SQL_TIME:
      return SQL_C_TIME;
   case SQL_LONGVARBINARY:
   case SQL_LONGVARCHAR:
      return SQL_C_BINARY;
   }
}

CORBA_TCKindDesc *
anyType (HSTMT hstmt, unsigned short icol, short *fcType)
{
   CORBA_TCKindDesc *Return;
   if (*fcType == SQL_C_DEFAULT) {
      long pfDesc;
      if (SQLColAttributes(hstmt, icol,
                           SQL_COLUMN_TYPE, 0, 0, 0, &pfDesc) == SQL_SUCCESS)
         *fcType =  SqlToCDefault (pfDesc);
   }
   switch (*fcType) {
   case SQL_C_BIT:
   case SQL_C_STINYINT:
   case SQL_C_UTINYINT:
      Return = &TCD_octet;
      break;
   case SQL_C_SHORT:
   case SQL_C_SSHORT:
   case SQL_C_USHORT:
      Return = &TCD_short;
      break;
   case SQL_C_LONG:
   case SQL_C_SLONG:
   case SQL_C_ULONG:
      Return = &TCD_long;
      break;
   case SQL_C_FLOAT:
      Return = &TCD_float;
      break;
   case SQL_C_DOUBLE:
      Return = &TCD_double;
      break;
   case SQL_C_BINARY:
      Return = &TCD_Principal;
      break;
   case SQL_C_TIMESTAMP:
      Return = &Timestamp_struct;
      break;
   case SQL_C_TIME:
      Return = &Time_struct;
      break;
   case SQL_C_DATE:
      Return = &Date_struct;
      break;
   case SQL_C_CHAR:
   default:
      Return = &TCD_string;
      break;
   }
   return Return;
}

