/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoSQL - common include files

 Copyright (C) Picosoft s.r.l. 1994-2003

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
# ifndef picocall_h
# define picocall_h "$Id$"
# ifdef WIN32
# include <windows.h>
# include <sql.h>
# include <sqlext.h>
# else
# include "odbcsql.h"
# endif

typedef struct tEnv {
   HSTMT hstmt;
   char *userName;
   char *dbName;
   char *procName;
   char exceptionMsg[256];
} Env;

typedef struct tArgument {
   short ioType;
   short cType;
   short sqlType;
   unsigned long columnSize;
   short decimalDigits;
   void *valuePtr;
   long valueLen;
   long *strLenOrIndPtr;
} Argument;

struct CallTable {
   char *dbName;                                      /* database */
   char *procName;                                    /* call name */
   int (*call)(Env *env, Argument args[], int nArgs,
                                       Argument *rc); /* pointer to routine */
   short numArgs;                                     /* number of arguments */
   short return_type;                                 /* return type */
};

# endif
