/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
package IT.picosoft.jdbc;

import java.sql.Types;


public class PicoPseudoCol /* extends PicoObject */ {

    protected String colLabel;
    protected int colType;
    protected int colLength;
    protected int colDisplaySize;

    public PicoPseudoCol(String s, int i, int j) {
        colLabel = s;
        colType = i;
        colLength = j;
        colDisplaySize = colLength;
        switch(colType) {
        case -4: 
        case -3: 
        case -2: 
            colDisplaySize *= 2;
            break;

        case 91: // '['
            colDisplaySize = 10;
            break;

        case 92: // '\\'
            colDisplaySize = 8;
            break;

        case 93: // ']'
            colDisplaySize = 29;
            break;

        case 2: // '\002'
        case 3: // '\003'
            colDisplaySize += 2;
            break;

        case -7: 
            colDisplaySize = 1;
            break;

        case -6: 
            colDisplaySize = 4;
            break;

        case 5: // '\005'
            colDisplaySize = 6;
            break;

        case 4: // '\004'
            colDisplaySize = 11;
            break;

        case -5: 
            colDisplaySize = 20;
            break;

        case 7: // '\007'
            colDisplaySize = 13;
            break;

        case 6: // '\006'
        case 8: // '\b'
            colDisplaySize = 22;
            break;

        }
    }

    public int getColumnDisplaySize() {
        return colDisplaySize;
    }

    public String getColumnLabel() {
        return colLabel;
    }

    public int getColumnLength() {
        return colLength;
    }

    public int getColumnType() {
        return colType;
    }
}
