/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
package IT.picosoft.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.*;
import java.util.*;

public class PicoResultSet /* extends PicoDbObject */
   implements ResultSet
{
   protected PicoDbApi odbcApi;
   protected PicoConnection con;
   private OdbcStatement hStmt;
   protected SQLWarning lastWarning;
   protected PicoBoundCol boundCols[];
   protected int numberOfCols;
   protected int numResultCols;
   protected int firstPseudoCol;
   protected int lastPseudoCol;
   protected PicoPseudoCol pseudoCols[];
   protected int colMappings[];
   protected ResultSetMetaData rsmd;
   private Hashtable colNameToNum;
   private Hashtable colNumToName;
   private boolean lastColumnNull;
   private boolean closed;
   private int sqlTypeColumn;
   private boolean freed;
   protected PicoStatement ownerStatement;
   protected java.lang.Object data[];

   private String rmDot (String num) {
      int i;
      if ((i = num.indexOf ('.')) >= 0)
         num = num.substring(0, i);
      return num;
   }

   private java.lang.Object getData (int nCol, Class c) throws SQLException {
      java.lang.Object Return = null;
      if (data == null) {
         int allCol;
         if (firstPseudoCol > 0)
            allCol = firstPseudoCol - 1;
         else
            allCol = getColumnCount();
         data = odbcApi.SQLGetAllData (getHSTMT(), boundCols);
      }
      if (nCol > data.length) {
         Return.toString();
         if (c == Double.class)
            Return = odbcApi.SQLGetDataDouble(getHSTMT(), nCol);
         else if (c == Float.class)
            Return = odbcApi.SQLGetDataFloat(getHSTMT(), nCol);
         else if (c == Integer.class)
            Return = odbcApi.SQLGetDataInteger(getHSTMT(), nCol);
         else if (c == Timestamp.class)
            Return = odbcApi.SQLGetDataTimestamp(getHSTMT(), nCol);
         else if (c == byte[].class)
            Return = odbcApi.SQLGetDataBytes(getHSTMT(), nCol);
         else
            Return = odbcApi.SQLGetDataString(getHSTMT(), nCol, 256, false);
      } else {
         Return = data[nCol - 1];
         if (Return != null) {
            if (c == String.class) {
               if (!(Return instanceof String))
                  Return = Return.toString();
            } else if (c == Double.class) {
               if (!(Return instanceof Double))
                  Return = new Double(Return.toString());
            } else if (c == Float.class) {
               if (!(Return instanceof Float))
                  Return = new Float(Return.toString());
            } else if (c == Integer.class) {
               if (!(Return instanceof Integer))
                  Return = new Integer(rmDot(Return.toString()));
            } else if (c == Timestamp.class) {
               if (!(Return instanceof Timestamp))
                  Return = Timestamp.valueOf(Return.toString());
            } else if (c == java.sql.Date.class) {
               if (!(Return instanceof java.sql.Date))
                  Return = java.sql.Date.valueOf(Return.toString());
            } else if (c == Time.class) {
               if (!(Return instanceof Time))
                  Return = Time.valueOf(Return.toString());
            }
         }
      }
      return Return;
   }

   protected OdbcStatement getHSTMT() {
      if (ownerStatement != null)
         return ownerStatement.getHSTMT();
      else
         return hStmt;
   }

   private PicoResultSet (PicoDbApi api, PicoConnection con)
                                             throws SQLException {
      odbcApi = api;
      this.con = con;
      hStmt = null;
      lastWarning = null;
      numResultCols = -1;
      lastColumnNull = false;
      ownerStatement = null;
   }

   public PicoResultSet (PicoDbApi api, OdbcStatement hStmt, PicoConnection con)
                                  throws SQLException {
      this(api, con);
      this.hStmt = hStmt;
      if(DriverManager.getLogWriter() != null)
         DriverManager.println("ResultSet.initialize " + this +
                               ",hStmt=" + hStmt);

      numberOfCols = getColumnCount();
      boundCols = new PicoBoundCol[numberOfCols];
      for(int k = 0; k < numberOfCols; k++)
         boundCols[k] = new PicoBoundCol();
   }

   public PicoResultSet (PicoDbApi api, PicoStatement statement)
                                  throws SQLException {
      this(api, statement.myConnection);
      ownerStatement = statement;
      if(DriverManager.getLogWriter() != null)
         DriverManager.println("ResultSet.initialize " + this +
                               ",hStmt=" + getHSTMT() + ",stmt=" + ownerStatement);

      numberOfCols = getColumnCount();
      boundCols = new PicoBoundCol[numberOfCols];
      for(int k = 0; k < numberOfCols; k++)
         boundCols[k] = new PicoBoundCol();
   }

   public boolean absolute(int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.absolute(int i)");
      throw new UnsupportedOperationException();
   }

   public void afterLast() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.afterLast()");
      throw new UnsupportedOperationException();
   }

   public void beforeFirst() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.beforeFirst()");
      throw new UnsupportedOperationException();
   }

   public void cancelRowUpdates() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.cancelRowUpdates()");
      throw new UnsupportedOperationException();
   }

   public void clearWarnings() throws SQLException {
      lastWarning = null;
   }

   public synchronized void close() throws SQLException {
      if(DriverManager.getLogWriter() != null)
         DriverManager.println("*close ResultSet=" + getHSTMT() + 
                               ", freed=" + freed+
                               ", stmt=" + ownerStatement+
                               ", this=" + this);
      if (!closed && !con.isClosed() && odbcApi != null) {
         closeInputStreams();
         clearWarnings();
         lastColumnNull = false;
         if(ownerStatement != null) {
            if(!freed) {
               getHSTMT().close();
               freed = true;
            }
         } else {
            getHSTMT().drop();
         }
      }
      closed = true;
   }

   protected void closeInputStreams() {
      for(int i = 0; i < numberOfCols; i++)
         boundCols[i].closeInputStream();

   }

   public void deleteRow() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.deleteRow()");
      throw new UnsupportedOperationException();
   }

   protected void finalize() {
      if(DriverManager.getLogWriter() != null)
         DriverManager.println("ResultSet.finalize " + this);
      try {
         close();
      } catch(SQLException _ex) { }
   }

   public synchronized int findColumn(String s) throws SQLException {
      if(rsmd == null) {
         rsmd = getMetaData();
         colNameToNum = new Hashtable();
         colNumToName = new Hashtable();
      }
      Integer integer = (Integer)colNameToNum.get(s);
      if(integer == null) {
         for(int i = 1; i <= rsmd.getColumnCount(); i++) {
            String s1 = (String)colNumToName.get(new Integer(i));
            if(s1 == null) {
               s1 = rsmd.getColumnName(i);
               colNameToNum.put(s1, new Integer(i));
               colNumToName.put(new Integer(i), s1);
            }
            if(s1.equalsIgnoreCase(s))
               return i;
         }

         throw new SQLException("Column not found", "S0022");
      } else {
         return integer.intValue();
      }
   }

   public boolean first() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.first()");
      throw new UnsupportedOperationException();
   }

   public Array getArray(int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getArray(int i");
      throw new UnsupportedOperationException();
   }

   public Array getArray(String s) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getArray(String s)");
      throw new UnsupportedOperationException();
   }

   public void updateArray(int columnIndex, Array x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateArray(int columnIndex, Array x)");
      throw new UnsupportedOperationException();
   }

   public void updateArray(String columnName, Array x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateArray(String columnName, Array x)");
      throw new UnsupportedOperationException();
   }

   public InputStream getAsciiStream(int i) throws SQLException {
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      int j = getColumnType(i);
      byte byte0 = -2;
      switch(j) {
      case -1: 
      case 1: // '\001'
      case 12: // '\f'
         byte0 = 1;
         break;
      }
      PicoInputStream jdbcodbcinputstream = new PicoInputStream(odbcApi, getHSTMT(), i, (short)1, byte0, ownerStatement);
      setInputStream(i, jdbcodbcinputstream);
      return jdbcodbcinputstream;
   }

   public InputStream getAsciiStream(String s) throws SQLException {
      return getAsciiStream(findColumn(s));
   }

   public BigDecimal getBigDecimal(int i) throws SQLException {
      BigDecimal Return = null;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null) {
         String s = getDataString (i,
                               PicoLimits.DEFAULT_BUFFER_LENGTH, true);
         if(s != null) {
            Return = new BigDecimal(s.trim());
         }
      } else {
         lastColumnNull = true;
      }
      return Return;
   }

   public BigDecimal getBigDecimal(int i, int j) throws SQLException {
      BigDecimal Return = null;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null) {
         String s = getDataString (i,
                               PicoLimits.DEFAULT_BUFFER_LENGTH, true);
         if(s != null) {
            Return = new BigDecimal(s.trim());
            Return = Return.setScale(j, BigDecimal.ROUND_HALF_UP);
         }
      } else {
         lastColumnNull = true;
      }
      return Return;
   }

   public BigDecimal getBigDecimal(String s) throws SQLException {
      return getBigDecimal(findColumn(s));
   }

   public BigDecimal getBigDecimal(String s, int i) throws SQLException {
      return getBigDecimal(findColumn(s), i);
   }

   public InputStream getBinaryStream(int i) throws SQLException {
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      int j = getColumnType(i);
      byte byte0 = -2;
      switch(j) {
      case -1: 
      case 1: // '\001'
      case 12: // '\f'
         byte0 = 1;
         break;

      }
      PicoInputStream jdbcodbcinputstream = new PicoInputStream(odbcApi, getHSTMT(), i, (short)3, byte0, ownerStatement);
      setInputStream(i, jdbcodbcinputstream);
      return jdbcodbcinputstream;
   }

   public InputStream getBinaryStream(String s) throws SQLException {
      return getBinaryStream(findColumn(s));
   }

   public Blob getBlob(int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getBlob(int i)");
      throw new UnsupportedOperationException();
   }

   public Blob getBlob(String s) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getBlob(String s)");
      throw new UnsupportedOperationException();
   }

   public void updateBlob(int columnIndex, Blob x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBlob(int columnIndex, Blob x)");
      throw new UnsupportedOperationException();
   }

   public void updateBlob(String columnName, Blob x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBlob(String columnName, Blob x)");
      throw new UnsupportedOperationException();
   }

   public boolean getBoolean(int i) throws SQLException {
      boolean flag = false;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null)
         flag = getInt(i) != 0;
      else
         lastColumnNull = true;
      return flag;
   }

   public boolean getBoolean(String s) throws SQLException {
      return getBoolean(findColumn(s));
   }

   public byte getByte(int i) throws SQLException {
      byte byte0 = 0;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null)
         byte0 = (byte)getInt(i);
      else
         lastColumnNull = true;
      return byte0;
   }

   public byte getByte(String s) throws SQLException {
      return getByte(findColumn(s));
   }

   public synchronized byte[] getBytes(int i) throws SQLException {
      byte[] Return = null;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null) {
         Return = (byte[]) getData (i, byte[].class);
      } else {
         lastColumnNull = true;
      }
      return Return;
   }

   public byte[] getBytes(String s) throws SQLException {
      return getBytes(findColumn(s));
   }

   public Reader getCharacterStream(int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getCharacterStream(int i)");
      throw new UnsupportedOperationException();
   }

   public Reader getCharacterStream(String s) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getCharacterStream(String s)");
      throw new UnsupportedOperationException();
   }

   public Clob getClob(int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getClob(int i)");
      throw new UnsupportedOperationException();
   }

   public Clob getClob(String s) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getClob(String s)");
      throw new UnsupportedOperationException();
   }

   public void updateClob(int columnIndex, Clob x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateClob(int columnIndex, Clob x)");
      throw new UnsupportedOperationException();
   }

   public void updateClob(String columnName, Clob x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateClob(String columnName, Clob x)");
      throw new UnsupportedOperationException();
   }

   public int getColAttribute(int col, short t) throws SQLException {
      int Return = 0;
      clearWarnings();
      try {
         Return = odbcApi.SQLColAttributes(getHSTMT(), (short) col, t);
         if (t == OdbcDef.SQL_COLUMN_TYPE)
            Return = OdbcDef.odbcTypeToJdbc(Return);
      } catch(PicoSQLWarning jdbcodbcsqlwarning) {
         BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
         Return = bigdecimal.intValue();
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      return Return;
   }

   public int getColumnCount() throws SQLException {
      int i = 0;
      clearWarnings();
      if(lastPseudoCol > 0)
         return lastPseudoCol;
      if(colMappings != null)
         return colMappings.length;
      try {
         if(numResultCols == -1)
            numResultCols = odbcApi.SQLNumResultCols(getHSTMT());
         i = numResultCols;
      } catch(PicoSQLWarning jdbcodbcsqlwarning) {
         BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
         i = bigdecimal.intValue();
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      return i;
   }

   public int getColumnLength(int i) throws SQLException {
      int j = -1;
      if(i > 0 && i <= numberOfCols)
         j = boundCols[i - 1].getLength();
      if(j == -1)
      {
         j = getColAttribute(i, OdbcDef.SQL_COLUMN_LENGTH);
         if(i > 0 && i <= numberOfCols)
            boundCols[i - 1].setLength(j);
      }
      return j;
   }

   public int getColumnType(int i) throws SQLException {
      int j = 9999;
      if(i > 0 && i <= numberOfCols)
         j = boundCols[i - 1].getType();
      if(j == 9999) {
         j = getColAttribute(i, OdbcDef.SQL_COLUMN_TYPE);
         if(i > 0 && i <= numberOfCols)
            boundCols[i - 1].setType(j);
      }
      return j;
   }

   public int getConcurrency() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("PicoResultSet.getConcurrency()");
      return ResultSet.CONCUR_UPDATABLE; // TODO Gestire meglio
   }

   public String getCursorName() throws SQLException {
      String s = "";
      clearWarnings();
      try {
         s = odbcApi.SQLGetCursorName(getHSTMT());
      } catch(PicoSQLWarning jdbcodbcsqlwarning) {
         s = (String)jdbcodbcsqlwarning.value;
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      return s.trim();
   }

   public Double getDataDouble(int i) throws SQLException {
      lastColumnNull = false;
      Double double1;
      try {
         // double1 = odbcApi.SQLGetDataDouble(getHSTMT(), i);
         double1 = (Double) getData(i, Double.class);
      } catch(PicoSQLWarning jdbcodbcsqlwarning) {
         double1 = (Double)jdbcodbcsqlwarning.value;
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      if(double1 == null)
         lastColumnNull = true;
      return double1;
   }

   public Float getDataFloat(int i) throws SQLException {
      lastColumnNull = false;
      Float float1;
      try {
         // float1 = odbcApi.SQLGetDataFloat(getHSTMT(), i);
         float1 = (Float) getData(i, Float.class);
      } catch(PicoSQLWarning jdbcodbcsqlwarning) {
         float1 = (Float)jdbcodbcsqlwarning.value;
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      if(float1 == null)
         lastColumnNull = true;
      return float1;
   }

   public Integer getDataInteger(int i) throws SQLException {
      lastColumnNull = false;
      Integer integer;
      try {
         // integer = odbcApi.SQLGetDataInteger(getHSTMT(), i);
         integer = (Integer) getData(i, Integer.class);
      } catch(PicoSQLWarning jdbcodbcsqlwarning) {
         integer = (Integer)jdbcodbcsqlwarning.value;
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      if(integer == null)
         lastColumnNull = true;
      else
      if(i == sqlTypeColumn)
         integer = new Integer(OdbcDef.odbcTypeToJdbc(integer.intValue()));
      return integer;
   }

   public Long getDataLong(int i) throws SQLException {
      Long long1 = null;
      Double double1 = getDataDouble(i);
      if(double1 != null)
         long1 = new Long(double1.longValue());
      return long1;
   }

   public String getDataString(int i, int j, boolean flag)
      throws SQLException {
      lastColumnNull = false;
      String s;
      try
      {
         // s = odbcApi.SQLGetDataString(getHSTMT(), i, j, flag);
         s = (String) getData(i, String.class);
      }
      catch(PicoSQLWarning jdbcodbcsqlwarning)
      {
         s = (String)jdbcodbcsqlwarning.value;
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      if(s == null)
         lastColumnNull = true;
      else
      if(i == sqlTypeColumn)
         try
         {
            int k = OdbcDef.odbcTypeToJdbc(Integer.valueOf(s).intValue());
            s = String.valueOf(k);
         }
         catch(Exception _ex) { }
      return s;
   }

   public java.sql.Date getDate(int i) throws SQLException {
      return new java.sql.Date (getTimestamp(i).getTime());
   }

   public java.sql.Date getDate(int i, Calendar calendar) throws SQLException {
      return new java.sql.Date (getTimestamp(i, calendar).getTime());
   }

   public java.sql.Date getDate(String s) throws SQLException {
      return getDate(findColumn(s));
   }

   public java.sql.Date getDate(String s, Calendar calendar)
                                                        throws SQLException {
      return getDate(findColumn(s), calendar);
   }

   public double getDouble(int i)
      throws SQLException
   {
      double d = 0.0D;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null)       {
         Double double1 = getDataDouble(i);
         if(double1 != null)
            d = double1.doubleValue();
      } else {
         lastColumnNull = true;
      }
      return d;
   }

   public double getDouble(String s)
      throws SQLException
   {
      return getDouble(findColumn(s));
   }

   public int getFetchDirection()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getFetchDirection()");
      throw new UnsupportedOperationException();
   }

   public int getFetchSize()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getFetchSize()");
      throw new UnsupportedOperationException();
   }

   public float getFloat(int i)
      throws SQLException
   {
      float f = 0.0F;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null)
      {
         Float float1 = getDataFloat(i);
         if(float1 != null)
            f = float1.floatValue();
      }
      else
      {
         lastColumnNull = true;
      }
      return f;
   }

   public float getFloat(String s)
      throws SQLException
   {
      return getFloat(findColumn(s));
   }

   public int getInt(int i)
      throws SQLException
   {
      int j = 0;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null)
      {
         Integer integer = getDataInteger(i);
         if(integer != null)
            j = integer.intValue();
      }
      else
      {
         lastColumnNull = true;
      }
      return j;
   }

   public int getInt(String s)
      throws SQLException
   {
      return getInt(findColumn(s));
   }

   public long getLong(int i)
      throws SQLException
   {
      long l = 0L;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null)
      {
         Double double1 = getDataDouble(i);
         if(double1 != null)
            l = double1.longValue();
      }
      else
      {
         lastColumnNull = true;
      }
      return l;
   }

   public long getLong(String s)
      throws SQLException
   {
      return getLong(findColumn(s));
   }

   protected int getMaxBinaryLen(int i)
      throws SQLException
   {
      int j = getColumnLength(i);
      if(j != -1 && (j <= 0 || j > PicoLimits.MAX_GET_DATA_LENGTH))
         j = PicoLimits.MAX_GET_DATA_LENGTH;
      return j;
   }

   protected int getMaxCharLen(int i)
      throws SQLException
   {
      int j = getColumnType(i);
      int k = getColumnLength(i);
      if(k != -1)
      {
         switch(j)
         {
         case -4: 
         case -3: 
         case -2: 
            k *= 2;
            break;

         case 91: // '['
            k = 10;
            break;

         case 92: // '\\'
            k = 8;
            break;

         case 93: // ']'
            k = 29;
            break;

         case 2: // '\002'
         case 3: // '\003'
            k += 2;
            break;

         case -7: 
            k = 1;
            break;

         case -6: 
            k = 4;
            break;

         case 5: // '\005'
            k = 6;
            break;

         case 4: // '\004'
            k = 11;
            break;

         case -5: 
            k = 20;
            break;

         case 7: // '\007'
            k = 13;
            break;

         case 6: // '\006'
         case 8: // '\b'
            k = 22;
            break;

         }
         if(k <= 0 || k > PicoLimits.MAX_GET_DATA_LENGTH)
            k = PicoLimits.MAX_GET_DATA_LENGTH;
      }
      return k;
   }

   public ResultSetMetaData getMetaData() throws SQLException {
      if(DriverManager.getLogWriter() != null)
         DriverManager.println("*ResultSet.getMetaData");
      if(closed)
         throw new SQLException("ResultSet is closed");
      else
         return new PicoResultSetMetaData(odbcApi, this);
   }

   public Object getObject(int i)
      throws SQLException
   {
      Object obj = null;
      int j = getColumnType(i);
      int k = i;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) != null)
      {
         lastColumnNull = true;
         return null;
      }
      switch(j)
      {
      case -1: 
      case 1: // '\001'
      case 12: // '\f'
         obj = getString(i);
         break;

      case 2: // '\002'
      case 3: // '\003'
         obj = getBigDecimal(i, getScale(k));
         break;

      case -7: 
         obj = new Boolean(getBoolean(i));
         break;

      case -6: 
      case 4: // '\004'
      case 5: // '\005'
         obj = new Integer(getInt(i));
         break;

      case -5: 
         obj = new Long(getLong(i));
         break;

      case 7: // '\007'
         obj = new Float(getFloat(i));
         break;

      case 6: // '\006'
      case 8: // '\b'
         obj = new Double(getDouble(i));
         break;

      case -4: 
      case -3: 
      case -2: 
         obj = getBytes(i);
         break;

      case 91: // '['
         obj = getDate(i);
         break;

      case 92: // '\\'
         obj = getTime(i);
         break;

      case 93: // ']'
         obj = getTimestamp(i);
         break;

      }
      if(wasNull())
         obj = null;
      return obj;
   }

   public Object getObject(int i, Map map)
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getObject(int i, Map map)");
      throw new UnsupportedOperationException();
   }

   public Object getObject(String s)
      throws SQLException
   {
      return getObject(findColumn(s));
   }

   public Object getObject(String s, Map map)
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getObject(String s, Map map)");
      throw new UnsupportedOperationException();
   }

   public PicoPseudoCol getPseudoCol(int i)
   {
      PicoPseudoCol jdbcodbcpseudocol = null;
      if(i > 0 && i >= firstPseudoCol && i <= lastPseudoCol)
         jdbcodbcpseudocol = pseudoCols[i - firstPseudoCol];
      return jdbcodbcpseudocol;
   }

   public Ref getRef(int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getRef(int i)");
      throw new UnsupportedOperationException();
   }

   public Ref getRef(String s) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getRef(String s)");
      throw new UnsupportedOperationException();
   }

   public void updateRef(int columnIndex, Ref x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateRef(int columnIndex, Ref x)");
      throw new UnsupportedOperationException();
   }

   public void updateRef(String columnName, Ref x) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateRef(String columnName, Ref x)");
      throw new UnsupportedOperationException();
   }

   public int getRow()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getRow()");
      throw new UnsupportedOperationException();
   }

   public int getRowCount()
      throws SQLException
   {
      int i = 0;
      clearWarnings();
      try
      {
         i = odbcApi.SQLRowCount(getHSTMT());
      }
      catch(PicoSQLWarning jdbcodbcsqlwarning)
      {
         BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
         i = bigdecimal.intValue();
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      return i;
   }

   public int getRowNumber()
      throws SQLException
   {
      int i = 0;
      clearWarnings();
      try
      {
         i = odbcApi.SQLGetStmtOption(getHSTMT(), (short)14);
      }
      catch(PicoSQLWarning jdbcodbcsqlwarning)
      {
         BigDecimal bigdecimal = (BigDecimal)jdbcodbcsqlwarning.value;
         i = bigdecimal.intValue();
         setWarning(PicoDbApi.convertWarning(jdbcodbcsqlwarning));
      }
      return i;
   }

   public int getScale(int i) throws SQLException {
      int j;
      if(getPseudoCol(i) != null) {
         lastColumnNull = true;
         j = 0;
      } else {
         j = getColAttribute(i, OdbcDef.SQL_COLUMN_SCALE);
      }
      return j;
   }

   public short getShort(int i)
      throws SQLException
   {
      short word0 = 0;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null)
         word0 = (short)getInt(i);
      else
         lastColumnNull = true;
      return word0;
   }

   public short getShort(String s)
      throws SQLException
   {
      return getShort(findColumn(s));
   }

   public Statement getStatement()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.getStatement()");
      throw new UnsupportedOperationException();
   }

   public String getString(int i) throws SQLException {
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) != null)
      {
         lastColumnNull = true;
         return null;
      }
      int j = getMaxCharLen(i);
      if(j == -1)
         return null;
      boolean flag = false;
      int k = getColumnType(i);
      j++;
      String s = getDataString(i, j, flag);
      if(s == null)
         return s;
      int l = s.length();
      if(l == j - 1 && !flag)
         s = s.substring(0, j - 1);
      if((k == -1 || k == -4) && l == j - 1)
      {
         for(String s1 = s; s1.length() == PicoLimits.MAX_GET_DATA_LENGTH;)
         {
            s1 = getDataString(i, j, flag);
            if(s1 == null)
               break;
            if(DriverManager.getLogWriter() != null)
               DriverManager.println(s1.length() + " byte(s) read");
            if(s1.length() == j)
               s1 = s1.substring(0, j - 1);
            s = s + s1;
            if(DriverManager.getLogWriter() != null)
               DriverManager.println(s.length() + " bytes total");
         }

      }
      return s;
   }

   public String getString(String s)
      throws SQLException
   {
      return getString(findColumn(s));
   }

   public Time getTime(int i) throws SQLException {
      return new java.sql.Time (getTimestamp(i).getTime());
   }

   public Time getTime(int i, Calendar calendar) throws SQLException {      
      return new java.sql.Time (getTimestamp(i, calendar).getTime());
   }

   public Time getTime(String s) throws SQLException {
      return getTime(findColumn(s));
   }

   public Time getTime(String s, Calendar calendar) throws SQLException {
      return getTime(findColumn(s), calendar);
   }

   public Timestamp getTimestamp(int i) throws SQLException {
      Timestamp Return = null;
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      if(getPseudoCol(i) == null) {
         Return = (Timestamp) getData (i, Timestamp.class);
      } else {
         lastColumnNull = true;
      }
      return Return; 
   }

   public Timestamp getTimestamp(int i, Calendar calendar) throws SQLException {
      calendar.setTime (getTimestamp(i));
      return new Timestamp (calendar.getTime().getTime());
   }

   public Timestamp getTimestamp(String s) throws SQLException {
      return getTimestamp(findColumn(s));
   }

   public Timestamp getTimestamp(String s, Calendar calendar)
                                                        throws SQLException {
      return getTimestamp(findColumn(s), calendar);
   }

   public java.net.URL getURL (int i) throws SQLException {
      java.net.URL Return = null;
      try {
         Return = new java.net.URL (getString(i));
      } catch (java.net.MalformedURLException e) {
      }
      return Return;
   }

   public java.net.URL getURL (String n) throws SQLException {
      java.net.URL Return = null;
      try {
         Return = new java.net.URL (getString(n));
      } catch (java.net.MalformedURLException e) {
      }
      return Return;
   }

   public int getType() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("PicoResultSet.getType()");
      return ResultSet.TYPE_SCROLL_SENSITIVE; // TODO Gestire meglio
   }

   public InputStream getUnicodeStream(int i) throws SQLException {
      clearWarnings();
      lastColumnNull = false;
      i = mapColumn(i);
      int j = getColumnType(i);
      byte byte0 = -2;
      switch(j)
      {
      case -1: 
      case 1: // '\001'
      case 12: // '\f'
         byte0 = 1;
         break;

      }
      PicoInputStream jdbcodbcinputstream = new PicoInputStream(odbcApi, getHSTMT(), i, (short)2, byte0, ownerStatement);
      setInputStream(i, jdbcodbcinputstream);
      return jdbcodbcinputstream;
   }

   public InputStream getUnicodeStream(String s) throws SQLException {
      return getUnicodeStream(findColumn(s));
   }

   public SQLWarning getWarnings() throws SQLException {
      return lastWarning;
   }

   public void insertRow()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.insertRow()");
      throw new UnsupportedOperationException();
   }

   public boolean isAfterLast()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.isAfterLast()");
      throw new UnsupportedOperationException();
   }

   public boolean isBeforeFirst()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.isBeforeFirst()");
      throw new UnsupportedOperationException();
   }

   public boolean isFirst()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.isFirst()");
      throw new UnsupportedOperationException();
   }

   public boolean isLast()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.isLast()");
      throw new UnsupportedOperationException();
   }

   public boolean last()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.last()");
      throw new UnsupportedOperationException();
   }

   public int mapColumn(int i)
   {
      int j = i;
      if(colMappings != null)
         if(i > 0 && i <= colMappings.length)
            j = colMappings[i - 1];
         else
            j = -1;
      return j;
   }

   public void moveToCurrentRow()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.moveToCurrentRow()");
      throw new UnsupportedOperationException();
   }

   public void moveToInsertRow()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.moveToInsertRow()");
      throw new UnsupportedOperationException();
   }

   public boolean next()
      throws SQLException
   {
      boolean flag = true;
      lastColumnNull = false;
      closeInputStreams();
      clearWarnings();
      data = null;
      try
      {
         flag = odbcApi.SQLFetch(getHSTMT());
      }
      catch(PicoSQLWarning sqlwarning)
      {
         setWarning(sqlwarning);
      }
      return flag;
   }

   public boolean previous()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.previous()");
      throw new UnsupportedOperationException();
   }

   public void refreshRow()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.refreshRow()");
      throw new UnsupportedOperationException();
   }

   public boolean relative(int i)
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.relative(int i)");
      throw new UnsupportedOperationException();
   }

   public boolean rowDeleted()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("PicoResultSet.rowDeleted()=false");
      return false;
   }

   public boolean rowInserted()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("PicoResultSet.rowInserted()=false");
      return false;
   }

   public boolean rowUpdated()
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("PicoResultSet.rowUpdated()=false");
      return false;
   }

   public void setColumnMappings(int ai[])
   {
      colMappings = ai;
   }

   public void setFetchDirection(int i)
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.setFetchDirection(int i)");
      throw new UnsupportedOperationException();
   }

   public void setFetchSize(int i)
   {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.setFetchSize(int i)");
      throw new UnsupportedOperationException();
   }

   protected void setInputStream(int i, PicoInputStream jdbcodbcinputstream)
   {
      if(i > 0 && i <= numberOfCols)
         boundCols[i - 1].setInputStream(jdbcodbcinputstream);
   }

   public void setPseudoCols(int i, int j, PicoPseudoCol ajdbcodbcpseudocol[])
   {
      if(DriverManager.getLogWriter() != null)
         DriverManager.println("Setting pseudo columns, first=" + i + ", last=" + j);
      firstPseudoCol = i;
      lastPseudoCol = j;
      pseudoCols = ajdbcodbcpseudocol;
   }

   public void setSQLTypeColumn(int i)
   {
      sqlTypeColumn = i;
   }

   public void setWarning(SQLWarning warn) throws SQLException {
      lastWarning = warn;
   }

   public void updateAsciiStream(int i, InputStream inputstream, int j) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateAsciiStream(int i, InputStream inputstream, int j)");
      throw new UnsupportedOperationException();
   }

   public void updateAsciiStream(String s, InputStream inputstream, int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateAsciiStream(String s, InputStream inputstream, int i)");
      throw new UnsupportedOperationException();
   }

   public void updateBigDecimal(int i, BigDecimal bigdecimal) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBigDecimal(int i, BigDecimal bigdecimal)");
      throw new UnsupportedOperationException();
   }

   public void updateBigDecimal(String s, BigDecimal bigdecimal) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBigDecimal(String s, BigDecimal bigdecimal)");
      throw new UnsupportedOperationException();
   }

   public void updateBinaryStream(int i, InputStream inputstream, int j) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBinaryStream(int i, InputStream inputstream, int j)");
      throw new UnsupportedOperationException();
   }

   public void updateBinaryStream(String s, InputStream inputstream, int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBinaryStream(String s, InputStream inputstream, int i)");
      throw new UnsupportedOperationException();
   }

   public void updateBoolean(int i, boolean flag) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBoolean(int i, boolean flag)");
      throw new UnsupportedOperationException();
   }

   public void updateBoolean(String s, boolean flag) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBoolean(String s, boolean flag)");
      throw new UnsupportedOperationException();
   }

   public void updateByte(int i, byte byte0) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateByte(int i, byte byte0)");
      throw new UnsupportedOperationException();
   }

   public void updateByte(String s, byte byte0) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateByte(String s, byte byte0)");
      throw new UnsupportedOperationException();
   }

   public void updateBytes(int i, byte abyte0[]) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBytes(int i, byte abyte0[])");
      throw new UnsupportedOperationException();
   }

   public void updateBytes(String s, byte abyte0[]) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateBytes(String s, byte abyte0[])");
      throw new UnsupportedOperationException();
   }

   public void updateCharacterStream(int i, Reader reader, int j) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateCharacterStream(int i, Reader reader, int j)");
      throw new UnsupportedOperationException();
   }

   public void updateCharacterStream(String s, Reader reader, int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateCharacterStream(String s, Reader reader, int i)");
      throw new UnsupportedOperationException();
   }

   public void updateDate(int i, java.sql.Date date) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateDate(int i, java.sql.Date date)");
      throw new UnsupportedOperationException();
   }

   public void updateDate(String s, java.sql.Date date) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateDate(String s, java.sql.Date date)");
      throw new UnsupportedOperationException();
   }

   public void updateDouble(int i, double d) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateDouble(int i, double d)");
      throw new UnsupportedOperationException();
   }

   public void updateDouble(String s, double d) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateDouble(String s, double d)");
      throw new UnsupportedOperationException();
   }

   public void updateFloat(int i, float f) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateFloat(int i, float f)");
      throw new UnsupportedOperationException();
   }

   public void updateFloat(String s, float f) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateFloat(String s, float f)");
      throw new UnsupportedOperationException();
   }

   public void updateInt(int i, int j) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateInt(int i, int j)");
      throw new UnsupportedOperationException();
   }

   public void updateInt(String s, int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateInt(String s, int i)");
      throw new UnsupportedOperationException();
   }

   public void updateLong(int i, long l) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateLong(int i, long l)");
      throw new UnsupportedOperationException();
   }

   public void updateLong(String s, long l) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateLong(String s, long l)");
      throw new UnsupportedOperationException();
   }

   public void updateNull(int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateNull(int i)");
      throw new UnsupportedOperationException();
   }

   public void updateNull(String s) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateNull(String s)");
      throw new UnsupportedOperationException();
   }

   public void updateObject(int i, Object obj) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateObject(int i, Object obj)");
      throw new UnsupportedOperationException();
   }

   public void updateObject(int i, Object obj, int j) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateObject(int i, Object obj, int j)");
      throw new UnsupportedOperationException();
   }

   public void updateObject(String s, Object obj) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateObject(String s, Object obj)");
      throw new UnsupportedOperationException();
   }

   public void updateObject(String s, Object obj, int i) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateObject(String s, Object obj, int i)");
      throw new UnsupportedOperationException();
   }

   public void updateRow() {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateRow()");
      throw new UnsupportedOperationException();
   }

   public void updateShort(int i, short word0) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateShort(int i, short word0)");
      throw new UnsupportedOperationException();
   }

   public void updateShort(String s, short word0) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateShort(String s, short word0)");
      throw new UnsupportedOperationException();
   }

   public void updateString(int i, String s) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateString(int i, String s)");
      throw new UnsupportedOperationException();
   }

   public void updateString(String s, String s1) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateString(String s, String s1)");
      throw new UnsupportedOperationException();
   }

   public void updateTime(int i, Time time) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateTime(int i, Time time)");
      throw new UnsupportedOperationException();
   }

   public void updateTime(String s, Time time) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateTime(String s, Time time)");
      throw new UnsupportedOperationException();
   }

   public void updateTimestamp(int i, Timestamp timestamp) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateTimestamp(int i, Timestamp timestamp)");
      throw new UnsupportedOperationException();
   }

   public void updateTimestamp(String s, Timestamp timestamp) {
      if (DriverManager.getLogWriter() != null)
         DriverManager.println("Unsupported PicoResultSet.updateTimestamp(String s, Timestamp timestamp)");
      throw new UnsupportedOperationException();
   }

   public boolean wasNull() throws SQLException {
      return lastColumnNull;
   }
}
