/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoiiop - network support for picoSQL

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef connectn_h
#define connectn_h "$Id: connectn.h,v 1.2 2002/05/06 10:19:10 picoSoft Exp $"
# include "corba.h"
# include "except.h"
# include "iiopobj.h"


#ifdef WIN32
#include <windows.h>
#define GetErrno() WSAGetLastError()
#define GetHErrno() WSAGetLastError()
#else
typedef int SOCKET;
typedef struct linger LINGER;
#include <errno.h>
#include <time.h>
#include <sys/time.h>
#include <netdb.h>
#include <sys/types.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#ifdef AIX4
#include <sys/select.h>
#endif
#include <netinet/in.h>
#define GetErrno() errno
#define GetHErrno() h_errno
#define closesocket close
#define INVALID_SOCKET -1
#define SOCKET_ERROR -1
#endif

#define BUFSIZE_TCP 128
#define MAXHOSTNAME 64
#define MAXFILENAME 256

typedef enum tConnectionType {
   Connection_UNDEF = 0,
   Connection_SOCKET,
   Connection_PIPE,
} ConnectionType;

typedef struct tConnection {
   int fd;
   IiopObj *obj;
   SOCKET sock;
   ConnectionType type;
   struct hostent * hp;
   struct timeval timeOut;
   struct sockaddr_in sin;
   fd_set idSet;
} Connection;

Connection * Connection_new(IiopObj *ob);
void Connection_delete(Connection *This);

CORBA_Boolean Connection_recv (Connection *This, Exception *ex,
                               char *buffer, int len);
CORBA_Boolean Connection_send (Connection *This, Exception *ex,
                               char *buffer, int len);
CORBA_Boolean Connection_listen (Connection *This, Exception *ex);
CORBA_Boolean Connection_connect (Connection *This, Exception *ex);
CORBA_Boolean Connection_init (Exception *ex);
CORBA_Boolean Connection_exit (Exception *ex);

# endif

