/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include <stdio.h>
# include <fcntl.h>
# ifdef WIN32
# include <io.h>
# else
# include <unistd.h>
# endif
# include <stdlib.h>
# include <string.h>
# include <errno.h>
# include "isam.h"
# include "picoisam.h"
static char rcsid[] = "$Id: pIrecover.c,v 1.1 2002/05/09 15:41:11 picoSoft Exp $";

const char *
showError ()
{
   switch (pIserrno) {
   case EDUPL:
      return "duplicate record";
   case ENOTOPEN:
      return "file not open";
   case EBADARG:
      return "illegal argument";
   case EBADKEY:
      return "illegal key desc";
   case ETOOMANY:
      return "too many files open";
   case EBADFILE:
      return "bad isam file format";
   case ENOTEXCL:
      return "non-exclusive access";
   case ELOCKED:
      return "record locked";
   case EKEXISTS:
      return "key already exists";
   case EPRIMKEY:
      return "is primary key";
   case EENDFILE:
      return "end/begin of file";
   case ENOREC:
      return "no record found";
   case ENOCURR:
      return "no current record";
   case EFLOCKED:
      return "file locked";
   case EFNAME:
      return "file name too long";
   case EBADMEM:
      return "can't alloc memory";
   case EBADOPENMODE:
      return "incompatible operation with open mode";
   case ENOTSUPP:
      return "function not supported";
   case EDISKFULL:
      return "disk full";
   case ERECCHANGED:
      return "rec changed";
   case ENOLOCKS:
      return "no more locks available";
   case EMISSINGFILE:
      return "missing file";
   case EPERMISSION:
      return "invalid permission";
   }
   return strerror(errno);
}

void
usage ()
{
   fprintf (stderr, "pIrecover version [%s]\n", rcsid);
   fprintf (stderr, "usage: pIrecover [-n] <logFile>\n\
            -n  do not remove the transaction log\n");
}

int
main(int argc, char *argv[])
{
   int rc, i;
   char *logName = 0;
   int remove = 1;
   for (i = 1; i < argc; i++)
      if (argv[i][0] == '-') {
         switch (argv[i][1]) {
         case 'n':
            remove = 0;
            break;
         default:
            usage();
            return 2;
         }
      } else
         if (logName == 0)
            logName = argv[i];
         else {
            usage();
            return 2;
         }
   if (logName == 0) {
      usage();
      return 2;
   }
 
   rc = pIslogopen (logName);
   if (rc != 0) {
      fprintf (stderr, "Cannot open log file %s: %s\n",logName,showError());
      return 3;
   }
   rc = pIsrecover ();
   if (rc != 0) {
      fprintf (stderr, "Cannot recover logFile %s: %s\n",logName, showError());
      return 4;
   }
   rc = pIslogclose ();
   if (rc != 0) {
      fprintf (stderr, "Cannot close log file %s: %s\n",logName, showError());
      return 5;
   }
   if (remove == 1) {
      rc = unlink (logName);
      if (rc != 0) {
         fprintf (stderr, "Cannot remove log file %s: %s\n",
                   logName, showError());
         return 6;
      }
   }
   return 0;
}

