/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 picoSqlNet - picoSQL client library

 Copyright (C) Picosoft s.r.l. 1994-2002

 This library is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.

 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.

 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
static char rcsid[] = "$Id: options.cpp 4.2 1999/01/11 17:29:32 picoSoft Exp picoSoft $";
# ifdef WIN32
# include <windows.h>
# include <sql.h>
# include <sqlext.h>
# else
extern "C" {
# include "sqltype.h"
}
# endif
# include <stdio.h>
# include "sqlhndls.h"
# include "dberror.h"
extern "C" {

RETCODE   SQL_API SQLSetConnectOption(
   HDBC   hdbc,
   UWORD  fOption,
   UDWORD vParam)
{

   RETCODE Return = SQL_ERROR;
   ClntHdbc *myHdbc = (ClntHdbc *) hdbc;
   void *argv[5];
   CORBA_String pvParam_a = 0;
   UDWORD pvParam_b = 0;

   if (!myHdbc || !myHdbc->IsA(ClntHdbc::Class))
      return SQL_INVALID_HANDLE;

   DelError(0, myHdbc, 0);
   if (fOption == SQL_LOGIN_TIMEOUT) {
      myHdbc->loginTimeout = vParam;
      return SQL_SUCCESS;
   }

   switch (fOption) {
   case SQL_CURRENT_QUALIFIER:
   case SQL_OPT_TRACEFILE:
   case SQL_TRANSLATE_DLL:
      pvParam_a = (char *)vParam;
      break;
   case SQL_ACCESS_MODE:
   case SQL_AUTOCOMMIT:
   case SQL_ODBC_CURSORS:
   case SQL_OPT_TRACE:
   case SQL_PACKET_SIZE:
   case SQL_QUIET_MODE:
   case SQL_TRANSLATE_OPTION:
   case SQL_TXN_ISOLATION:
   default:
      pvParam_b = vParam;
      break;
   }
   argv[0] = &Return;
   argv[1] = &myHdbc->srvHdbc;
   argv[2] = &fOption;
   argv[3] = pvParam_a;
   argv[4] = &pvParam_b;
   
   Exception *ex = Exception_new();
   doCall (myHdbc, ex,"SQLSetConnectOption",argv);
   Exception_delete (ex);

   return Return;
}

RETCODE   SQL_API SQLGetConnectOption(
   HDBC   hdbc,
   UWORD  fOption,
   PTR    pvParam)
{
   RETCODE Return = SQL_ERROR;
   ClntHdbc *myHdbc = (ClntHdbc *) hdbc;
   void *argv[5];
   UDWORD pvParam_b;

   if (!myHdbc || !myHdbc->IsA(ClntHdbc::Class))
      return SQL_INVALID_HANDLE;

   DelError(0, myHdbc, 0);
   if (fOption == SQL_LOGIN_TIMEOUT) {
      *((UDWORD *) pvParam) = myHdbc->loginTimeout;
      return SQL_SUCCESS;
   }

   argv[0] = &Return;
   argv[1] = &myHdbc->srvHdbc;
   argv[2] = &fOption;
   argv[3] = pvParam;
   argv[4] = &pvParam_b;
   
   Exception *ex = Exception_new();
   if (doCall (myHdbc,ex,"SQLGetConnectOption",argv) && Return == SQL_SUCCESS)
      switch (fOption) {
      case SQL_CURRENT_QUALIFIER:
      case SQL_OPT_TRACEFILE:
      case SQL_TRANSLATE_DLL:
         break;
      case SQL_ACCESS_MODE:
      case SQL_AUTOCOMMIT:
      case SQL_ODBC_CURSORS:
      case SQL_OPT_TRACE:
      case SQL_PACKET_SIZE:
      case SQL_QUIET_MODE:
      case SQL_TRANSLATE_OPTION:
      case SQL_TXN_ISOLATION:
      default:
         *((UDWORD *) pvParam) = pvParam_b;
         break;
      }
   Exception_delete (ex); 
   return Return;
}

RETCODE SQL_API
SQLGetStmtAttr (SQLHSTMT StatementHandle, SQLINTEGER Attribute,
                SQLPOINTER ValuePtr, SQLINTEGER BufferLength,
                SQLINTEGER *StringLength)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) StatementHandle;

   switch (Attribute) {
   case SQL_ATTR_APP_ROW_DESC:
   case SQL_ATTR_APP_PARAM_DESC:
   case SQL_ATTR_AUTO_IPD:
   case SQL_ATTR_ROW_BIND_TYPE:
   case SQL_ATTR_IMP_ROW_DESC:
   case SQL_ATTR_IMP_PARAM_DESC:
   case SQL_ATTR_METADATA_ID:
   case SQL_ATTR_PARAM_BIND_TYPE:
/*
   case SQL_ATTR_PREDICATE_PTR:
   case SQL_ATTR_PREDICATE_OCTET_LENGTH_PTR:
*/
   case SQL_ATTR_PARAM_BIND_OFFSET_PTR:
   case SQL_ATTR_ROW_BIND_OFFSET_PTR:
   case SQL_ATTR_ROW_OPERATION_PTR:
   case SQL_ATTR_PARAM_OPERATION_PTR:
      AddError (0,0,myHstmt,"HY092",0,"Invalid attribute/option identifier");
      break;
   case SQL_ATTR_PARAMSET_SIZE:
   case SQL_ATTR_PARAMS_PROCESSED_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   case SQL_ATTR_ROWS_FETCHED_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   case SQL_ATTR_ROW_STATUS_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   case SQL_ATTR_FETCH_BOOKMARK_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   default:
      Return = SQLGetStmtOption (StatementHandle, Attribute, ValuePtr);
      break;
   }

   return Return;
}

RETCODE SQL_API
SQLSetStmtAttr (SQLHSTMT StatementHandle, SQLINTEGER Attribute,
                          SQLPOINTER ValuePtr, SQLINTEGER StringLength)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) StatementHandle;

   switch (Attribute) {
   case SQL_ATTR_APP_ROW_DESC:
   case SQL_ATTR_APP_PARAM_DESC:
   case SQL_ATTR_AUTO_IPD:
   case SQL_ATTR_ROW_BIND_TYPE:
   case SQL_ATTR_IMP_ROW_DESC:
   case SQL_ATTR_IMP_PARAM_DESC:
   case SQL_ATTR_METADATA_ID:
   case SQL_ATTR_PARAM_BIND_TYPE:
/*
   case SQL_ATTR_PREDICATE_PTR:
   case SQL_ATTR_PREDICATE_OCTET_LENGTH_PTR:
*/
   case SQL_ATTR_PARAM_BIND_OFFSET_PTR:
   case SQL_ATTR_ROW_BIND_OFFSET_PTR:
   case SQL_ATTR_ROW_OPERATION_PTR:
   case SQL_ATTR_PARAM_OPERATION_PTR:
      AddError (0,0,myHstmt,"HY092",0,"Invalid attribute/option identifier");
      break;
   case SQL_ATTR_PARAMSET_SIZE:
   case SQL_ATTR_PARAMS_PROCESSED_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   case SQL_ATTR_ROWS_FETCHED_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   case SQL_ATTR_ROW_STATUS_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   case SQL_ATTR_FETCH_BOOKMARK_PTR:
      AddError (0,0,myHstmt,"HYC00", 0, "Optional feature not implemented");
      break;
   default:
      Return = SQLSetStmtOption (StatementHandle, Attribute, (UDWORD) ValuePtr);
      break;
   }

   return Return;
}

RETCODE SQL_API SQLSetStmtOption(
    HSTMT   hstmt,
    UWORD   fOption,
    UDWORD  vParam)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[5];
   CORBA_String pvParam_a = 0;
   UDWORD pvParam_b = 0;

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;

   DelError(0, 0, myHstmt);
   if (fOption == SQL_QUERY_TIMEOUT) {
      myHstmt->queryTimeout = vParam;
      return SQL_SUCCESS;
   }

   switch (fOption) {
   case SQL_MAX_ROWS:
   case SQL_CONCURRENCY:
   case SQL_CURSOR_TYPE:
   case SQL_NOSCAN:
   case SQL_ROWSET_SIZE:
   case SQL_MAX_LENGTH:
   case SQL_ASYNC_ENABLE:
   case SQL_BIND_TYPE:
   case SQL_KEYSET_SIZE: // start ODBC 2.0
   case SQL_SIMULATE_CURSOR:
   default:
      pvParam_b = vParam;
      break;
   }

   argv[0] = &Return;
   argv[1] = &myHstmt->srvHstmt;
   argv[2] = &fOption;
   argv[3] = pvParam_a;
   argv[4] = &pvParam_b;
   
   Exception *ex = Exception_new();
   doCall (myHstmt,ex,"SQLSetStmtOption",argv);
   Exception_delete (ex);
   return Return;
}

RETCODE SQL_API SQLGetStmtOption(
    HSTMT   hstmt,
    UWORD   fOption,
    PTR pvParam)
{
   RETCODE Return = SQL_ERROR;
   ClntHstmt *myHstmt = (ClntHstmt *) hstmt;
   void *argv[5];
   UDWORD pvParam_b;

   if (!myHstmt || !myHstmt->IsA(ClntHstmt::Class))
      return SQL_INVALID_HANDLE;

   DelError(0, 0, myHstmt);
   if (fOption == SQL_QUERY_TIMEOUT) {
      *((UDWORD *) pvParam) = myHstmt->queryTimeout;
      return SQL_SUCCESS;
   }


   argv[0] = &Return;
   argv[1] = &myHstmt->srvHstmt;
   argv[2] = &fOption;
   argv[3] = pvParam;
   argv[4] = &pvParam_b;
   
   Exception *ex = Exception_new();
   if (doCall (myHstmt,ex,"SQLGetStmtOption",argv) && Return == SQL_SUCCESS)
      switch (fOption) {
      case SQL_MAX_ROWS:
      case SQL_ROWSET_SIZE:
      case SQL_MAX_LENGTH:
      case SQL_CONCURRENCY:
      case SQL_CURSOR_TYPE:
      case SQL_NOSCAN:
      case SQL_ASYNC_ENABLE:
      case SQL_BIND_TYPE:
      case SQL_KEYSET_SIZE:  // start ODBC 2.0
      case SQL_SIMULATE_CURSOR:
      case SQL_GET_BOOKMARK:
      case SQL_ROW_NUMBER:
      default:
         *((UDWORD *) pvParam) = pvParam_b;
         break;
      }
   Exception_delete (ex);
   return Return;
}

};
