/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef attribut_h
# define attribut_h "$Id: attribut.h 5.1 2000/05/16 13:09:05 picoSoft Exp $"

# include "datatype.h"
# include "pstring.h"
# include "pbool.h"
# include "piteratr.h"
# include "token.h"
# include "dberror.h"
# include "indexprt.h"

class DataBase;
class SqlParser;
class CField;
class StartEnd;
class SearchIndex;
class StmtRel;
class Relation;
class StmtAttr;

typedef unsigned char AttrVis;
static const AttrVis ATTR_ALL = 0;
static const AttrVis ATTR_READONLY = 1;
static const AttrVis ATTR_HIDDEN = 2;
static const AttrVis ATTR_TABLERONLY = 4;

class Attribute : public PObject
{
   PCLASS(Attribute, PObject)

   PString     Name;
   short       Order;
   long        FldPos;
   DataType    FldType;
   long        FldLen;
   long        FldSize;
   short       Decimal;
   SignType    Sign;
   IndexPartCopyList Indexes;
   Relation *  Parent;
   void *      Signature;
   char *      DateFmt;
   AttrVis     Visibility;
   PBool       serial;
public:
   Attribute (const Token &s);
   Attribute (const PString &s, Relation *, AttrVis vis = ATTR_ALL);
   Attribute (Attribute &);
   ~Attribute ();
   void AddIndex (IndexPart &i) { Indexes.AddItem (i); }
   IndexPart * GetFirstIndex () { return Indexes.GetFirst (); }
   IndexPart * GetNextIndex () { return Indexes.GetNext (); }
   PBool IsIndexNumber (short number);
   PBool IsIndexDups (short number);
   PBool IsIndexPart (short part);
   PBool IsIndex (short number, short part);
   short GetIndexPart (short num);
   short GetIndexNum (short part);
   IndexPart *GetIndex (short num);
   void setType (DataType t, long i, int d, PBool serial = PFalse); 
   void setName (char * n) { Name = n;
                             Name.toUpper();
                             if (Name == "FILLER")
                                Visibility |= ATTR_HIDDEN;
                             Name = n;
                           }
   void setPos (short n) { FldPos = n; } 
   PString & getName () { return Name; }
   void setSign (SignType s) { Sign = s; }
   void SetSize (short n) { FldSize = n; }
   void SetLen (short n) { FldLen = n; }
   AttrVis GetVisibility () { return Visibility; }
   void SetVisibility (AttrVis v) { Visibility = v; }
   void AddVisibility (AttrVis v) { Visibility |= v; }
   void DelVisibility (AttrVis v) { Visibility &= ~v; }

   DataType GetType() { return FldType; }
   long GetLen() { return FldLen; }
   short GetDecimal() { return Decimal; }
   SignType GetSign() { return Sign; }
   Relation * getParent () { return Parent; }
   void setParent (Relation *p) { Parent = p; }
   const void * getSignature () { return Signature; }
   void setSignature (void *s) { Signature = s; }
   long getFldSize() { return FldSize; }
   long getFldPos() { return FldPos; }
   const char * getDateFmt() { return DateFmt; }
   DateTime getDateType () { if (DateFmt) return T_TIMESTAMP;
                             else         return T_NODATE;  }
   void setDateFmt(const char *d);
   PBool IsNumeric () { return DateFmt == 0 &&
                              ( FldType == T_PACKED_ORDERED ||
                               FldType == T_SHORT ||
                               FldType == T_LONG ||
                               FldType ==  T_FLOAT ||
                               FldType == T_DOUBLE); }
   void Debug();
   PString getCreateDesc ();
   PBool isSerial () { return serial; }
};

PLIST(Attribute);
PITERATOR(Attribute);

# endif
