/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include "database.h"
# include "sqlpars.h"
# include "trace.h"
# include "sqltype.h"
static char rcsid[] = "$Id: catalog.cpp 5.0 1999/10/08 10:17:43 picoSoft Exp $";
inline PBool
notOk (unsigned char * sz, SWORD cb) {
   return sz != 0 && cb < 0 && cb != SQL_NTS;
}
extern "C" {


//  Have DBMS set up result set of Columns.

RETCODE SQL_API SQLColumns(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UCHAR FAR *szColumnName,
    SWORD     cbColumnName)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) ||
            notOk (szTableName,      cbTableName) ||
            notOk (szColumnName,     cbColumnName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090,"");
      Return = SQL_ERROR;
   } else {
         ((SqlParser *) hstmt)->DelError();
         Return = ((SqlParser *) hstmt)->Columns ((char *)szTableQualifier,
                                                  cbTableQualifier,
                                                  (char *)szTableOwner,
                                                  cbTableOwner,
                                                  (char *)szTableName,
                                                  cbTableName,
                                                  (char *)szColumnName,
                                                  cbColumnName);
   }
   if (Trace.isSet)
      Trace.Write ("SQLColumns(0x%lx,'%s',%d,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szTableQualifier,cbTableQualifier,
                      szTableOwner,cbTableOwner,
                      szTableName,cbTableName,
                      szColumnName,cbColumnName, Return);
   return Return;
}


//  Have DBMS set up result set of Tables.

RETCODE SQL_API SQLTables(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UCHAR FAR *szTableType,
    SWORD     cbTableType)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) ||
            notOk (szTableName,      cbTableName) ||
            notOk (szTableType,      cbTableType)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->Tables ((char *)szTableQualifier,
                                              cbTableQualifier,
                                              (char *)szTableOwner,
                                              cbTableOwner,
                                              (char *)szTableName,
                                              cbTableName,
                                              (char *)szTableType,
                                              cbTableType);
   }
   if (Trace.isSet)
      Trace.Write ("SQLTables(0x%lx,'%s',%d,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szTableQualifier,cbTableQualifier,
                      szTableOwner,cbTableOwner,
                      szTableName,cbTableName,
                      szTableType,cbTableType, Return);

   return Return;
}


//  Have DBMS set up result set of Statistics.


RETCODE SQL_API SQLStatistics(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UWORD     fUnique,
    UWORD     fAccuracy)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) ||
            notOk (szTableName,      cbTableName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else if (fUnique != SQL_INDEX_UNIQUE && fUnique != SQL_INDEX_ALL) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_100, "");
      Return = SQL_ERROR;
   } else if (fAccuracy != SQL_ENSURE && fAccuracy != SQL_QUICK) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_101,"");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->Statistics ((char *)szTableQualifier,
                                                  cbTableQualifier,
                                                  (char *)szTableOwner,
                                                  cbTableOwner,
                                                  (char *)szTableName,
                                                  cbTableName,
                                                  fUnique,
                                                  fAccuracy);
   }
   if (Trace.isSet)
      Trace.Write ("SQLStatistics(0x%lx,'%s',%d,'%s',%d,'%s',%d,%d,%d)=%d\n",
                      hstmt,
                      szTableQualifier,cbTableQualifier,
                      szTableOwner,cbTableOwner,
                      szTableName,cbTableName,
                      fUnique,fAccuracy,Return);
   return Return;
}

//  Have DBMS set up result set of SpecialColumns.

RETCODE SQL_API SQLSpecialColumns(
    HSTMT     hstmt,
    UWORD     fColType,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UWORD     fScope,
    UWORD     fNullable)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) ||
            notOk (szTableName,      cbTableName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->SpecialColumns (fColType,
                                                      (char *)szTableQualifier,
                                                      cbTableQualifier,
                                                      (char *)szTableOwner,
                                                      cbTableOwner,
                                                      (char *)szTableName,
                                                      cbTableName,
                                                      fScope,
                                                      fNullable);
   }
   if (Trace.isSet)
      Trace.Write ("SQLSpecialColumns(0x%lx,%d,'%s',%d,'%s',%d,'%s',%d,%d,%d)=%d\n",
                                           hstmt,
                                           fColType,
                                           (char *)szTableQualifier,
                                           cbTableQualifier,
                                           (char *)szTableOwner,
                                           cbTableOwner,
                                           (char *)szTableName,
                                           cbTableName,
                                           fScope,
                                           fNullable,
                                           Return);
   return Return;
}

//  Have DBMS set up result set of TablePrivileges.
RETCODE SQL_API SQLTablePrivileges(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) ||
            notOk (szTableName,      cbTableName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->TablePrivileges ((char *)szTableQualifier,
                                                       cbTableQualifier,
                                                       (char *)szTableOwner,
                                                       cbTableOwner,
                                                       (char *)szTableName,
                                                       cbTableName);
   }
   if (Trace.isSet)
      Trace.Write ("SQLTablePrivileges(0x%lx,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szTableQualifier,cbTableQualifier,
                      szTableOwner,cbTableOwner,
                      szTableName,cbTableName,
                      Return);
   return Return;
}

//  Have DBMS set up result set of ColumnPrivileges.

RETCODE SQL_API SQLColumnPrivileges(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName,
    UCHAR FAR *szColumnName,
    SWORD     cbColumnName)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) ||
            notOk (szTableName,      cbTableName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->ColumnPrivileges((char *)szTableQualifier,
                                                       cbTableQualifier,
                                                       (char *)szTableOwner,
                                                       cbTableOwner,
                                                       (char *)szTableName,
                                                       cbTableName,
                                                       (char *)szColumnName,
                                                       cbColumnName);
   }
   if (Trace.isSet)
      Trace.Write ("SQLColumnPrivileges(0x%lx,'%s',%d,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szTableQualifier,cbTableQualifier,
                      szTableOwner,cbTableOwner,
                      szTableName,cbTableName,
                      szColumnName,cbColumnName,
                      Return);
   return Return;
}

//  Have DBMS set up result set of PrimaryKeys.

RETCODE SQL_API SQLPrimaryKeys(
    HSTMT     hstmt,
    UCHAR FAR *szTableQualifier,
    SWORD     cbTableQualifier,
    UCHAR FAR *szTableOwner,
    SWORD     cbTableOwner,
    UCHAR FAR *szTableName,
    SWORD     cbTableName)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szTableQualifier, cbTableQualifier) ||
            notOk (szTableOwner,     cbTableOwner) ||
            notOk (szTableName,      cbTableName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->PrimaryKeys ((char *)szTableQualifier,
                                                   cbTableQualifier,
                                                   (char *)szTableOwner,
                                                   cbTableOwner,
                                                   (char *)szTableName,
                                                   cbTableName);
   }
   if (Trace.isSet)
      Trace.Write ("SQLPrimaryKeys(0x%lx,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szTableQualifier,cbTableQualifier,
                      szTableOwner,cbTableOwner,
                      szTableName,cbTableName,
                      Return);
   return Return;
}

//  Have DBMS set up result set of ForeignKeys.

RETCODE SQL_API SQLForeignKeys(
    HSTMT     hstmt,
    UCHAR FAR *szPkTableQualifier,
    SWORD     cbPkTableQualifier,
    UCHAR FAR *szPkTableOwner,
    SWORD     cbPkTableOwner,
    UCHAR FAR *szPkTableName,
    SWORD     cbPkTableName,
    UCHAR FAR *szFkTableQualifier,
    SWORD     cbFkTableQualifier,
    UCHAR FAR *szFkTableOwner,
    SWORD     cbFkTableOwner,
    UCHAR FAR *szFkTableName,
    SWORD     cbFkTableName)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szPkTableQualifier, cbPkTableQualifier) ||
            notOk (szPkTableOwner,     cbPkTableOwner) ||
            notOk (szPkTableName,      cbPkTableName) ||
            notOk (szFkTableQualifier, cbFkTableQualifier) ||
            notOk (szFkTableOwner,     cbFkTableOwner) ||
            notOk (szFkTableName,      cbFkTableName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->ForeignKeys ((char *)szPkTableQualifier,
                                                   cbPkTableQualifier,
                                                   (char *)szPkTableOwner,
                                                   cbPkTableOwner,
                                                   (char *)szPkTableName,
                                                   cbPkTableName,
                                                   (char *)szFkTableQualifier,
                                                   cbFkTableQualifier,
                                                   (char *)szFkTableOwner,
                                                   cbFkTableOwner,
                                                   (char *)szFkTableName,
                                                   cbFkTableName);
   }
   if (Trace.isSet)
      Trace.Write ("SQLForeignKeys(0x%lx,'%s',%d,'%s',%d,'%s',%d,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szPkTableQualifier,cbPkTableQualifier,
                      szPkTableOwner,cbPkTableOwner,
                      szPkTableName,cbPkTableName,
                      szFkTableQualifier,cbFkTableQualifier,
                      szFkTableOwner,cbFkTableOwner,
                      szFkTableName,cbFkTableName,
                      Return);
   return Return;
}

//  Have DBMS set up result set of Procedures.

RETCODE SQL_API SQLProcedures(
    HSTMT     hstmt,
    UCHAR FAR *szProcQualifier,
    SWORD     cbProcQualifier,
    UCHAR FAR *szProcOwner,
    SWORD     cbProcOwner,
    UCHAR FAR *szProcName,
    SWORD     cbProcName)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szProcQualifier, cbProcQualifier) ||
            notOk (szProcOwner,     cbProcOwner) ||
            notOk (szProcName,      cbProcName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->Procedures ((char *)szProcQualifier,
                                                   cbProcQualifier,
                                                   (char *)szProcOwner,
                                                   cbProcOwner,
                                                   (char *)szProcName,
                                                   cbProcName);
   }
   if (Trace.isSet)
      Trace.Write ("SQLProcedures(0x%lx,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szProcQualifier,cbProcQualifier,
                      szProcOwner,cbProcOwner,
                      szProcName,cbProcName,
                      Return);
   return Return;
}

//  Have DBMS set up result set of ProcedureColumns.

RETCODE SQL_API SQLProcedureColumns(
    HSTMT     hstmt,
    UCHAR FAR *szProcQualifier,
    SWORD     cbProcQualifier,
    UCHAR FAR *szProcOwner,
    SWORD     cbProcOwner,
    UCHAR FAR *szProcName,
    SWORD     cbProcName,
    UCHAR FAR *szColumnName,
    SWORD     cbColumnName)
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 || !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szProcQualifier, cbProcQualifier) ||
            notOk (szProcOwner,     cbProcOwner) ||
            notOk (szProcName,      cbProcName) ||
            notOk (szColumnName,    cbColumnName)) {
      ((SqlParser *) hstmt)->PrintError (E_GENERAL_ERROR_090, "");
      Return = SQL_ERROR;
   } else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->ProcedureColumns ((char *)szProcQualifier,
                                                        cbProcQualifier,
                                                        (char *)szProcOwner,
                                                        cbProcOwner,
                                                        (char *)szProcName,
                                                        cbProcName,
                                                        (char *)szColumnName,
                                                        cbColumnName);
   }
   if (Trace.isSet)
      Trace.Write ("SQLProcedureColumns(0x%lx,'%s',%d,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                      hstmt,
                      szProcQualifier,cbProcQualifier,
                      szProcOwner,cbProcOwner,
                      szProcName,cbProcName,
                      szColumnName,cbColumnName,
                      Return);
   return Return;
}
};
