/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef cfield_h
# define cfield_h "$Id: cfield.h 5.0 1999/10/08 10:17:43 picoSoft Exp Marco $"

# include "pobject.h"
# include "sqltype.h"
# include "stmtattr.h"
# include "dberror.h"

class SqlParser;
class DataBase;

class CField : public PObject
{
   PCLASS(CField, PObject)
   long        dummyByteRed;
   AttrCType   CType;
   StmtAttr  * DBAttr;
   StmtAttr    ParamAttr;
   char      * Buffer;
   long        BufferLen;
   long      * ByteRed;
   TIMESTAMP_STRUCT *TimeStamp;
   char *localBuffer;
   unsigned long localBufferLen;
   short ioType;
public: 
   CField (const DataBase &d) : ParamAttr (d, "Dummy", 0) { 
      DBAttr = 0;
      Buffer = 0;
      localBuffer = 0;
      localBufferLen = 0;
      ioType = 0;
   }
   ~CField ();
   void reset();
   void Bind (StmtAttr *a) { DBAttr = a; }
   void SetTimeStamp ();
   void SetParamAttr (DataType t, long i, int d);
   void SetType (AttrCType t, char * b, long len, long *r) {
      CType = t;
      Buffer = b;
      BufferLen = len;
      if (r != 0)
         ByteRed = r;
      else {
         dummyByteRed = len;
         ByteRed = &dummyByteRed;
      }
   }
   void putData (char *b, long len);
   void UnBind () { DBAttr = 0; }
   PBool Binded () { return DBAttr != 0; }
   PBool BufferExists () { return Buffer != 0; }
   Error ToExt (SqlParser *sp, unsigned long numElem = 0);
   Error FromExt (SqlParser *sp);
   StmtAttr & GetParamAttr () { return ParamAttr; }
   PBool isDataAtExec() {
      return *ByteRed == SQL_DATA_AT_EXEC ||
             *ByteRed < SQL_LEN_DATA_AT_EXEC_OFFSET;
   }
   void * getBuffer() { return Buffer; }
   long *getByteRed() {
      return ByteRed;
   }
   void setIOType (short iot) {
      ioType = iot;
   }
   short getIOType () {
      return ioType;
   }
   AttrCType getCType() {
      return CType;
   }
   long getBufferLen() {
      return BufferLen;
   }
};
PLIST(CField);
PITERATOR(CField);
# endif
