/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef conditn_h
# define conditn_h "$Id: conditn.h 5.1 2000/08/22 14:55:11 picoSoft Exp $"

# include "lex.h"
# include "dberror.h"
# include "express.h"
            
class Where;
class SearchIndex;
class SqlParser;

class Condition : public PObject {
friend class Where;
friend class SearchIndex;
friend class SqlParser;
   PCLASS (Condition,PObject)
   SqlParser *parent;
   toknum Operator;
   Expression *left;
   Expression *right;
   SqlParser *subQuery;
   void PrintError (ErrNum e, const PString &submess, int syserr = 0) {
      ::PrintError (0, 0, parent, e, submess, syserr);
   }
public:
   Condition (toknum op, SqlParser *p, SqlParser *subq = 0);
   Condition (toknum op, Token *t, SqlParser *p);
   Condition (toknum op, Expression *a, SqlParser *p);
   void SetRight ( Token *t);
   void SetRight ( Expression *a);
   Error Eval (StmtRel *, PBool &result);
   void Complement ();
   friend void WeighIndex (Where &l);
   toknum getOperator() { return Operator; }
   PBool isAndOr() { return Operator == AND || Operator == OR; }
   PBool isSubQuery() { return subQuery != 0; }
   ~Condition ();
   void toString (PString &result);
   void Debug ();
};

PLIST(Condition);

# endif
