/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
static char rcsid[] = "$Id: connect.cpp 5.4 2001/04/19 09:39:56 picoSoft Exp Administrator $";
# include "database.h"
# include "sqlpars.h"
# define MAXDBDIR 128
# include "trace.h"
# include "sqltype.h"
# include "envirini.h"
# include "environ.h"
extern "C" {
# include <string.h>
# include <ctype.h>
# include <stdlib.h>
# ifdef WIN32
# include <windows.h>
# else
# include <pwd.h>
# include <unistd.h>
# endif

//   CONNECT.C
//
//   SQLC connection functions.
 
# include "picoisam.h"
PBool PTransaction = PFalse;

//   Allocates an environment, connection, statement, or descriptor handles
SQLRETURN SQL_API
SQLAllocHandle (SQLSMALLINT handleType,
                SQLHANDLE inputHandle,
                SQLHANDLE * outputHandlePtr)
{
   SQLRETURN Return;

   switch (handleType) {
   case SQL_HANDLE_ENV:
      Return = SQLAllocEnv (outputHandlePtr);
      break;
   case SQL_HANDLE_DBC:
      Return = SQLAllocConnect (inputHandle, outputHandlePtr);
      break;
   case SQL_HANDLE_STMT:
      Return = SQLAllocStmt (inputHandle, outputHandlePtr);
      break;
   case SQL_HANDLE_DESC:
   default:
      Return = SQL_ERROR;
      break;
   }
   return Return;
}

SQLRETURN SQL_API
SQLFreeHandle (SQLSMALLINT handleType,
                    SQLHANDLE handle)
{
   SQLRETURN Return;

   switch (handleType) {
   case SQL_HANDLE_ENV:
      Return = SQLFreeEnv (handle);
      break;
   case SQL_HANDLE_DBC:
      Return = SQLFreeConnect (handle);
      break;
   case SQL_HANDLE_STMT:
      Return = SQLFreeStmt (handle, SQL_DROP);
      break;
   case SQL_HANDLE_DESC:
   default:
      Return = SQL_ERROR;
      break;
   }
   return Return;
}

// Sets attributes that govern aspects of environments

SQLRETURN SQL_API
SQLSetEnvAttr(SQLHENV environmentHandle,
              SQLINTEGER attribute,
              SQLPOINTER valuePtr,
              SQLINTEGER stringLength)
{
   SQLRETURN Return = SQL_SUCCESS;
   Environment *env = (Environment *)environmentHandle;

   if (env == 0 || !env->IsA(Environment::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      switch (attribute) {
      case SQL_ATTR_ODBC_VERSION:
         Return = env->setVersion ((long) valuePtr);
         break;
      case SQL_ATTR_OUTPUT_NTS:
         if ((long) valuePtr != SQL_TRUE) {
            PrintError (env, 0, 0, E_GENERAL_ERROR_C00, "");
            Return = SQL_ERROR;
         }
         break;
      case SQL_ATTR_CP_MATCH:
      case SQL_ATTR_CONNECTION_POOLING:
      default:
         PrintError (env, 0, 0, E_GENERAL_ERROR_C00, "");
         Return = SQL_ERROR;
         break;
      }
   }
   return Return;
}


// Returns the current setting of an environment attribute

SQLRETURN SQL_API
SQLGetEnvAttr(SQLHENV environmentHandle,
              SQLINTEGER attribute,
              SQLPOINTER valuePtr,
              SQLINTEGER bufferLength,
              SQLINTEGER *stringLengthPtr)
{
   SQLRETURN Return = SQL_SUCCESS;
   Environment *env = (Environment *)environmentHandle;

   if (env == 0 || !env->IsA(Environment::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      switch (attribute) {
      case SQL_ATTR_ODBC_VERSION:
         valuePtr = (void*) env->getVersion ();
         break;
      case SQL_ATTR_OUTPUT_NTS:
         valuePtr = (void*) SQL_TRUE;
         break;
      case SQL_ATTR_CP_MATCH:
      case SQL_ATTR_CONNECTION_POOLING:
      default:
         PrintError (env, 0, 0, E_GENERAL_ERROR_C00, "");
         Return = SQL_ERROR;
         break;
      }
   }
   return Return;
}

//   Allocate an environment (ENV) block.

RETCODE SQL_API SQLAllocEnv(
   HENV FAR * phenv)
{
   Environment *env = new Environment();
   *phenv = env;
   return SQL_SUCCESS;
}

//   Allocate a DBC block.

RETCODE   SQL_API SQLAllocConnect(
   HENV   henv,
   HDBC FAR * phdbc)
{
   SQLRETURN Return = SQL_SUCCESS;
   DataBase *db;
   Environment *env = (Environment *)henv;

   if (env == 0 || !env->IsA(Environment::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      db = new DataBase(*env);
      *phdbc = (HDBC) db;
   }
   return SQL_SUCCESS;
}

static PBool
checkSysUser(char *user, char *password, char * picoUsr, char *picoPwd)
{
   PBool Return = PFalse;
#ifdef WIN32
/*
SUMMARY
=======
 
Some new security API calls were added to Win32 in Windows NT version 3.51.
Two of these new calls, LogonUser() and CreateProcessAsUser(), require that
the calling process have certain privileges. If the calling process is a
service running in the Local System account, it will already have these
privileges. Otherwise, the required privileges can be added to an account
by using the "User Rights Policy" dialog box. Run the User Manager and
choose User Rights from the Policies menu to see the dialog box.
 
NOTE: You must select the "Show Advanced User Rights" check box to see
the privileges mentioned in this article.
 
MORE INFORMATION
================
 
The Win32 API reference documents the required privileges, but it gives
their internal string names instead of the display names. The "User Rights
Policy" dialog box displays the privileges using the display names.
 
The following table shows the display names associated with the internal
string names:
 
   Privilege          Display Name
   ------------------------------------------------------
   SeTcbPrivilege     Act as part of the operating system
   SeAssignPrimary    Replace a process level token
   SeIncreaseQuota    Increase quotas

*/
   HANDLE hToken;
                  
   if ( LogonUser(user,
                  0, /* string that specifies the domain or server */
                  password,
                  LOGON32_LOGON_INTERACTIVE,
                  LOGON32_PROVIDER_DEFAULT,
                  &hToken) &&  ImpersonateLoggedOnUser(hToken))
      Return = PTrue;
#else
   struct passwd *pwent = getpwnam (user);

   if ((pwent =  getpwnam (user)))
      if (!strcmp (user, picoUsr) && !strcmp (password, picoPwd) &&
          setgid (pwent->pw_gid) == 0 && setuid (pwent->pw_uid) == 0)
         Return = PTrue;
#endif
   return Return;
}

static inline PBool
notOk (unsigned char * sz, SWORD cb) {
   return sz != 0 && cb < 0 && cb != SQL_NTS;
}

RETCODE SQL_API SQLConnect(
   HDBC   hdbc,
   UCHAR FAR *szDSN,
   SWORD   cbDSN,
   UCHAR FAR *szUID,
   SWORD   cbUID,
   UCHAR FAR *szAuthStr,
   SWORD   cbAuthStr)
{
   static char szDbDir[MAXDBDIR + 1];
   char *nomeDB;
   char *nomeUSR;  
   char *nomePWD;  
   char traceSet[3 + 1]; 
   RETCODE Return = SQL_SUCCESS;
   EnvirIni odbcEnv;

   if (hdbc == 0 || !((PObject *) hdbc)->IsA (DataBase::Class))
      Return = SQL_INVALID_HANDLE;
   else if (notOk (szDSN, cbDSN) ||
            notOk (szUID, cbUID) ||
            notOk (szAuthStr, cbAuthStr)) {
      ((DataBase *) hdbc)->PrintError (E_GENERAL_ERROR_090,"");
      Return = SQL_ERROR;
   } else {
      ((DataBase *) hdbc)->DelError();
      cbDSN = cbDSN < 0 ? (szDSN?strlen((char*)szDSN):0) : cbDSN;
      cbUID = cbUID < 0 ? (szUID?strlen((char*)szUID):0) : cbUID;
      cbAuthStr = cbAuthStr<0?(szAuthStr?strlen((char*)szAuthStr):0):cbAuthStr;
      nomeDB = new char[cbDSN + 1];
      nomeUSR = new char[cbUID + 1];
      nomePWD = new char[cbAuthStr + 1];

      nomeDB[cbDSN] = 0;
      nomeUSR[cbUID] = 0;
      nomePWD[cbAuthStr] = 0;

      if (cbDSN)
         strncpy (nomeDB, (char*)szDSN, cbDSN);
      if (cbUID)
         strncpy (nomeUSR, (char*)szUID, cbUID);
      if (cbAuthStr)
         strncpy (nomePWD, (char*)szAuthStr, cbAuthStr);

      if (odbcEnv.Read((char *)nomeDB,"PLogFile",szDbDir,sizeof(szDbDir)) > 0) {
         pIslogopen (szDbDir);
         PTransaction = PTrue;
      } else if (odbcEnv.Read((char *)nomeDB, "PTransaction",
                                                szDbDir, sizeof(szDbDir)) > 0) {
         if (szDbDir[0] == 'Y')
            PTransaction = PTrue;
      }
      if (odbcEnv.Read(nomeDB, "SuspensiveLock",szDbDir,sizeof(szDbDir)) != 0) {
         if (szDbDir[0] == 'Y')
            ((DataBase *) hdbc)->setWait (ISWAIT);
      }
      if (odbcEnv.Read(nomeDB, "CharSet", szDbDir, sizeof(szDbDir)) != 0) {
         char *pnt = szDbDir;
         while (*pnt)
            *pnt++ = toupper(*pnt);
         if (!strcmp (szDbDir, "OEM") || !strcmp (szDbDir, "2"))
            ((DataBase *) hdbc)->setOemCharSet (PTrue);
      }
      if (odbcEnv.Read(nomeDB, "MaxOpenCache", szDbDir, sizeof(szDbDir)) != 0) {
         ((DataBase *) hdbc)->setMaxOpenCache (atoi (szDbDir));
      }

      if (odbcEnv.Read(nomeDB,"DataDirectory",szDbDir,sizeof(szDbDir)) == 0 &&
          odbcEnv.Read("Default","DataDirectory",szDbDir,sizeof(szDbDir)) ==0){
         ((DataBase *) hdbc)->PrintError (E_CONN_EXCEPT_001,
                      "Data source not found and no default driver specified");
         Return = SQL_ERROR;
      } else {
         char sysUser[2];
         char *user = new char[cbUID + 1];
         char *passwd = new char[cbAuthStr + 1];
         if (odbcEnv.Read(nomeDB, "User",  user, cbUID + 1) == 0)
            user[0] = '\0';
         else
            user[cbUID] = '\0';
         if (odbcEnv.Read(nomeDB,"Password",passwd,cbAuthStr + 1)==0)
            passwd[0] = '\0';
         else
            passwd[cbAuthStr] = '\0';
         if (odbcEnv.Read(nomeDB, "SysUser", sysUser, sizeof(sysUser)) > 0 &&
                                                            sysUser[0] == 'Y') {
            if (!checkSysUser (nomeUSR, nomePWD, user, passwd)) {
               ((DataBase *) hdbc)->PrintError (E_CONN_EXCEPT_001,
                            "Invalid user/password");
               Return = SQL_ERROR;
            }
         } else {
            if ((user[0] != 0 && (cbUID != strlen(user) ||
                     memcmp(user, szUID, cbUID)) != 0) ||
                   (passwd[0]!=0 && (cbAuthStr!=strlen(passwd) ||
                     memcmp(passwd,szAuthStr,cbAuthStr)) != 0)) {
               ((DataBase *) hdbc)->PrintError (E_CONN_EXCEPT_001,
                            "Invalid user/password");
               Return = SQL_ERROR;
            }
         }
         delete passwd;
         delete user;
      }

      if (Return != SQL_ERROR) {
         ((DataBase *) hdbc)->setNome(nomeDB);
         ((DataBase *) hdbc)->setUser (nomeUSR);
         Return = ((DataBase *) hdbc)->Connect (szDbDir);
      }

      if (odbcEnv.Read((char *)nomeDB, "PicoOdbcTrace",
                       traceSet, sizeof(traceSet)) > 0 && traceSet[0] == 'Y') {
         Trace.isSet = 1;
# ifdef MSDOS
         Trace.Open("\\PICOODBC.LO0");
# else
         Trace.Open("/tmp/PICOODBC.LO0");
# endif // MSDOS
         Trace.Write ("SQLConnect(0x%lx,'%s',%d,'%s',%d,'%s',%d)=%d\n",
                       hdbc, nomeDB, cbDSN, nomeUSR, cbUID,
                                  nomePWD, cbAuthStr, Return);
      }
      delete nomePWD;
      delete nomeUSR;
      delete nomeDB;
   }

   return Return; 
}

RETCODE SQL_API SQLDisconnect(
   HDBC   hdbc)
{
   RETCODE Return = SQL_SUCCESS;

   if (hdbc == 0 ||
       !((PObject *) hdbc)->IsA (DataBase::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      ((DataBase *) hdbc)->Clear();
   }
   if (Trace.isSet) {
      Trace.Write ("SQLDisconnect(0x%lx)=%d\n",hdbc, Return);
      Trace.Close();
   }
   return Return;
}

RETCODE   SQL_API SQLFreeConnect(
   HDBC   hdbc)
{
   RETCODE Return = SQL_SUCCESS;

   if (hdbc == 0 ||
       !((PObject *) hdbc)->IsA (DataBase::Class))
      Return = SQL_INVALID_HANDLE;
   else
      delete (DataBase *) hdbc;

   return Return;
}
 

RETCODE SQL_API SQLFreeEnv(
   HENV   henv)
{ 
   RETCODE Return = SQL_SUCCESS;

   if (henv == 0 ||
       !((PObject *) henv)->IsA (Environment::Class))
      Return = SQL_INVALID_HANDLE;
   else
      delete (Environment *) henv;

   return Return;
}

/*
RETCODE   SQL_API SQLBrowseConnect(
   HDBC   hdbc,
   UCHAR FAR *szConnStrIn,
   SWORD   cbConnStrIn,
   UCHAR FAR *szConnStrOut,
   SWORD   cbConnStrOutMax,
   SWORD FAR *pcbConnStrOut)
{   
   if (Trace.isSet)
      Trace.Write ("SQLBrowseConnect\n"); 
    return SQL_SUCCESS;
}
*/
};
