/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef database_h
# define database_h "$Id: database.h 5.4 2001/04/19 09:42:14 picoSoft Exp Marco $"

# include <string.h>
# include "pbool.h"
# include "stmtrel.h"
# include "relview.h"
# include "pkeybjct.h"
# include "environ.h"

struct OpenFiles {
   accessType fsId;
   Relation *rel;
};
PLIST(OpenFiles);

class SqlParser;
PLIST(SqlParser);

class DataBase : public PObject
{
   PCLASS(DataBase, PObject)

   PString        Nome;
   PString        User;
   short          NumAliasView;
   RelObjectList  RelBases;
   RelObjectList  ViewBases;
   RelationList   Relations;
   RelViewList    Views;      
   int            RelIdDef;
   short          Flag;
   PStringList    FilePrefix;
   PStringKeyObjectList Replace;  
   enum {
      NOT_CONNECTED,
      CONNECTED
   } internalStatus;
   
   OpenFilesList openFiles;

   PBool StringsNotNull;
   Error CheckDatadict(const char * dirPath);
   void SelfSetAttrTables(Relation *r);
   void SelfSetAttrFields(Relation *r);
   void SelfSetAttrViews(Relation *r);
   StmtRel       *DatadictTables;
   StmtRel       *DatadictFields;
   StmtRel       *DatadictViews;
   int waitLock;
   long startDate;
// SQLSetConnectOption
   unsigned long AccessMode;
   unsigned long QuietMode;
   Environment &env;
                                                           
   PBool BuildPath (PString &FilePath);
   void ReplaceChar (char *string);
   void FillReplace (char *string);
   void FillFilePrefix (char *string);
   void FileClose (Relation *r, accessType &fd) const;
   void FileUnlock (Relation *r, accessType fd) const;
   PBool Exists (const PString &FsDirName,
                PString &FsDataName,
                RelBase *r,
                accessType *fd);
   PBool OemCharSet;
   PBool Autocommit;
   PBool InTransact;
   int MaxOpenCache;
   Error writeTable (const PString &name, double type, PBool checkOpt);
   Error readView (ViewBase *vb, const PString &name);
public:
   DataBase(Environment &env);
   ~DataBase ();
   SqlParserList  StmtList;
   void Clear();
   PBool UnloadOpenCache();
   void UnloadOpenCache(Relation *r);
   Error Connect (const char * fullPath);
   void DelError () {
      ::DelError (0, this, 0);
   }  
   Error LookError () {
      return ::LookError (0, this, 0);
   }
   void setNome(char *s) {
      Nome = s;
   } 
   const PString & getNome() {
      return Nome;
   }
   void setUser(char *s) {
      User = s;
   } 
   const PString & getUser() {
      return User;
   }
   PBool isStmt (SqlParser *);
   SqlParser * getHstmtByCursorName(const PString &name);
   void PrintError (ErrNum e, const PString & submess, int syserr = 0) {
      ::PrintError (0, this, 0, e, submess, syserr);
   }
   PBool isStringsNotNull () const { return StringsNotNull; }
   void setMaxOpenCache (int i) { MaxOpenCache = i; }
   void setOemCharSet(PBool c) { OemCharSet = c; }
   PBool IsIntl() const { return OemCharSet; }
   void IntlFromServer (char *src, char *dest, int len) const {
# ifdef MSDOS
      if (OemCharSet)
# ifdef WIN32
         OemToCharBuff (src, dest, (UINT) len);
# else
         OemToAnsiBuff (src, dest, (UINT) len);
# endif
      else
# endif
         memcpy (dest, src, len);
   }
   void IntlToServer (char *src, char *dest, int len) const {
# ifdef MSDOS
      if (OemCharSet)
# ifdef WIN32
         CharToOemBuff (src, dest, (UINT) len);
# else
         AnsiToOemBuff (src, dest, (UINT) len);
# endif
      else
# endif
         memcpy (dest, src, len);
   }
   PBool FileOpenExists (PString &FsDirName,
                         PString &FsDataName,
                        RelBase *r,
                        accessType *fd);
   void Close(Relation *r, accessType &fd);
   Error CreateRelation (SqlParser *p, const PString &name, AttributeList &al);
   Error CreateView (SqlParser *p, const PString &name,
                     const char *text, PBool checkOpt);
   Error DropRelation (SqlParser *p, Relation *rd);
   Error DropView (SqlParser *p, RelObject *rd);
   Error RenameRelation (SqlParser *p, char *oldName, Relation *rd);
   int wait() { return waitLock; }
   void setWait (int w) { waitLock = w; }
   long GetStartDate() const { return startDate; }
// SQLSetConnectOption
   unsigned long GetAccessMode() { return AccessMode; }
   void SetAccessMode(unsigned long m) { AccessMode = m; }
   unsigned long GetQuietMode() { return QuietMode; }
   void SetQuietMode(unsigned long m) { QuietMode = m; }
   RelObject *GetRelObject(const PString &name);
   Relation *GetRelation(const PString &name, SqlParser *p);
   RelView *GetRelView(const PString &name);
   void RemoveRelation(Relation *rel);
   RelObjectIterator getRelBases() {
      RelObjectIterator Return(RelBases);
      return Return;
   }
   RelObjectIterator getRelViews() {
      RelObjectIterator Return(Views);
      return Return;
   }
   RelObjectIterator getBaseViews() {
      RelObjectIterator Return(ViewBases);
      return Return;
   }
   void SetAutoCommit (PBool onoff);
   PBool IsAutocommit () { return Autocommit; }
   Error Transact (SqlParser *stmt);
   Error Commit ();
   Error Rollback ();
   void addView (RelView *r) {
      Views.AddItem (r);
   }
   Environment *getEnvironment() { return &env; }
   void addRelBase (RelBase *rb) {
      RelBases.AddItem (rb);
   }
};

PLIST(DataBase);

# endif
