/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef dberror_h
# define dberror_h "$Id: dberror.h 5.0 1999/10/08 10:17:43 picoSoft Exp $"
# include "pstring.h"
# include "plist.h"
# include "sqltype.h"

typedef RETCODE Error;
class DataBase;
class SqlParser;
class Environment;
# define ERRNOINVALID 127
# define FIRST_ERROR_CODE 500

typedef enum {
   E_UNKNOWN_ERROR = 0,
   E_WARNING_000,
   E_WARNING_004,
   E_WARNING_S02,
   E_DYN_SQL_002,
   E_DYN_SQL_009,
   E_CONN_EXCEPT_001,
   E_DATA_EXCEPT_003,
   E_DATA_EXCEPT_018,
   E_CARD_VIOL_000,
   E_CARD_VIOL_S01,
   E_INTEGRITY_VIOL_000,
   E_SYNTAX_ERROR_000,
   E_SYNTAX_ERROR_S01,
   E_SYNTAX_ERROR_S02,
   E_SYNTAX_ERROR_S22,
   E_GENERAL_ERROR_000,
   E_GENERAL_ERROR_001,
   E_GENERAL_ERROR_003,
   E_GENERAL_ERROR_007,
   E_GENERAL_ERROR_010,
   E_GENERAL_ERROR_011,
   E_GENERAL_ERROR_024,
   E_GENERAL_ERROR_090,
   E_GENERAL_ERROR_091,
   E_GENERAL_ERROR_092,
   E_GENERAL_ERROR_096,
   E_GENERAL_ERROR_100,
   E_GENERAL_ERROR_101,
   E_GENERAL_ERROR_106,
   E_GENERAL_ERROR_110,
   E_GENERAL_ERROR_C00,
   E_INTERNAL_ERROR_001,
   E_INTERNAL_ERROR_002,
   E_INTERNAL_ERROR_007
} ErrNum;

typedef struct tErrDesc {
   ErrNum num;
   const char * stdDesc;
   const char * Odbc2SqlState;
   const char * Odbc3SqlState;
} ErrDesc;

class DBError : public PObject {
   PCLASS(DBError, PObject)
   ErrDesc *error;
   const char * sqlstate;
   PString mess;
   long systemErr;
   Environment * henv;
   DataBase * hdbc;
   SqlParser * hstmt;
public:
   DBError (Environment * hv, DataBase * hd, SqlParser *sp, ErrNum err,
            const PString &desc, long sErr);
   const char * getState () { return sqlstate; }
   long GetNative () { return (long) -(error->num + FIRST_ERROR_CODE); }
   const PString & getMess() { return mess; }
   PBool isWarning () { return sqlstate[0] == '0' && sqlstate[1] =='1'; }
   friend RETCODE LookError (Environment * hv, DataBase * hd, SqlParser * sp);
   friend RETCODE GetError (Environment * hv, DataBase * hd, SqlParser *sp,
                            char * outSqlState, long & outNativeError,
                            char * outErrorMsg, int cbErrorMsgMax,
                            short & pcbErrorMsg);
   friend void DelError (Environment * hv, DataBase * hd, SqlParser * sp);
   friend void MoveStmtError (SqlParser * dst, SqlParser * src);
};

PLIST (DBError);

void PrintError (Environment * hv, DataBase * hd, SqlParser * sp, ErrNum err,
                 const PString &addMess, int syserr = 0);



# endif
