/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef environ_h
# define environ_h "$Id: environ.h 5.0 1999/10/08 10:17:43 picoSoft Exp $"
# include "sqltype.h"
# include "dberror.h"
# include "plist.h"
class DataBase;

class Environment : public PObject
{
   PCLASS(Environment, PObject)
   unsigned long version;
   PList databases;
   void PrintError (ErrNum e, const PString &submess, int syserr = 0) {
      ::PrintError (this, 0, 0, e, submess, syserr);
   }
public:
   Environment() {
      version = SQL_OV_ODBC2;
   }
   Error setVersion (unsigned long v) {
      Error Return;

      if (v == SQL_OV_ODBC2 || v == SQL_OV_ODBC3) {
         if (databases.GetItemNum() == 0) {
            version = v;
            Return = SQL_SUCCESS;
         } else {
            PrintError (E_GENERAL_ERROR_011, "");
            Return = SQL_ERROR;
         }
      } else {
         PrintError (E_GENERAL_ERROR_024, "");
         Return = SQL_ERROR;
      }
      return Return;
   }
   unsigned long getVersion () {
      return version;
   }
   void addDataBase (DataBase *d) {
      databases.AddItem((PObject *) d);
   }
   void deleteDataBase(DataBase *d) {
      for (PObject *o = databases.GetFirst(); o; )
         if (o == (PObject *) d) {
            o = databases.DeleteCurrent();
            break;
         } else
            o = databases.GetNext();
   }
};

# endif
