/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include "database.h"
# include "sqlpars.h"
# include "trace.h"
# include "sqltype.h"
static char rcsid[] = "$Id: execute.cpp 5.0 1999/10/08 10:17:43 picoSoft Exp $";
extern "C" {

//  Execute a prepared SQL statement

RETCODE SQL_API SQLExecute(
    HSTMT   hstmt)          // statement to execute.
{
   RETCODE Return = SQL_SUCCESS;

   if (hstmt == 0 ||
       !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      ((SqlParser *) hstmt)->DelError();
      Return = ((SqlParser *) hstmt)->Exec ();
   }
   if (Trace.isSet)
      Trace.Write ( "SQLExecute(0x%lx)=%d\n",
                      hstmt,Return);
   return Return;
}

//  -   -   -   -   -   -   -   -   -

//  Performs the equivalent of SQLPrepare, followed by SQLExecute.

RETCODE SQL_API SQLExecDirect(
    HSTMT   hstmt,
    UCHAR FAR *szSqlStr,
    SDWORD  cbSqlStr)
{
   RETCODE Return = SQL_SUCCESS;


   if (hstmt == 0 ||
       !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      if (cbSqlStr < 0 && cbSqlStr != SQL_NTS) {
         PrintError (0, 0, (SqlParser *) (hstmt), E_GENERAL_ERROR_090, "");
         Return = SQL_ERROR;
      } else {
         ((SqlParser *) hstmt)->DelError();
         Return = ((SqlParser *) hstmt)->Parse ((char *)szSqlStr,
                                                cbSqlStr);
         if (Return == SQL_SUCCESS || Return == SQL_SUCCESS_WITH_INFO)
            Return = ((SqlParser *) hstmt)->Exec ();
      }
   } 
   if (Trace.isSet) {
      Trace.Write ("SQLExecDirect(0x%lx,'", hstmt);
      Trace.WriteNoFmt ((char *)szSqlStr);
      Trace.Write ("',%ld)=%d\n",cbSqlStr,Return); 
   }

   return Return;
}

//  Returns the SQL string as modified by the driver.
/*
RETCODE SQL_API SQLNativeSql(
    HSTMT   hstmt,
    UCHAR FAR *szSqlStrIn,
    SDWORD  cbSqlStrIn,
    UCHAR FAR *szSqlStr,
    SDWORD  cbSqlStrMax,
    SDWORD FAR *pcbSqlStr)
{
    RETCODE Return = SQL_SUCCESS;
   if (Trace.isSet)
      Trace.Write ( "SQLNative Sql(0x%lx,'%s',%ld,'%s',%ld,%ld)=%d\n",
                      hstmt,
                      szSqlStrIn,cbSqlStrIn,
                      szSqlStr,cbSqlStrMax,*pcbSqlStr,Return);
    return Return;
}
*/
//  -   -   -   -   -   -   -   -   -

//  Supplies parameter data at execution time.  Used in conjuction with
//  SQLPutData.

RETCODE SQL_API SQLParamData(
   HSTMT   hstmt,
   PTR FAR *prgbValue)
{ 
   RETCODE Return = SQL_SUCCESS;
   if (hstmt == 0 ||
       !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      Return = ((SqlParser *) hstmt)->ParamData (prgbValue);
   }
   if (Trace.isSet)
      Trace.Write ( "SQLParamData Sql(0x%lx,)=%d\n",
                      hstmt,Return);
   
    return Return;
}

//  -   -   -   -   -   -   -   -   -

//  Supplies parameter data at execution time.  Used in conjunction with
//  SQLParamData.

RETCODE SQL_API SQLPutData(
   HSTMT   hstmt,
   PTR rgbValue,
   SDWORD  cbValue)
{   
   RETCODE Return = SQL_SUCCESS;
   if (hstmt == 0 ||
       !((PObject *) hstmt)->IsA (SqlParser::Class))
      Return = SQL_INVALID_HANDLE;
   else {
      Return = ((SqlParser *) hstmt)->PutData (rgbValue, cbValue);
   }
    if (Trace.isSet)
       Trace.Write ( "SQLPutData Sql(0x%lx,%d,%ld)=%d\n",
                      hstmt,
                      rgbValue,cbValue,Return);
    return Return;
}

//  -   -   -   -   -   -   -   -   -

RETCODE SQL_API SQLCancel(
    HSTMT   hstmt)      // Statement to cancel.
{  
   RETCODE Return = SQLFreeStmt (hstmt, SQL_CLOSE);
   if (Trace.isSet)
      Trace.Write ( "SQLCancel Sql(0x%lx)=%d\n",
                      hstmt,Return);
    return Return;
}

//  -   -   -   -   -   -   -   -   -

RETCODE SQL_API SQLTransact(HENV henv, HDBC hdbc, UWORD fType)
{
   RETCODE Return = SQL_SUCCESS;

   if (hdbc == 0 ||
       !((PObject *) hdbc)->IsA (DataBase::Class))
      Return = SQL_INVALID_HANDLE;
   else
      switch (fType) {
      case SQL_COMMIT:
         Return = ((DataBase *) hdbc)->Commit();
         break;
      case SQL_ROLLBACK:
         Return = ((DataBase *) hdbc)->Rollback();
         break;
      default:
         ((DataBase *) hdbc)->PrintError (E_GENERAL_ERROR_C00, "");
         Return = SQL_ERROR;
         break;
      }
   return Return;      
}

};
