/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
static char rcsid[] = "$Id: like.c 5.0 1999/10/08 10:17:43 picoSoft Exp $";
# include <string.h>
# include <stdio.h>

int
RecurLike (const char * str, const char * match,
           const char *endStr, const char * matchEnd)
{
   for ( ; match <= matchEnd && str <= endStr; str++)
      switch (*match) {
      case '%':
         for ( match++; match <= matchEnd && *match == '%'; match++)
            ;
         if (match >= matchEnd)
            return 1;
         for ( ;str <= endStr; str++)
            if (RecurLike (str, match, endStr, matchEnd) != 0)
               return 1;
         break;
      case '_':
         match++;
         break;
      case '\\':
         match++;
         if (match > matchEnd)
            break;
      default:
         if (*match != *str)
            return 0;
         else
            match++;
      }
   for ( ; match <= matchEnd && *match == '%'; match++)
      ;

   if (match > matchEnd && str > endStr)
      return 1;
   else
      return 0;
}

int
Like (const char *str, const char *match, int lenStr, int matchLen)
{
   const char *matchEnd;
   const char *endStr;

   for (matchEnd = match + matchLen - 1;
        matchEnd > match && *matchEnd == ' '; matchEnd--)
      ;
   for (endStr = str + lenStr - 1;
        endStr > str && *endStr == ' '; endStr--)
      ;
   return RecurLike (str, match, endStr, matchEnd);
}
