/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include "sqlpars.h"
# include "picocall.h"

static char rcsid[] = "$Id$";
extern "C" {
extern struct CallTable Calls[];
}
extern int Like (const char *, const char *, int, int);
extern int Int2OdbcType (int t, SignType s, DateTime d);

static int
getCallIndex (const char *dbName, const char *procName)
{
   register int Return;
   for (Return = 0; Calls[Return].procName; Return++)
      if (Like (procName, Calls[Return].procName,
                strlen(procName), strlen( Calls[Return].procName)) &&
          Like (dbName, Calls[Return].dbName,
                strlen(dbName), strlen (Calls[Return].dbName)))
         return Return;
   return -1;
}

Error
SqlParser::parseCall (Lex &l)
{
   Error Return = SQL_SUCCESS;
   PBool braces = PFalse;
   Expression *ex;
   int nArgs = 0;
   Token *t1;
   Token *t = l.GetToken ();

   if (t && t->token == '{') {
      braces = PTrue;
      t = l.GetToken ();
   }
   hasReturn = PFalse;
   if (t && t->token == '?' && (t1 = l.GetToken ()) && t1->token == '=') {
      l.UngetToken();
      l.UngetToken();
      Selected.AddItem (new Expression (*this, l,
                        (Expression::Method)(&SqlParser::GetTableName),PFalse));
      hasReturn = PTrue;
      l.GetToken ();
      t = l.GetToken ();
   }
   if (t && t->token == CALL && (t1 = l.GetToken()) && t1->token == USER_NAME &&
       (t = l.GetToken()) && t->token == '(') {
      callName = t1->word;
      while ((t = l.GetToken()) && t->token != ')') {
         l.UngetToken();
         ex = new Expression (*this, l,
                              (Expression::Method)(&SqlParser::GetTableName),
                              PFalse);
         if (ex->isOk()) {
            Selected.AddItem(ex);
            nArgs++;
         } else {
            Return = SQL_ERROR;
            break;
         }
         if (!(t = l.GetToken()) || (t->token != ',' && t->token != ')')) {
            PrintError (E_SYNTAX_ERROR_000, "Invalid CALL syntax near <" +
                                             t->word + ">");
            Return = SQL_ERROR;
            break;
         }
      }
      if (braces && Return == SQL_SUCCESS) {
         if (!(t = l.GetToken()) || t->token != '}') {
            PrintError (E_SYNTAX_ERROR_000, "Missing ending <}>");
            Return = SQL_ERROR;
         }
      }
      if (Return == SQL_SUCCESS &&
          (callIndex = getCallIndex (DB->getNome().gets(),callName.gets()))<0){
         PrintError (E_SYNTAX_ERROR_S02, "Unknown CALL  <" + callName + ">");
         Return = SQL_ERROR;
      } else if (Calls[callIndex].numArgs >= 0 &&
                 Calls[callIndex].numArgs != nArgs) {
         PrintError (E_DYN_SQL_002, "Invalid number of arguments, expected " +
                     ToPString(Calls[callIndex].numArgs));
         Return = SQL_ERROR;
      } else if (Calls[callIndex].return_type == 0 && hasReturn) {
         PrintError (E_DYN_SQL_002, "Procedure has not return value");
         Return = SQL_ERROR;
      } else if (Calls[callIndex].return_type > 0 && !hasReturn) {
         PrintError (E_DYN_SQL_002, "Procedure needs return value");
         Return = SQL_ERROR;
      } else if (callStmt == 0) {
         callStmt = new SqlParser(DB);
      }
   } else {
      PrintError (E_SYNTAX_ERROR_000, "Invalid CALL syntax near the beginning");
      Return = SQL_ERROR;
   }

   return Return;
}

Error
SqlParser::ExecCall ()
{
   Error Return = SQL_SUCCESS; 
   CField *cf;
   Expression *ex;
   CFieldIterator cfI (Params);
   ExpressionIterator exI (Selected);
   int i;
   int nArgs = Selected.GetItemNum();
   int cntArgs = 0;
   Argument *args = new Argument[nArgs + 1];
   Argument *rc = 0;
   long *srloip = new long[nArgs + 1];
   Env callEnv;
   Attribute *a;
   StmtAttr *sa1, *sa2;

   ClearExec ();

   callStmt->SetMaxRows (GetMaxRows());
   callStmt->setRowSetSize (getRowSetSize ());

   callEnv.hstmt = callStmt;
   callEnv.userName = DB->getUser().gets();
   callEnv.dbName = DB->getNome().gets();
   callEnv.procName = callName.gets();
   memset (callEnv.exceptionMsg, '\0', sizeof (callEnv.exceptionMsg));
   if (hasReturn) {
      rc = new Argument;
      sa1 = (*exI++)->getValue();
      a = sa1->getAttr();
      cf = *cfI;
      rc->ioType = cf->getIOType();
      rc->cType = cf->getCType();
      rc->sqlType = Int2OdbcType (a->GetType(),a->GetSign(),a->getDateType());
      rc->columnSize = a->GetLen();
      rc->decimalDigits = a->GetDecimal();
      rc->valuePtr = sa1->GetBuffer();
      rc->valueLen = cf->getBufferLen();
      rc->strLenOrIndPtr = cf->getByteRed();
   }
   for (i = 0; *exI; i++, exI++) {
      sa1 = (*exI)->getValue();
      a = sa1->getAttr();
      ex = *exI; /* XXX */
      for (cfI.reset(); (cf = *cfI); cfI++) {
         if ((sa2 = &cf->GetParamAttr()) == sa1)
            break;
      }
      if (cf == 0) {
         args[i].ioType = SQL_PARAM_INPUT;
         if (a->GetType() == T_DOUBLE) {
            args[i].cType = SQL_C_DOUBLE;
         } else {
            args[i].cType = SQL_C_CHAR;
         }
         args[i].sqlType = Int2OdbcType (a->GetType(),a->GetSign(),
                                                      a->getDateType());
         args[i].columnSize = a->GetLen();
         args[i].decimalDigits = a->GetDecimal();
         args[i].valuePtr = sa1->GetBuffer();
         args[i].valueLen = srloip[i] = a->getFldSize();
         args[i].strLenOrIndPtr = &srloip[i];
      } else {
         args[i].ioType = cf->getIOType();
         args[i].cType = cf->getCType();
         args[i].sqlType = Int2OdbcType (a->GetType(),a->GetSign(),
                                                      a->getDateType());
         args[i].columnSize = a->GetLen();
         args[i].decimalDigits = a->GetDecimal();
         args[i].valuePtr = sa1->GetBuffer();
         args[i].valueLen = cf->getBufferLen();
         args[i].strLenOrIndPtr = cf->getByteRed();
      }
   }
   Return = (RETCODE)(*Calls[callIndex].call)(&callEnv, args, i, rc);
   if (Return == SQL_ERROR) {
      MoveStmtError (this, callStmt);
      if (callEnv.exceptionMsg[0])
         PrintError (E_GENERAL_ERROR_000, callEnv.exceptionMsg);
   }

   if (rc)
      delete rc;
   delete srloip;
   delete args;
   return Return;
}
