/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef relview_h
# define relview_h "$Id: relview.h 5.1 2001/03/14 11:28:29 picoSoft Exp $"
# include "relobjec.h"
# include "token.h"
# include "lex.h"
# include "pkeybjct.h"
# include "attribut.h"

class AttrView : public PObject {
   PCLASS(AttrView, PObject)
   PString name;
   TokenList value;
   Attribute attr;
public:
   AttrView (const PString &n, Lex &l, Attribute &a): attr(a) {
      name = n;
      l.Rewind();
      for (Token *t = l.GetToken(); t; t = l.GetToken()) {
         value.AddItem (new Token (*t));
      }
   }
   TokenIterator getValue () {
      return TokenIterator(value);
   }
   ~AttrView () {
      for (Token *t = value.GetFirst(); t; t = value.DeleteCurrent())
         delete t;
   }
   const PString &getName () { return name; }
   Attribute *getAttr() { return &attr; }
};

PLIST(AttrView);
PITERATOR(AttrView);

class ViewBase : public RelObject
{
   PCLASS(ViewBase, RelObject)
public:
   ViewBase (const char *n, DataBase &p) : RelObject (n, p) {}
   ~ViewBase () { }
   virtual PBool Exists() { return PTrue; };
};

PLIST(ViewBase);
PITERATOR(ViewBase);

class RelView : public ViewBase
{
   PCLASS(RelView, ViewBase)
   PString viewStatement;
   TokenList from;
   PString join;
   PString where;
   AttrViewList fields;
public:
   RelView (const PString &n, DataBase &p);
   ~RelView ();
   void addField (const PString &name, Lex &l, Attribute &a) {
      fields.AddItem (new AttrView (name, l, a));
   }
   void setJoin (const PString &j) {
      join = j;
   }
   void setWhere (const PString &w) {
      where = w;
   }
   const PString & getWhere () {
      return where;
   }
   void addFrom (Token *t) {
      from.AddItem (t);
   }
   void headFrom (Token *t) {
      from.InsertItem (t);
   }
   TokenIterator getFrom () {
      return TokenIterator(from);
   }
   AttrViewIterator getFields () {
      return AttrViewIterator(fields);
   }
   virtual PBool Exists();
};

PLIST(RelView);

# endif

