/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef serchidx_h
# define serchidx_h "$Id: serchidx.h 5.3 2002/04/05 13:25:22 picoSoft Exp $"

# include "conditn.h"
# include "attribut.h"
extern "C" {
# include "isam.h"
}
                 
class StmtRel;
class SqlParser;
class Condition;
class ConditionList;
class Where;
class Expression;

class StartEnd : public PObject {
   ExpressionList exprToDelete;
   StmtAttrList attrToDelete;
public:
   StmtAttr *Attr;                
   Expression *CondStart;
   toknum OpStart;
   Expression *CondEnd;
   toknum OpEnd; 
   Expression *LikeCfrt;
   // StartEnd(StmtAttr *a, toknum t, StmtAttr *c);
   StartEnd() {  CondStart = CondEnd = LikeCfrt = 0;
                 OpStart = OpEnd = (toknum) 0; }
   ~StartEnd() {
                 Expression *ex;
                 StmtAttr *sa;
                 for (ex = exprToDelete.GetFirst(); ex; ex = exprToDelete.DeleteCurrent())
                    delete ex;
                 for (sa = attrToDelete.GetFirst(); sa; sa = attrToDelete.DeleteCurrent())
                    delete sa;
                 if (LikeCfrt) {
                    if (CondStart)
                       delete CondStart;
                    if (CondEnd)
                       delete CondEnd;
                    delete LikeCfrt;
                 }
               }
   void AddCondToDelete (Expression *a, toknum op, StmtAttr *sa) {
      Expression *cfrt = new Expression (0, sa);
      attrToDelete.AddItem (sa);
      exprToDelete.AddItem (a);
      exprToDelete.AddItem (cfrt);
      AddCond (a, op, cfrt);
   }
   void AddCond (Expression *a, toknum op, Expression *cfrt);
   void AndCond (StartEnd & se1, StartEnd & se2);
   void BuildLike();
};
                
PLIST(StartEnd);
PLIST(StartEndList);
class SearchIndex : public PObject { 
friend class Relation;
friend class StmtRel;
friend class SqlParser;
friend class Condition;
friend class DataBase;
   PCLASS (SearchIndex,PObject)
   short IndexNum;
   StmtAttr *FirstAttr;
   Relation *Rel;
   StartEndListList AttrsAndCond; 
   PBool JoinIndex;
   void Init(short indNum);
   void And (Where &w, ConditionList &cl);
   void Or (Where &w, ConditionList &cl);
   void NextCond (Where &w, ConditionList &cl); 
   void SortSELL();
public:
   struct keydesc  IsamKey; /* Struttura da isam.h */
   SearchIndex (short indNum) { Init (indNum); }
   ~SearchIndex ();
   void initKey();
   void AddAttr (StmtAttr *a);
   void Build (Where &w, ConditionList &cl);
   void Clear();
   PBool isJoinIndex() { return JoinIndex; }
   void CutJoinFields(StartEndList *sel);
   StmtAttr *getFirstAttr() { return FirstAttr; }
   PBool IsTrueCondEnd();
   PBool IsTrueCondStart();
   Relation * getRel() { return Rel; }
   int getIndexNum() { return IndexNum; }
};
PLIST(SearchIndex);

# endif

