/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef sort_h
# define sort_h "$Id: sort.h 5.0 1999/10/08 10:17:43 picoSoft Exp $"
# include "plist.h"
# include "pstring.h"
# include "datatype.h"
# include "odbcdate.h"
extern "C" {
# include <stdio.h>
}
             
int
StringCompare (register unsigned char * c1, unsigned int len1,
               register unsigned char * c2, unsigned int len2, 
                        unsigned char *coll, unsigned char fill);
class Sort;

class OrdCriteria  
{
friend class Sort;
   int dateLen;
   char *dateBuffer;
   TIMESTAMP_STRUCT *cfrt1, *cfrt2;
   void prepareDate ();
public:
   DataType type;
   int isSigned;
   int offs;
   int len;
   int isDesc;
   const char *dateFmt;
   unsigned char *coll;
   OrdCriteria() { cfrt1 = cfrt2 = 0; dateBuffer = 0; dateLen = 0; }
   ~OrdCriteria() {
      if (cfrt1)
         delete cfrt1;
      if (cfrt2)
         delete cfrt2;
      if (dateBuffer)
         delete dateBuffer;
   }
};

PCOPYLIST(OrdCriteria);

# ifndef MAX_PATH
# define MAX_PATH 144
# endif

class SortFile
{
   char FileName[MAX_PATH];
   // FILE *fp;
   int fd;
   size_t length;
   long prevDisp;
   long offsetRead;
   int Status;
public:
   char *Buffer;
   SortFile (int len);
   ~SortFile ();
   int Write (char *l);
   int Read ();
   int ReadPrev ();
   int SeekStart ();
   int SeekEnd ();
   int Create ();
   int OpenRead();
   void Close ();
   int GetStatus() { return Status; }
};
PLIST(SortFile);

class Sort : public PObject
{
   PCLASS(Sort, PObject)
   SortFile *FinalFile;        
   SortFileList Files; 
   OrdCriteriaCopyList &Order;
   int LineLen;
   char *IntBuffer;   
   char *CurOffset;
   char **Array; 
   int MaxElem;  
   int NumElem;
   int ReadElem;
   int TotElem;
   void Sorting (); 
   void InsertionSort(char *, int);
   void QuickSort(char *, int);
   int Merge ();
   int WriteBuffer ();
   SortFile * Create ();
   int Status;
   PBool Sorted;
   int MakeSort ();          
public:
   Sort (int len, OrdCriteriaCopyList &ord); 
   ~Sort ();
   int Write (char *line);
   int Read (char *);
   int ReadPrev (char *);
   int SeekStart ();
   int SeekEnd ();
   int Compare(unsigned char *l1, unsigned char *l2);
   int GetStatus () { return Status; }      
};
# endif
