/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# ifndef sortrel_h
# define sortrel_h "$Id: sortrel.h 5.0 1999/10/08 10:17:43 picoSoft Exp $"

# include "pstring.h"
# include "plist.h"
# include "relation.h" 
# include "attribut.h"
# include "stmtattr.h"

class SqlParser;
class Relation;

class SortRel : public PObject
{
   PCLASS(SortRel, PObject)
   PString       Name;
   char         *BufferSortRel;
   Relation     *Rel;
   PBool          FsOpen;      /* Flag di apertura */
   accessType    FsId;
   Error         isStatus;
   StmtAttrList  Fields;
   StmtAttrList  AuxFields;
   void Init() { FsOpen = PFalse; 
                 CurrIndex = 0;
                 isStatus = ENOTOPEN;
                 Rel = 0;
                 BufferSortRel = (char *)0;
               }
   void DeleteRel();
public:
   SortRel () { Init(); }
   SortRel (Relation &r){ Init();
                          Rel = &r;
                          Name = r.getName();
                          if (r.BufferLen > 0)
                             BufferSortRel = new char [r.BufferLen];
                        }
   SortRel (Relation &r, const PString & n) {
                         Init();
                         Rel = &r;
                         if (n.size() == 0)
                            Name = Rel->getName();
                         else
                            Name = n;
                          if (r.BufferLen > 0)
                             BufferSortRel = new char [r.BufferLen];
                         }
   SortRel(char *n, DataBase &d) {
                         Init();
                         Rel = new Relation (n, d);
                         Name = n;
                         }
   ~SortRel ();
   PString & getName () { return Name; }
   Relation * getRel() { if (this != 0)
                            return Rel;
                         else
                            return 0; }
   void SetRel (StmtAttrList &sal, DataBase &d) {
                         Attribute *a;
                         Init();
                         Rel = new Relation (sal, d);
                         Name = Rel->getName();
                         for (a = Rel->VisAttrs.GetFirst();
                              a != 0;
                              a = Rel->VisAttrs.GetNext())
                            Fields.AddItem (new StmtAttr (*a, this));
                         }
   void BufferSortRelAlloc() { 
                         Rel->BufferAlloc();
                         if (Rel->BufferLen > 0)
                           BufferSortRel = new char [Rel->BufferLen];
                         }
   Error Create ();
   Error Drop();
   Error Open ();
   Error Write ();
   Error Start ();
   Error ReadNext ();
   void Close ();
};

PLIST(SortRel);
# endif 
