/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include "trace.h"
static char rcsid[] = "$Id: trace.cpp 5.3 2001/04/19 09:12:50 picoSoft Exp $";
static char rcsidh[] = trace_h;

# include "pstring.h"
extern "C" {
# include <errno.h>
# include <stdio.h>
# include <stdarg.h>
# include <string.h> 
# ifdef MSDOS
# include <windows.h>
# include <io.h>
# include <fcntl.h>
# define strlen      lstrlen
# else
# include <fcntl.h>
# include <unistd.h>
# endif
};
                 

Log Trace = { -1, 0 };
 
void
Log::Open (char * fileName)
{
   char name[32];
   if (fd >= 0)
      return;
# ifdef MSDOS
   strcpy (name, "C:\\PICOSQL.LOG");
   fd = open(name, O_WRONLY|O_APPEND|O_CREAT|O_TEXT, 0644);
# else
   sprintf (name, "/tmp/PICOSQL%d.log", getpid());
   fd = open(name, O_WRONLY|O_APPEND|O_CREAT, 0644);
# endif
}
 
void
Log::Close ()
{  
   if (fd >= 0)
      close(fd);
   fd = -1; 
}

void
Log::Write (char *fmt ... )
{ 
   char *buffer = new char[strlen(fmt) + 128];
   va_list a;
   
   if (fd >= 0) {
      va_start(a, fmt);
      vsprintf(buffer, fmt, a);
      write(fd, buffer, strlen(buffer));
   }

   delete buffer;
}

void
Log::WriteNoFmt (char *buffer)
{  
   if (fd >= 0) {
      write(fd, buffer, strlen(buffer));
   }
}
