/*
_____       _    _    Corso   Italia,  178
(_|__   .  (_   |_|_  56125           Pisa
(_|_) |)|(()_)()| |   tel.  +39  050 46380
  |   |               picosoft@picosoft.it

 Copyright (C) Picosoft s.r.l. 1995-2002

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2, or (at your option)
 any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
# include <stdio.h>
# include <ctype.h>
# include <stdlib.h>
# include <string.h>
# include "win4unix.h"
static char *rcsid = "$Id$";
static char *rcsidh = win4unix_h;

static int
FindStr (const char *key, const char *buf)
{
   for ( ; *key; key++, buf++)
      if (toupper(*key) != toupper(*buf))
         return 0;
   if (*buf == '=')
      return 1;
   else
      return 0;
}

static int
FindSec(const char *key, const char *buf)
{
   if (*buf++ == '[')
      for ( ; *key; key++, buf++)
         if (toupper(*key) != toupper(*buf))
            return 0;
   if (*buf == ']')
      return 1;
   else
      return 0;
}

long
RegOpenKeyEx (HKEY hk ,char *subKey, long res, long access, HKEY* myKey)
{
   char buffer[255];
   long Return;
   char *pnt;

   *myKey = (HKEY) malloc (sizeof(struct tagHKEY));
   if (( pnt = strrchr (subKey, '\\')) != 0)
      (*myKey)->sec = strdup (pnt + 1);
   else
      (*myKey)->sec = strdup (subKey);

   if (hk == HKEY_CURRENT_USER) {
      if (!(pnt = getenv ("HOME")))
         pnt = "";
      sprintf (buffer, "%s/.%s", pnt, "picosql.ini");
      (*myKey)->fp = fopen (buffer, "r");
      if ((*myKey)->fp != NULL) {
         while (pnt = fgets (buffer, sizeof(buffer), (*myKey)->fp))
            if (FindSec ((*myKey)->sec, buffer))
               break;
         if (!pnt) {
            fclose ((*myKey)->fp);
            (*myKey)->fp = NULL;
         }
      }
   } else if (hk == HKEY_LOCAL_MACHINE) {
      sprintf (buffer, "/etc/%s", "picosql.ini");
      (*myKey)->fp = fopen (buffer, "r");
      if ((*myKey)->fp != NULL) {
         while (pnt = fgets (buffer, sizeof(buffer), (*myKey)->fp))
            if (FindSec ((*myKey)->sec, buffer))
               break;
         if (!pnt) {
            fclose ((*myKey)->fp);
            (*myKey)->fp = NULL;
         }
      }
   }
   if ((*myKey)->fp == NULL) {
      free ((*myKey)->sec);
      free (*myKey);
      *myKey = (HKEY) 0;
      Return = 2;
   } else
      Return = 0;
   return Return;
}

long
RegQueryValueEx (HKEY myKey, const char *key, long *res,
                 long *type, unsigned char* value, unsigned long *lenValue)
{
   unsigned long Return = 2;
   char buffer[255];
   char *pnt;
   long outLen;
   
   if (myKey->fp != NULL) {
      rewind (myKey->fp);
      while (fgets (buffer, sizeof(buffer), myKey->fp))
         if (FindSec (myKey->sec, buffer)) {
            while (fgets(buffer,sizeof(buffer),myKey->fp) && buffer[0] != '[')
              if (FindStr (key, buffer)) {
                 if (pnt = strchr(buffer, '\n'))
                    *pnt = '\0';
                 pnt = strchr(buffer, '=') + 1;
                 outLen = strlen (pnt);
                 if (outLen > *lenValue - 1)
                    outLen = *lenValue - 1;
                 strncpy((char *)value, pnt, outLen);
                 value[outLen] = 0;
                 *lenValue = outLen;
                 *type = REG_SZ;
                 Return = 0;
                 break;
              }
            break;
         }
   }
   return Return;
}

long
RegCloseKey (HKEY myKey)
{
   fclose (myKey->fp);
   free (myKey->sec);
   free (myKey);
   return 0;
}
