<?php
   $dsn = "picoSqlTest";
   $dbuser = "";
   $dbpwd = "";
   echo "Connecting to $dsn as $dbuser\n";
   $conn = odbc_connect($dsn,$dbuser,$dbpwd);
   if(!$conn){
      echo "Error connecting to database! Check DSN, username and password\n";
      exit;
   } else {
      echo "Connection successful\n";
      echo "Dropping table php3_test\n";
      Error_Reporting(0);
      $res = odbc_exec($conn,"drop table php_test");
      if ($res){
         odbc_free_result($res);
      }
      echo "Create table php_test\n";
      error_reporting(1);
      $res = odbc_exec($conn, 'create table php_test (a char(16), b integer, c float, d varchar(128))');
      if ($res) {
         odbc_free_result($res);
         echo "OK\n";
         echo "Table Info\n";
         $info = odbc_exec($conn,"select * from php_test");
         $numfields = odbc_num_fields($info);
         for($i=1; $i<=$numfields; $i++){
            echo odbc_field_name($info, $i);
            echo ", ";
            echo odbc_field_type($info, $i);
            echo ", ";
            echo odbc_field_len($info,$i);
            echo "\n";
         }
      } else {
         echo "$res KO\n";
      }
      echo "Inserting into table php_test\n";
      $sqlfloat = '00.0';
      $sqlint = 1000;
      $stmt = odbc_prepare($conn, "insert into php_test values(?,?,?,?)");
      for ($i=1; $i<=5; $i++){
         $values[0] = "test-$i";
         $values[1] = $sqlint + $i;
         $values[2] = $i . $sqlfloat . $i;
         $values[3] = "php - values $i";
         $ret = odbc_execute($stmt, &$values);
      }
      odbc_free_result($stmt);
      $res = odbc_exec($conn, "select count(*) from php_test");
      if ($res && (odbc_result($res, 1) == 5)){
         odbc_free_result($res);
         echo "OK The table php_test should now contain the following values\n";
         echo "test-1, 1001, 100.01, php - values 1\n";
         echo "test-2, 1002, 200.02, php - values 2\n";
         echo "test-3, 1003, 300.03, php - values 3\n";
         echo "test-4, 1004, 400.04, php - values 4\n";
         echo "test-5, 1005, 500.05, php - values 5\n";
         echo "Actual contents of table php_test\n";
         $res = odbc_exec($conn, "select * from php_test");
         odbc_result_all($res);
      } else {
         echo "Error on insert, count(*) = ";
         echo odbc_result($res, 1);
         echo "\n";
      }
      odbc_autocommit($conn, 0);
      if(($result = odbc_do($conn, 'select * from php_test where b>1002 for update'))){
         $cursor = odbc_cursor($result);
         echo "cursor=[$cursor]\n";
         if(($upd = odbc_prepare($conn,"update php_test set a=?, b=? where current of $cursor"))){
            while(odbc_fetch_row($result)) {
               $params[0] = odbc_result($result, 1) . "(*)";
               $params[1] = odbc_result($result, 2) + 2000;
               odbc_execute($upd, $params);
            }
            odbc_commit($conn);
         }
      }
      if($result && $upd){
         echo "OK The table should now contain the following values:\n";
         echo "test-1, 1001, 100.01, php3 - values 1\n";
         echo "test-2, 1002, 200.02, php - values 2\n";
         echo "test-3(*), 3003, 300.03, php - values 3\n";
         echo "test-4(*), 3004, 400.04, php - values 4\n";
         echo "test-5(*), 3005, 500.05, php - values 5\n";

         echo "Actual contents of table php_test:\n";
         $res = odbc_exec($conn,"select * from php_test");
         odbc_result_all($res);
      }else{
         echo "Your driver obviously doesn't support positioned updates\n<p>";
      }
   }
?>
