/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

class IOR {
    private String ior = "";

    private static String intToHex(int n, int n2) {
        String string = Integer.toHexString(n).toUpperCase();
        while (string.length() < 2 * n2) {
            string = "0" + string;
        }
        return string;
    }

    private static String charToHexString(char c) {
        return Integer.toHexString(c).toUpperCase();
    }

    private static String stringToHexString(String string) {
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            string2 = string2 + IOR.charToHexString(string.charAt(n++));
        }
        return string2 + "00";
    }

    public IOR(String string, String string2, int n, String string3) {
        this.buildHead(string);
        this.buildProfile(string2, n, string3);
        this.ior = "IOR:" + this.ior;
    }

    private void addPad(int n) {
        while (this.ior.length() % (2 * n) > 0) {
            this.ior = this.ior + "00";
        }
    }

    private void addInt(int n, int n2) {
        this.addPad(n2);
        this.ior = this.ior + IOR.intToHex(n, n2);
    }

    private void addString(String string) {
        this.addInt(string.length() + 1, 4);
        this.ior = this.ior + IOR.stringToHexString(string);
    }

    private void buildHead(String string) {
        this.addInt(0, 1);
        this.addString(string);
        this.addInt(1, 4);
    }

    private void buildProfile(String string, int n, String string2) {
        this.addInt(0, 4);
        int n2 = this.ior.length();
        this.addInt(0, 1);
        this.addInt(1, 1);
        this.addInt(0, 1);
        this.addString(string);
        this.addInt(n, 2);
        this.addString(string2);
        this.ior = this.ior.substring(0, n2) + IOR.intToHex((this.ior.length() - n2) / 2, 4) + this.ior.substring(n2);
    }

    public String toString() {
        return this.ior;
    }
}

