/*
 * Decompiled with CFR 0.152.
 */
package IT.picosoft.jdbc;

import IT.picosoft.jdbc.OdbcStatement;
import IT.picosoft.jdbc.PicoDbApi;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Statement;

public class PicoInputStream
extends InputStream {
    protected PicoDbApi odbcApi;
    protected OdbcStatement hStmt;
    protected int column;
    protected short type;
    public static final short ASCII = 1;
    public static final short UNICODE = 2;
    public static final short BINARY = 3;
    public static final short LOCAL = 4;
    protected byte[] localByteArray;
    protected int localOffset;
    protected boolean invalid;
    protected boolean highRead;
    protected int sqlType;
    protected byte[] buf;
    public static final int MAX_BUF_LEN = 5120;
    protected int convertType;
    public static final int CONVERT_NONE = 0;
    public static final int CONVERT_UNICODE = 1;
    public static final int CONVERT_ASCII = 2;
    public static final int CONVERT_BOTH = 3;
    protected int convertMultiplier;
    protected int bytesInBuf;
    protected int bufOffset;
    protected Statement ownerStatement;

    public PicoInputStream(PicoDbApi picoDbApi, OdbcStatement odbcStatement, int n, short s, int n2, Statement statement) {
        this.odbcApi = picoDbApi;
        this.hStmt = odbcStatement;
        this.column = n;
        this.type = s;
        this.invalid = false;
        this.ownerStatement = statement;
        this.sqlType = -2;
        switch (n2) {
            case -1: 
            case 1: 
            case 12: {
                this.sqlType = 1;
            }
        }
        this.convertMultiplier = 1;
        this.convertType = 0;
        switch (this.type) {
            default: {
                break;
            }
            case 1: {
                if (this.sqlType != -2) break;
                this.convertMultiplier = 2;
                this.convertType = 2;
                break;
            }
            case 2: {
                if (this.sqlType == -2) {
                    this.convertType = 3;
                    this.convertMultiplier = 4;
                    break;
                }
                this.convertType = 1;
                this.convertMultiplier = 2;
            }
        }
        this.buf = new byte[5120 * this.convertMultiplier];
        this.bytesInBuf = 0;
        this.bufOffset = 0;
    }

    public PicoInputStream(PicoDbApi picoDbApi, OdbcStatement odbcStatement, int n, byte[] byArray) {
        this.odbcApi = picoDbApi;
        this.hStmt = odbcStatement;
        this.column = n;
        this.type = (short)4;
        this.localByteArray = byArray;
        this.localOffset = 0;
        this.invalid = false;
    }

    public int available() throws IOException {
        throw new IOException();
    }

    protected int convertData(byte[] byArray, int n) {
        if (this.convertType == 0) {
            return n;
        }
        String string = "0123456789ABCDEF";
        if (n <= 0) {
            return n;
        }
        for (int i = n - 1; i >= 0; --i) {
            if (this.convertType == 3) {
                byArray[i * 4 + 3] = (byte)string.charAt(byArray[i] & 0xF);
                byArray[i * 4 + 2] = 0;
                byArray[i * 4 + 1] = (byte)string.charAt(byArray[i] >> 4 & 0xF);
                byArray[i * 4] = 0;
                continue;
            }
            if (this.convertType == 2) {
                byArray[i * 2 + 1] = (byte)string.charAt(byArray[i] & 0xF);
                byArray[i * 2] = (byte)string.charAt(byArray[i] >> 4 & 0xF);
                continue;
            }
            byArray[i * 2 + 1] = byArray[i];
            byArray[i * 2] = 0;
        }
        return n * this.convertMultiplier;
    }

    public void invalidate() {
        this.invalid = true;
    }

    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray);
        if (n != -1) {
            n = byArray[0] & 0xFF;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        if (byArray.length == 0) {
            return -1;
        }
        int n = 0;
        if (this.invalid) {
            throw new IOException("InputStream is no longer valid - the Statement has been closed, or the cursor has been moved");
        }
        switch (this.type) {
            case 4: {
                n = byArray.length;
                if (this.localOffset + n > this.localByteArray.length) {
                    n = this.localByteArray.length - this.localOffset;
                }
                if (n == 0) {
                    n = -1;
                    break;
                }
                for (int i = 0; i < n; ++i) {
                    byArray[i] = this.localByteArray[this.localOffset + i];
                }
                this.localOffset += n;
                break;
            }
            default: {
                n = this.readData(byArray);
            }
        }
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        throw new IOException("Method not implemented");
    }

    protected int readBinaryData(byte[] byArray, int n) throws IOException {
        throw new IOException("Method not implemented");
    }

    protected int readData(byte[] byArray) throws IOException {
        int n = -1;
        int n2 = 0;
        while (this.bytesInBuf != -1 && n2 < byArray.length) {
            if (this.bufOffset >= this.bytesInBuf) {
                this.bytesInBuf = this.readBinaryData(this.buf, 5120);
                this.bytesInBuf = this.convertData(this.buf, this.bytesInBuf);
                this.bufOffset = 0;
                continue;
            }
            byArray[n2] = this.buf[this.bufOffset];
            ++n2;
            ++this.bufOffset;
        }
        if (n2 > 0) {
            n = n2;
        }
        return n;
    }
}

